/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.vfs2.util.Cryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCryptor
implements Cryptor {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] KEY_BYTES = new byte[]{65, 112, 97, 99, 104, 101, 67, 111, 109, 109, 111, 110, 115, 86, 70, 83};
    private static final int INDEX_NOT_FOUND = -1;
    private static final int BITS_IN_HALF_BYTE = 4;
    private static final char MASK = '\u000f';

    @Override
    @NotNull
    public String encrypt(@NotNull String plainKey) throws Exception {
        byte[] input = plainKey.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec key = new SecretKeySpec(KEY_BYTES, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] cipherText = new byte[cipher.getOutputSize(input.length)];
        int ctLength = cipher.update(input, 0, input.length, cipherText, 0);
        cipher.doFinal(cipherText, ctLength);
        return this.encode(cipherText);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encryptedKey) throws Exception {
        SecretKeySpec key = new SecretKeySpec(KEY_BYTES, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] decoded = this.decode(encryptedKey);
        byte[] plainText = new byte[cipher.getOutputSize(decoded.length)];
        int ptLength = cipher.update(decoded, 0, decoded.length, plainText, 0);
        ptLength += cipher.doFinal(plainText, ptLength);
        return new String(plainText, StandardCharsets.UTF_8).substring(0, ptLength);
    }

    @NotNull
    private String encode(byte @NotNull [] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(HEX_CHARS[b >> 4 & 0xF]);
            builder.append(HEX_CHARS[b & 0xF]);
        }
        return builder.toString();
    }

    private byte @NotNull [] decode(@NotNull String str) {
        char[] chars = str.toCharArray();
        int length = chars.length / 2;
        byte[] decoded = new byte[length];
        if (length * 2 != chars.length) {
            throw new IllegalArgumentException("The given string must have even number of hex chars.");
        }
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int id2;
            int id1;
            if ((id1 = this.indexOf(HEX_CHARS, chars[index++])) == -1) {
                throw new IllegalArgumentException("Character " + chars[index - 1] + " at position " + (index - 1) + " is not a valid hexidecimal character");
            }
            if ((id2 = this.indexOf(HEX_CHARS, chars[index++])) == -1) {
                throw new IllegalArgumentException("Character " + chars[index - 1] + " at position " + (index - 1) + " is not a valid hexidecimal character");
            }
            decoded[i] = (byte)(id1 << 4 | id2);
        }
        return decoded;
    }

    private int indexOf(char @Nullable [] array, char valueToFind) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }
}

