/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.util.JDOMUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InspectionDiff {
    private static HashMap<String, ArrayList<Element>> ourFileToProblem;
    @NonNls
    private static final String FILE_ELEMENT = "file";
    @NonNls
    private static final String CLASS_ELEMENT = "class";
    @NonNls
    private static final String FIELD_ELEMENT = "field";
    @NonNls
    private static final String METHOD_ELEMENT = "method";
    @NonNls
    private static final String CONSTRUCTOR_ELEMENT = "constructor";
    @NonNls
    private static final String INTERFACE_ELEMENT = "interface";
    @NonNls
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    @NonNls
    private static final String DESCRIPTION_ELEMENT = "description";

    InspectionDiff() {
    }

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 2) {
            System.out.println(InspectionsBundle.message((String)"inspection.diff.format.error", (Object[])new Object[0]));
        }
        String oldPath = args[0];
        String newPath = args[1];
        String outPath = args.length == 3 ? args[2] : null;
        File oldResults = new File(oldPath);
        File newResults = new File(newPath);
        if (oldResults.isDirectory() && newResults.isDirectory()) {
            File[] results;
            File[] old = oldResults.listFiles();
            for (File result : results = newResults.listFiles()) {
                String inspectionName = result.getName();
                boolean found = false;
                for (File oldFile : old) {
                    if (!oldFile.getName().equals(inspectionName)) continue;
                    InspectionDiff.writeInspectionDiff(oldFile.getPath(), result.getPath(), outPath);
                    found = true;
                    break;
                }
                if (found) continue;
                InspectionDiff.writeInspectionDiff(null, result.getPath(), outPath);
            }
        }
    }

    private static void writeInspectionDiff(String oldPath, String newPath, String outPath) {
        try {
            Element oldDoc = oldPath == null ? null : JDOMUtil.load((Path)Path.of(oldPath, new String[0]));
            Element newDoc = JDOMUtil.load((Path)Path.of(newPath, new String[0]));
            FilterOutputStream outStream = System.out;
            if (outPath != null) {
                outStream = new BufferedOutputStream(new FileOutputStream(outPath + File.separator + new File(newPath).getName()));
            }
            Document delta = InspectionDiff.createDelta(oldDoc, newDoc);
            JDOMUtil.writeDocument((Document)delta, (OutputStream)outStream, (String)"\n");
            if (outStream != System.out) {
                ((OutputStream)outStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private static Document createDelta(@Nullable Element oldRoot, Element newRoot) {
        ourFileToProblem = new HashMap();
        List newProblems = newRoot.getChildren("problem");
        for (Element problem : newProblems) {
            InspectionDiff.addProblem(problem);
        }
        if (oldRoot != null) {
            for (Element oldProblem : oldRoot.getChildren("problem")) {
                if (InspectionDiff.removeIfEquals(oldProblem)) continue;
                InspectionDiff.addProblem(oldProblem);
            }
        }
        Element root = new Element("problems");
        Document delta = new Document(root);
        for (ArrayList<Element> fileList : ourFileToProblem.values()) {
            if (fileList == null) continue;
            for (Element element : fileList) {
                root.addContent(element.clone());
            }
        }
        Document document = delta;
        if (document == null) {
            InspectionDiff.$$$reportNull$$$0(0);
        }
        return document;
    }

    private static boolean removeIfEquals(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Element> problemList = ourFileToProblem.get(fileName);
        if (problemList != null) {
            Element[] problems;
            for (Element toCheck : problems = problemList.toArray(new Element[0])) {
                if (!InspectionDiff.equals(problem, toCheck)) continue;
                return problemList.remove(toCheck);
            }
        }
        return false;
    }

    private static void addProblem(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Object> problemList = ourFileToProblem.get(fileName);
        if (problemList == null) {
            problemList = new ArrayList();
            ourFileToProblem.put(fileName, problemList);
        }
        problemList.add(problem);
    }

    private static boolean equals(Element oldProblem, Element newProblem) {
        if (!Objects.equals(oldProblem.getChildText(CLASS_ELEMENT), newProblem.getChildText(CLASS_ELEMENT))) {
            return false;
        }
        if (!Objects.equals(oldProblem.getChildText(FIELD_ELEMENT), newProblem.getChildText(FIELD_ELEMENT))) {
            return false;
        }
        if (!Objects.equals(oldProblem.getChildText(METHOD_ELEMENT), newProblem.getChildText(METHOD_ELEMENT))) {
            return false;
        }
        if (!Objects.equals(oldProblem.getChildText(CONSTRUCTOR_ELEMENT), newProblem.getChildText(CONSTRUCTOR_ELEMENT))) {
            return false;
        }
        if (!Objects.equals(oldProblem.getChildText(INTERFACE_ELEMENT), newProblem.getChildText(INTERFACE_ELEMENT))) {
            return false;
        }
        if (!Objects.equals(oldProblem.getChildText(PROBLEM_CLASS_ELEMENT), newProblem.getChildText(PROBLEM_CLASS_ELEMENT))) {
            return false;
        }
        return Objects.equals(oldProblem.getChildText(DESCRIPTION_ELEMENT), newProblem.getChildText(DESCRIPTION_ELEMENT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionDiff", "createDelta"));
    }
}

