/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.Stack;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.LighterAstNodeHashCache;
import com.jetbrains.clones.core.NodeInfo;
import com.jetbrains.clones.core.NodeState;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.structures.CodeFragment;
import com.jetbrains.clones.structures.HashFragment;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/clones/core/HashFragmentCollector;", "", "ast", "Lcom/intellij/lang/LighterAST;", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "<init>", "(Lcom/intellij/lang/LighterAST;Lcom/jetbrains/clones/languagescope/DuplicateScope;)V", "getAst", "()Lcom/intellij/lang/LighterAST;", "getScope", "()Lcom/jetbrains/clones/languagescope/DuplicateScope;", "stack", "Lcom/intellij/util/containers/Stack;", "Lcom/jetbrains/clones/core/NodeState;", "collector", "", "Lcom/jetbrains/clones/structures/HashFragment;", "cache", "Lcom/jetbrains/clones/core/LighterAstNodeHashCache;", "windowSize", "", "nextNodeId", "generateNextId", "processNode", "", "nodeInfo", "Lcom/jetbrains/clones/core/NodeInfo;", "children", "", "createInitialNodeState", "node", "Lcom/intellij/lang/LighterASTNode;", "next", "traverse", "getCollectedFragments", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nHashFragmentCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashFragmentCollector.kt\ncom/jetbrains/clones/core/HashFragmentCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1869#2:110\n1869#2,2:111\n1870#2:113\n1869#2,2:114\n1#3:116\n*S KotlinDebug\n*F\n+ 1 HashFragmentCollector.kt\ncom/jetbrains/clones/core/HashFragmentCollector\n*L\n50#1:110\n52#1:111,2\n50#1:113\n66#1:114,2\n*E\n"})
final class HashFragmentCollector {
    @NotNull
    private final LighterAST ast;
    @NotNull
    private final DuplicateScope scope;
    @NotNull
    private final Stack<NodeState> stack;
    @NotNull
    private final List<HashFragment> collector;
    @NotNull
    private final LighterAstNodeHashCache cache;
    private final int windowSize;
    private int nextNodeId;

    public HashFragmentCollector(@NotNull LighterAST ast, @NotNull DuplicateScope scope) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.ast = ast;
        this.scope = scope;
        this.stack = new Stack();
        this.collector = new ArrayList();
        this.cache = new LighterAstNodeHashCache();
        this.windowSize = this.scope.getIndexConfiguration().getWindowSize();
        this.nextNodeId = 1;
    }

    @NotNull
    public final LighterAST getAst() {
        return this.ast;
    }

    @NotNull
    public final DuplicateScope getScope() {
        return this.scope;
    }

    private final int generateNextId() {
        int n = this.nextNodeId;
        this.nextNodeId = n + 1;
        return n;
    }

    private final void processNode(NodeInfo nodeInfo, List<NodeInfo> children) {
        LighterASTNode node = nodeInfo.getNode();
        if (nodeInfo.getWeight() >= this.windowSize) {
            if (!this.scope.isIgnoredAsDuplicate(this.ast, node)) {
                TextRange textRange = new TextRange(node.getStartOffset(), node.getEndOffset());
                HashFragment hashFragment = new HashFragment(nodeInfo.getHash(), CodeFragment.Companion.of(textRange));
                this.collector.add(hashFragment);
            }
            if (this.scope.shouldAnalyzeChildSubsequences(this.ast, node)) {
                int parentNodeId = this.generateNextId();
                List nodesWithIndex = CollectionsKt.toList((Iterable)CollectionsKt.withIndex((Iterable)children));
                List windows = CommonUtilsKt.weightedWindow(nodesWithIndex, this.windowSize, HashFragmentCollector::processNode$lambda$0);
                Iterable $this$forEach$iv = windows;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List nodeRange = (List)element$iv;
                    boolean bl = false;
                    long hash = 0L;
                    Iterable $this$forEach$iv2 = nodeRange;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        IndexedValue it = (IndexedValue)element$iv2;
                        boolean bl2 = false;
                        hash = (long)37 * hash + ((NodeInfo)it.getValue()).getHash();
                    }
                    IndexedValue firstNode = (IndexedValue)CollectionsKt.first((List)nodeRange);
                    IndexedValue lastNode = (IndexedValue)CollectionsKt.last((List)nodeRange);
                    TextRange textRange = new TextRange(((NodeInfo)firstNode.getValue()).getNode().getStartOffset(), ((NodeInfo)lastNode.getValue()).getNode().getEndOffset());
                    CodeFragment codeFragment = CodeFragment.Companion.of(parentNodeId, new IntRange(firstNode.getIndex(), lastNode.getIndex()), textRange);
                    this.collector.add(new HashFragment(hash, codeFragment));
                }
            }
        }
    }

    private final NodeState createInitialNodeState(LighterASTNode node) {
        List list = this.ast.getChildren(node);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        List children = list;
        ArrayDeque<LighterASTNode> unprocessedQueue = new ArrayDeque<LighterASTNode>(children.size());
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LighterASTNode it = (LighterASTNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.scope.isNoise(this.ast, it)) continue;
            unprocessedQueue.addLast(it);
        }
        return new NodeState(node, new ArrayList(children.size()), (Deque<LighterASTNode>)unprocessedQueue);
    }

    /*
     * WARNING - void declaration
     */
    private final void next() {
        NodeState head = (NodeState)this.stack.pop();
        if (!head.getUnprocessedChildren().isEmpty()) {
            LighterASTNode childNode = head.getUnprocessedChildren().removeFirst();
            if (childNode instanceof LighterASTTokenNode) {
                long hash = this.scope.hashOf(this.cache, this.ast, childNode, CollectionsKt.emptyList());
                int weight = this.scope.weightOf(this.ast, childNode);
                head.getProcessedChildren().add(new NodeInfo(childNode, hash, weight));
                this.stack.push((Object)head);
            } else {
                this.stack.push((Object)head);
                Intrinsics.checkNotNull((Object)childNode);
                this.stack.push((Object)this.createInitialNodeState(childNode));
            }
        } else {
            int n;
            long hash = this.scope.hashOf(this.cache, this.ast, head.getNode(), head.getProcessedChildren());
            Iterable weight = head.getProcessedChildren();
            int n2 = this.scope.weightOf(this.ast, head.getNode());
            int n3 = 0;
            for (Object t : weight) {
                void it;
                NodeInfo nodeInfo = (NodeInfo)t;
                n = n3;
                boolean bl = false;
                int n4 = it.getWeight();
                n3 = n + n4;
            }
            n = n3;
            int weight2 = n2 + n;
            NodeInfo nodeInfo = new NodeInfo(head.getNode(), hash, weight2);
            this.processNode(nodeInfo, head.getProcessedChildren());
            if (!((Collection)this.stack).isEmpty()) {
                NodeState parent = (NodeState)this.stack.pop();
                parent.getProcessedChildren().add(nodeInfo);
                this.stack.push((Object)parent);
            }
        }
    }

    public final void traverse(@NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.stack.push((Object)this.createInitialNodeState(node));
        while (!((Collection)this.stack).isEmpty()) {
            this.next();
        }
    }

    @NotNull
    public final List<HashFragment> getCollectedFragments() {
        return this.collector;
    }

    private static final int processNode$lambda$0(IndexedValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((NodeInfo)it.getValue()).getWeight();
    }
}

