/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.actions;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Ref;
import com.intellij.util.text.SemVer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipSuspendContextManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/actions/JSRestartFrameAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "hideAction", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.javascript.debugger"})
public final class JSRestartFrameAction
extends AnAction {
    public JSRestartFrameAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setText(JSDebuggerBundle.message("js.restart.frame.text", new Object[0]));
        presentation2.setDescription(JSDebuggerBundle.message("js.restart.frame.description", new Object[0]));
        presentation2.setIcon(AllIcons.Actions.RestartFrame);
    }

    public void update(@NotNull AnActionEvent e) {
        SemVer version;
        RunProfile runProfile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        if (xDebugSession == null) {
            this.hideAction(e);
            return;
        }
        XDebugSession session2 = xDebugSession;
        XStackFrame xStackFrame = session2.getCurrentStackFrame();
        CallFrameView callFrameView = xStackFrame instanceof CallFrameView ? (CallFrameView)xStackFrame : null;
        if (callFrameView == null) {
            this.hideAction(e);
            return;
        }
        CallFrameView stackFrame = callFrameView;
        Vm vm = stackFrame.getVm();
        SuspendContextManager suspendContextManager = vm != null ? vm.getSuspendContextManager() : null;
        WipSuspendContextManager wipSuspendContextManager = suspendContextManager instanceof WipSuspendContextManager ? (WipSuspendContextManager)suspendContextManager : null;
        if (wipSuspendContextManager == null) {
            this.hideAction(e);
            return;
        }
        WipSuspendContextManager suspendContextManager2 = wipSuspendContextManager;
        if (!suspendContextManager2.isRestartFrameSupported()) {
            this.hideAction(e);
            return;
        }
        CallFrame callFrame = stackFrame.getCallFrame();
        if (!suspendContextManager2.canRestartFrame(callFrame)) {
            this.hideAction(e);
            return;
        }
        XDebugSessionImpl xDebugSessionImpl = session2 instanceof XDebugSessionImpl ? (XDebugSessionImpl)session2 : null;
        RunProfile runProfile2 = runProfile = xDebugSessionImpl != null && (xDebugSessionImpl = xDebugSessionImpl.getExecutionEnvironment()) != null ? xDebugSessionImpl.getRunProfile() : null;
        NodeDebugRunConfiguration nodeDebugRunConfiguration = runProfile instanceof NodeDebugRunConfiguration ? (NodeDebugRunConfiguration)runProfile : null;
        if (nodeDebugRunConfiguration == null || (nodeDebugRunConfiguration = nodeDebugRunConfiguration.getInterpreter()) == null) {
            this.hideAction(e);
            return;
        }
        NodeDebugRunConfiguration interpreter = nodeDebugRunConfiguration;
        Ref ref = interpreter.getCachedVersion();
        Object object = version = ref != null ? (SemVer)ref.get() : null;
        if (version == null) {
            interpreter.fetchVersion(arg_0 -> JSRestartFrameAction.update$lambda$1(JSRestartFrameAction::update$lambda$0, arg_0));
            this.hideAction(e);
            return;
        }
        e.getPresentation().setEnabledAndVisible(!version.isGreaterOrEqualThan(17, 0, 0));
    }

    private final void hideAction(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session2 = xDebugSession;
        XStackFrame xStackFrame = session2.getCurrentStackFrame();
        CallFrameView callFrameView = xStackFrame instanceof CallFrameView ? (CallFrameView)xStackFrame : null;
        if (callFrameView == null) {
            return;
        }
        CallFrameView stackFrame = callFrameView;
        Vm vm = stackFrame.getVm();
        SuspendContextManager suspendContextManager = vm != null ? vm.getSuspendContextManager() : null;
        WipSuspendContextManager wipSuspendContextManager = suspendContextManager instanceof WipSuspendContextManager ? (WipSuspendContextManager)suspendContextManager : null;
        if (wipSuspendContextManager == null) {
            return;
        }
        WipSuspendContextManager suspendContextManager2 = wipSuspendContextManager;
        CallFrame callFrame = stackFrame.getCallFrame();
        WipCallFrame wipCallFrame = callFrame instanceof WipCallFrame ? (WipCallFrame)callFrame : null;
        if (wipCallFrame == null) {
            return;
        }
        WipCallFrame callFrame2 = wipCallFrame;
        suspendContextManager2.restartFrame(callFrame2).onSuccess(arg_0 -> JSRestartFrameAction.actionPerformed$lambda$3(arg_0 -> JSRestartFrameAction.actionPerformed$lambda$2(session2, arg_0), arg_0));
    }

    private static final Unit update$lambda$0(SemVer it) {
        ActivityTracker.getInstance().inc();
        return Unit.INSTANCE;
    }

    private static final void update$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit actionPerformed$lambda$2(XDebugSession $session, Boolean it) {
        XSuspendContext xSuspendContext = $session.getSuspendContext();
        Intrinsics.checkNotNull((Object)xSuspendContext);
        $session.positionReached(xSuspendContext);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

