/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.toolbar.combobox;

import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.connection.CwmConnectionStatusService;
import com.intellij.cwm.plugin.common.toolbar.CWMPopupHandler;
import com.intellij.cwm.plugin.common.toolbar.combobox.CWMLicenseFooter;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.codeWithMe.model.CWMSessionStatus;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"formatDuration", "", "Lcom/intellij/openapi/util/NlsSafe;", "statusService", "Lcom/intellij/cwm/plugin/common/connection/CwmConnectionStatusService;", "duration", "Ljava/time/Duration;", "registerFooter", "", "licenseFooter", "Lcom/intellij/cwm/plugin/common/toolbar/combobox/CWMLicenseFooter;", "userManager", "Lcom/intellij/cwm/plugin/common/users/UserManager;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nCWMLicenseFooter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CWMLicenseFooter.kt\ncom/intellij/cwm/plugin/common/toolbar/combobox/CWMLicenseFooterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class CWMLicenseFooterKt {
    @NlsSafe
    private static final String formatDuration(CwmConnectionStatusService statusService, Duration duration) {
        String string;
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String color = "#" + ColorUtil.toHex((Color)UIUtil.getLabelDisabledForeground());
        long hours = absSeconds / TimeUnit.HOURS.toSeconds(1L);
        long minutes = absSeconds % TimeUnit.HOURS.toSeconds(1L) / TimeUnit.MINUTES.toSeconds(1L);
        Object[] objectArray = "%02d:%02d";
        Object[] objectArray2 = new Object[]{hours, minutes};
        String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Object timer = string2;
        if (minutes <= (long)statusService.getFreeSessionMinutesBeforeWarning()) {
            timer = "<font color=#" + ColorUtil.toHex((Color)NamedColorUtil.getErrorForeground()) + ">" + (String)timer + "</font>";
        }
        if (CWMPopupHandler.Companion.getShowNewStartSessionPopup()) {
            objectArray = new Object[]{timer};
            string = CodeWithMeCommonBundle.INSTANCE.message("license.free.time.left.new.ui", objectArray);
        } else {
            objectArray = new Object[]{timer, color};
            string = CodeWithMeCommonBundle.INSTANCE.message("license.free.time.left", objectArray);
        }
        String positive = string;
        return seconds < 0L ? "-" + positive : positive;
    }

    public static final void registerFooter(@NotNull CWMLicenseFooter licenseFooter, @NotNull CwmConnectionStatusService statusService, @NotNull UserManager userManager, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)licenseFooter, (String)"licenseFooter");
        Intrinsics.checkNotNullParameter((Object)((Object)statusService), (String)"statusService");
        Intrinsics.checkNotNullParameter((Object)((Object)userManager), (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        userManager.getSessionEnabled().view(lifetime, (arg_0, arg_1) -> CWMLicenseFooterKt.registerFooter$lambda$1(statusService, licenseFooter, userManager, arg_0, arg_1));
        statusService.getSessionStatus().view(lifetime, (arg_0, arg_1) -> CWMLicenseFooterKt.registerFooter$lambda$3(licenseFooter, statusService, userManager, arg_0, arg_1));
    }

    private static final void registerFooter$updateLicenseFooter(CwmConnectionStatusService $statusService, CWMLicenseFooter $licenseFooter, UserManager $userManager) {
        block3: {
            CWMSessionStatus status = (CWMSessionStatus)$statusService.getSessionStatus().getValue();
            JPanel jPanel = $licenseFooter.getPanel$intellij_cwm_plugin_common();
            CWMSessionStatus cWMSessionStatus = status;
            jPanel.setVisible(switch (cWMSessionStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cWMSessionStatus.ordinal()]) {
                case 1, 2 -> {
                    $licenseFooter.getBuyButton$intellij_cwm_plugin_common().setText(CodeWithMeCommonBundle.INSTANCE.message("license.buy", new Object[0]));
                    yield (Boolean)$userManager.getSessionEnabled().getValue();
                }
                default -> false;
            });
            Window window = ComponentUtil.getWindow((Component)$licenseFooter.getPanel$intellij_cwm_plugin_common());
            if (window == null) break block3;
            window.pack();
        }
    }

    private static final String registerFooter$getTimerText(CwmConnectionStatusService statusService) {
        Object object;
        block3: {
            block2: {
                object = (Long)statusService.getFreeSessionRemainingTimeMs().getValue();
                if (object == null) break block2;
                long it = ((Number)object).longValue();
                boolean bl = false;
                Duration duration = Duration.ofMillis(it);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                String string = CWMLicenseFooterKt.formatDuration(statusService, duration);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final Unit registerFooter$lambda$1(CwmConnectionStatusService $statusService, CWMLicenseFooter $licenseFooter, UserManager $userManager, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        CWMLicenseFooterKt.registerFooter$updateLicenseFooter($statusService, $licenseFooter, $userManager);
        return Unit.INSTANCE;
    }

    private static final Unit registerFooter$lambda$3$lambda$2(CWMLicenseFooter $licenseFooter, CwmConnectionStatusService $statusService, Long it) {
        $licenseFooter.getDescription$intellij_cwm_plugin_common().setText(CWMLicenseFooterKt.registerFooter$getTimerText($statusService));
        return Unit.INSTANCE;
    }

    private static final Unit registerFooter$lambda$3(CWMLicenseFooter $licenseFooter, CwmConnectionStatusService $statusService, UserManager $userManager, Lifetime lt, CWMSessionStatus status) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        CWMLicenseFooterKt.registerFooter$updateLicenseFooter($statusService, $licenseFooter, $userManager);
        JLabel jLabel = $licenseFooter.getDescription$intellij_cwm_plugin_common();
        CWMSessionStatus cWMSessionStatus = status;
        jLabel.setText(switch (cWMSessionStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cWMSessionStatus.ordinal()]) {
            case 1, 2 -> {
                $statusService.getFreeSessionRemainingTimeMs().advise(lt, arg_0 -> CWMLicenseFooterKt.registerFooter$lambda$3$lambda$2($licenseFooter, $statusService, arg_0));
                yield CWMLicenseFooterKt.registerFooter$getTimerText($statusService);
            }
            case 3 -> {
                Object[] var5_5 = new Object[]{"#" + ColorUtil.toHex((Color)NamedColorUtil.getErrorForeground())};
                yield CodeWithMeCommonBundle.INSTANCE.message("license.expired", var5_5);
            }
            default -> "";
        });
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CWMSessionStatus.values().length];
            try {
                nArray[CWMSessionStatus.FREE_SESSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CWMSessionStatus.FREE_SESSION_STOPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CWMSessionStatus.EXPIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

