/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.CreateSubfolderAction;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileAction;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.jetbrains.annotations.NotNull;

public final class CreateFileAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateFileAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateFileAction.$$$reportNull$$$0(1);
        }
        boolean b = CreateSubfolderAction.isEnabled(e.getDataContext());
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(b);
        } else {
            e.getPresentation().setEnabled(b);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Component component;
        if (event == null) {
            CreateFileAction.$$$reportNull$$$0(2);
        }
        if ((component = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) == null) {
            return;
        }
        final Deployable server = (Deployable)event.getData(WebDeploymentDataKeys.DEPLOYABLE);
        if (server == null) {
            return;
        }
        final RemoteConnection connection = (RemoteConnection)event.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        if (connection == null) {
            return;
        }
        final FileObject[] files = (FileObject[])event.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (files == null || files.length != 1) {
            return;
        }
        Boolean isModalContext = (Boolean)event.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT);
        if (isModalContext == null) {
            return;
        }
        final Project project = event.getProject();
        final ServerTree tree = (ServerTree)((Object)event.getData(WebDeploymentDataKeys.SERVER_TREE));
        String title = WDBundle.message("create.file.action.title", server.getName());
        final String childName = Messages.showInputDialog((Component)component, (String)WDBundle.message("prompt.enter.new.file.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return this.canClose(inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && !inputString.contains("\\");
            }
        });
        if (childName == null) {
            return;
        }
        PublishConfig publishConfig2 = project != null && !project.isDefault() ? PublishConfig.getInstance(project).clone() : new PublishConfig(null);
        new ExtendedNotificationBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project, component), publishConfig2, server, WDBundle.message("create.file.action.sentence", childName), isModalContext, component, WDBundle.message("create.file.action.title", new Object[0]), DeploymentRevisionTracker.DEAF, true){

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                final Ref childPath = new Ref();
                final FileObject fileObject = files[0].resolveFile(childName, NameScope.CHILD);
                childPath.set((Object)server.getRemotePath(fileObject));
                ArrayList<1> result = new ArrayList<1>();
                result.add(new TransferOperation.CreateRemoteFile("", fileObject){

                    @Override
                    public void execute(ExecutionContext context) throws FileSystemException {
                        DeploymentPathUtils.refreshRemoteFile(fileObject, context);
                        if (!fileObject.exists()) {
                            super.execute(context);
                        } else {
                            context.incCounter("transfer.details.processed");
                        }
                        context.scheduleForSelection((WebServerConfig.RemotePath)childPath.get(), (Object)tree);
                        if (fileObject.isFile()) {
                            if (project != null) {
                                ApplicationManager.getApplication().invokeLater(() -> EditRemoteFileAction.editRemoteFile(server, project, fileObject, null, connection, null));
                            }
                        } else {
                            this.showBalloon(MessageType.WARNING, WDBundle.message("0.already.exists", fileObject.getName().getBaseName()), false);
                        }
                    }
                });
                return new TransferTask.ListBased.ResultWithErrors(result, new DeploymentPathUtils.ErrorsAndExclusions());
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/CreateFileAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/CreateFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

