/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

public final class Http11SslContextSpec
extends AbstractProtocolSslContextSpec<Http11SslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> sslCtxBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);

    public static Http11SslContextSpec forClient() {
        return new Http11SslContextSpec(SslContextBuilder.forClient());
    }

    public static Http11SslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile));
    }

    public static Http11SslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword));
    }

    public static Http11SslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream));
    }

    public static Http11SslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream, (String)keyPassword));
    }

    public static Http11SslContextSpec forServer(KeyManager keyManager) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((KeyManager)keyManager));
    }

    public static Http11SslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory));
    }

    public static Http11SslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((PrivateKey)key, keyCertChain));
    }

    public static Http11SslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, keyCertChain));
    }

    public static Http11SslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, (X509Certificate[])keyCertChain));
    }

    public static Http11SslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new Http11SslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])keyCertChain));
    }

    Http11SslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public Http11SslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

