/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.render;

import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedElementBase;
import com.intellij.swagger.core.diff.model.SwModifiedObjectDefinition;
import com.intellij.swagger.core.diff.model.SwModifiedPrimitive;
import com.intellij.swagger.core.diff.model.SwModifiedReferencedObject;
import com.intellij.swagger.core.diff.model.SwModifiedSpecification;
import com.intellij.swagger.core.diff.model.SwModifiedUrl;
import com.intellij.swagger.core.diff.render.RenderContext;
import com.intellij.swagger.core.diff.render.SwRenderType;
import com.intellij.swagger.core.diff.render.SwRenderUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwMediaType;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwObjectSchema;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwProperty;
import com.intellij.swagger.core.model.api.SwResponse;
import com.intellij.swagger.core.model.api.SwUrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0003J\b\u0010\b\u001a\u00020\u0007H\u0003J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u001b\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\"\u001a\u00020\u001f*\u00060 j\u0002`!2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J8\u0010#\u001a\u00020\u0005\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010&\u001a\u0002H$2\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\u00050(\u00a2\u0006\u0002\b)H\u0002\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u0005*\u0004\u0018\u00010\u0001H\u0002J\f\u0010,\u001a\u00020\u0005*\u00020\u0005H\u0002J\u0014\u0010-\u001a\u00020\u0005*\u00020\u00052\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0016\u0010/\u001a\u00020\u0005*\u0004\u0018\u00010\u00012\u0006\u00100\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/swagger/core/diff/render/DiffMarkdownRenderer;", "", "<init>", "()V", "NAVIGATABLE_LINK_PATTERN", "", "needShowDuplicateNestedDiff", "", "needRenderNavigatableLinks", "renderDiff", "modifiedSpecification", "Lcom/intellij/swagger/core/diff/model/SwModifiedSpecification;", "renderChildren", "modifiedElement", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "indent", "", "renderChildrenWithContext", "rootModifiedElement", "renderContext", "Lcom/intellij/swagger/core/diff/render/RenderContext;", "renderModifiedElementInfo", "renderModelElementInfo", "modelElement", "renderHeaderFor", "childrenModified", "", "categoryHasRestrictedModifications", "renderTopLevelHeader", "renderedItem", "withIndent", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "withMarker", "renderElementLink", "Type", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "element", "elementIdentifier", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/swagger/core/model/api/SwModelElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "quotedOrEmpty", "bold", "deprecated", "isDeprecated", "escapeWith", "symbol", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nDiffMarkdownRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffMarkdownRenderer.kt\ncom/intellij/swagger/core/diff/render/DiffMarkdownRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1869#2:217\n1869#2,2:218\n1869#2,2:220\n1869#2,2:222\n1870#2:224\n1617#2,9:225\n1869#2:234\n1870#2:236\n1626#2:237\n1761#2,3:238\n1#3:235\n1#3:241\n*S KotlinDebug\n*F\n+ 1 DiffMarkdownRenderer.kt\ncom/intellij/swagger/core/diff/render/DiffMarkdownRenderer\n*L\n50#1:217\n54#1:218,2\n58#1:220,2\n62#1:222,2\n50#1:224\n135#1:225,9\n135#1:234\n135#1:236\n135#1:237\n136#1:238,3\n135#1:235\n*E\n"})
public final class DiffMarkdownRenderer {
    @NotNull
    public static final DiffMarkdownRenderer INSTANCE = new DiffMarkdownRenderer();
    @NonNls
    @NotNull
    private static final String NAVIGATABLE_LINK_PATTERN = "[%s](source://%s:%d)";

    private DiffMarkdownRenderer() {
    }

    @Deprecated(message="add a checkbox to settings page")
    private final boolean needShowDuplicateNestedDiff() {
        return true;
    }

    @Deprecated(message="add a checkbox to settings page")
    private final boolean needRenderNavigatableLinks() {
        return true;
    }

    @NotNull
    public final String renderDiff(@NotNull SwModifiedSpecification modifiedSpecification) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)modifiedSpecification, (String)"modifiedSpecification");
        StringBuilder $this$renderDiff_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"###### ", SwaggerBundle.message("diff.top.level.header", new Object[0])};
        StringsKt.append((StringBuilder)$this$renderDiff_u24lambda_u240, (String[])stringArray);
        String originalPath = SwRenderUtilsKt.pathFromSourceRoot(modifiedSpecification.getOriginal());
        String modifiedPath = SwRenderUtilsKt.pathFromSourceRoot(modifiedSpecification.getModified());
        if (originalPath != null && modifiedPath != null && !Intrinsics.areEqual((Object)originalPath, (Object)modifiedPath)) {
            String[] stringArray2 = new String[]{": ", originalPath, " vs ", modifiedPath};
            StringsKt.append((StringBuilder)$this$renderDiff_u24lambda_u240, (String[])stringArray2);
        } else if (modifiedPath != null && !Intrinsics.areEqual((Object)modifiedPath, (Object)originalPath)) {
            String[] stringArray3 = new String[]{": ", modifiedPath, " ", SwaggerBundle.message("diff.revision.title", new Object[0])};
            StringsKt.append((StringBuilder)$this$renderDiff_u24lambda_u240, (String[])stringArray3);
        }
        $this$renderDiff_u24lambda_u240.append(DiffMarkdownRenderer.renderChildren$default(INSTANCE, modifiedSpecification, 0, 2, null));
        return stringBuilder.toString();
    }

    private final String renderChildren(SwModifiedElement<?> modifiedElement, int indent) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderChildren_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderChildren_u24lambda_u241.append(INSTANCE.renderChildrenWithContext(modifiedElement, new RenderContext(SwRenderType.PRESERVED, indent)));
        $this$renderChildren_u24lambda_u241.append(INSTANCE.renderChildrenWithContext(modifiedElement, new RenderContext(SwRenderType.CREATED, indent)));
        $this$renderChildren_u24lambda_u241.append(INSTANCE.renderChildrenWithContext(modifiedElement, new RenderContext(SwRenderType.REMOVED, indent)));
        return stringBuilder.toString();
    }

    static /* synthetic */ String renderChildren$default(DiffMarkdownRenderer diffMarkdownRenderer, SwModifiedElement swModifiedElement, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return diffMarkdownRenderer.renderChildren(swModifiedElement, n);
    }

    private final String renderChildrenWithContext(SwModifiedElement<?> rootModifiedElement, RenderContext renderContext) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderChildrenWithContext_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = rootModifiedElement.computeChildrenDiffs();
        boolean $i$f$forEach = false;
        block5: for (Object element$iv : $this$forEach$iv) {
            SwDiffResult diff = (SwDiffResult)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[renderContext.getRenderType().ordinal()]) {
                case 1: {
                    Object it;
                    Object element$iv22;
                    $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderHeaderFor(diff.getCreated(), renderContext));
                    Iterable $this$forEach$iv2 = diff.getCreated();
                    boolean $i$f$forEach2 = false;
                    Iterator iterator = $this$forEach$iv2.iterator();
                    while (iterator.hasNext()) {
                        it = element$iv22 = iterator.next();
                        boolean bl3 = false;
                        $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderModelElementInfo(it, renderContext));
                    }
                    continue block5;
                }
                case 2: {
                    Object it;
                    Object element$iv22;
                    $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderHeaderFor(diff.getRemoved(), renderContext));
                    Iterable $this$forEach$iv2 = diff.getRemoved();
                    boolean $i$f$forEach2 = false;
                    Iterator iterator = $this$forEach$iv2.iterator();
                    while (iterator.hasNext()) {
                        it = element$iv22 = iterator.next();
                        boolean bl4 = false;
                        $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderModelElementInfo(it, renderContext));
                    }
                    continue block5;
                }
                case 3: {
                    Object it;
                    Object element$iv22;
                    $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderHeaderFor(diff.getPreserved(), renderContext));
                    Iterable $this$forEach$iv2 = diff.getPreserved();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv22 : $this$forEach$iv2) {
                        it = (SwModifiedElement)element$iv22;
                        boolean bl5 = false;
                        $this$renderChildrenWithContext_u24lambda_u246.append(INSTANCE.renderModifiedElementInfo((SwModifiedElement<?>)it, renderContext));
                    }
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String renderModifiedElementInfo(SwModifiedElement<?> modifiedElement, RenderContext renderContext) {
        SwModifiedElement<?> swModifiedElement;
        StringBuilder stringBuilder;
        StringBuilder $this$renderModifiedElementInfo_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!modifiedElement.getModificationType().hasNotableChanges()) return stringBuilder.toString();
        if (modifiedElement.isDeprecated()) {
            renderContext.deprecate();
        }
        if ((swModifiedElement = modifiedElement) instanceof SwModifiedPrimitive) {
            INSTANCE.withIndent($this$renderModifiedElementInfo_u24lambda_u247, renderContext.getCurrentIndent());
            INSTANCE.withMarker($this$renderModifiedElementInfo_u24lambda_u247, modifiedElement, renderContext);
            Object[] objectArray = new Object[]{((SwModifiedPrimitive)modifiedElement).getPresentableName(), INSTANCE.quotedOrEmpty(String.valueOf(((SwModifiedPrimitive)modifiedElement).getOriginal())), INSTANCE.quotedOrEmpty(String.valueOf(((SwModifiedPrimitive)modifiedElement).getModified()))};
            $this$renderModifiedElementInfo_u24lambda_u247.append(SwaggerBundle.message("diff.primitive.element.0.was.1.and.became.2", objectArray));
            v0 = $this$renderModifiedElementInfo_u24lambda_u247.append("\n");
        } else {
            if (swModifiedElement instanceof SwModifiedReferencedObject) {
                StringBuilder stringBuilder2;
                if (INSTANCE.needShowDuplicateNestedDiff()) {
                    stringBuilder2 = $this$renderModifiedElementInfo_u24lambda_u247.append(INSTANCE.renderChildren(modifiedElement, renderContext.getCurrentIndent()));
                    return stringBuilder.toString();
                }
                Object[] objectArray = new Object[]{" ", ((SwModifiedReferencedObject)modifiedElement).getModificationType()};
                stringBuilder2 = StringsKt.append((StringBuilder)$this$renderModifiedElementInfo_u24lambda_u247, (Object[])objectArray);
                return stringBuilder.toString();
            }
            v0 = $this$renderModifiedElementInfo_u24lambda_u247.append(INSTANCE.renderModelElementInfo(modifiedElement.getModified(), renderContext));
        }
        $this$renderModifiedElementInfo_u24lambda_u247.append(INSTANCE.renderChildren(modifiedElement, renderContext.getCurrentIndent() + 1));
        return stringBuilder.toString();
    }

    private final String renderModelElementInfo(Object modelElement, RenderContext renderContext) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderModelElementInfo_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.withIndent($this$renderModelElementInfo_u24lambda_u2410, renderContext.getCurrentIndent());
        INSTANCE.withMarker($this$renderModelElementInfo_u24lambda_u2410, modelElement, renderContext);
        Object object = modelElement;
        if (object instanceof SwUrl) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.url.title", new Object[0]), " : ", INSTANCE.renderElementLink((SwModelElement)modelElement, arg_0 -> DiffMarkdownRenderer.renderModelElementInfo$lambda$10$lambda$8(modelElement, arg_0))};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwHttpOperation) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.http.method.title", new Object[0]), " : ", INSTANCE.bold(INSTANCE.deprecated(((SwHttpOperation)modelElement).getHttpMethod().getValue(), renderContext.isDeprecated()))};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwParameter) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.parameter.title", new Object[0]), " : ", INSTANCE.quotedOrEmpty(((SwParameter)modelElement).getParameterName().getValue())};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwResponse) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.response.title", new Object[0]), " : ", INSTANCE.quotedOrEmpty(((SwResponse)modelElement).getHttpCode().getValue())};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwProperty) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.property", new Object[0]), " : ", INSTANCE.quotedOrEmpty(((SwProperty)modelElement).getName().getValue())};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwObjectSchema) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.object.schema.title", new Object[0]), " : ", INSTANCE.quotedOrEmpty(((SwObjectSchema)modelElement).getItemTypeCoordinates().getValue())};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwMediaType) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.media.type", new Object[0]), " : ", INSTANCE.quotedOrEmpty(((SwMediaType)modelElement).getType().getValue())};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else if (object instanceof SwDefinition) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.elements.object.definition.title", new Object[0]), " : ", INSTANCE.renderElementLink((SwModelElement)modelElement, arg_0 -> DiffMarkdownRenderer.renderModelElementInfo$lambda$10$lambda$9(modelElement, arg_0))};
            v0 = StringsKt.append((StringBuilder)$this$renderModelElementInfo_u24lambda_u2410, (String[])stringArray);
        } else {
            v0 = $this$renderModelElementInfo_u24lambda_u2410.append(INSTANCE.quotedOrEmpty(String.valueOf(modelElement)));
        }
        return stringBuilder.toString();
    }

    private final String renderHeaderFor(Collection<? extends Object> childrenModified, RenderContext renderContext) {
        return !childrenModified.isEmpty() && renderContext.isTopLevelContext() && (renderContext.getRenderType() != SwRenderType.PRESERVED || this.categoryHasRestrictedModifications(childrenModified)) ? this.renderTopLevelHeader(renderContext, CollectionsKt.first((Iterable)childrenModified)) : "";
    }

    /*
     * WARNING - void declaration
     */
    private final boolean categoryHasRestrictedModifications(Collection<? extends Object> childrenModified) {
        boolean bl;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = childrenModified;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SwModifiedElementBase it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object it = element$iv$iv;
                boolean bl3 = false;
                if ((it instanceof SwModifiedElementBase ? (SwModifiedElementBase)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SwModifiedElementBase it = (SwModifiedElementBase)element$iv;
                    boolean bl5 = false;
                    if (!it.getModificationType().hasNotableChanges()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String renderTopLevelHeader(RenderContext renderContext, Object renderedItem) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderTopLevelHeader_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = renderedItem;
        String elementType = object instanceof SwUrl || object instanceof SwModifiedUrl ? SwaggerBundle.message("diff.top.level.endpoints.header", new Object[0]) : (object instanceof SwDefinition || object instanceof SwModifiedObjectDefinition ? SwaggerBundle.message("diff.top.level.models.header", new Object[0]) : SwaggerBundle.message("diff.top.level.unknown.elements.header", new Object[0]));
        switch (WhenMappings.$EnumSwitchMapping$0[renderContext.getRenderType().ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"\n", "\n", SwaggerBundle.message("diff.markers.created", new Object[0]), " ", elementType, "\n", "==================\n"};
                StringBuilder stringBuilder2 = StringsKt.append((StringBuilder)$this$renderTopLevelHeader_u24lambda_u2413, (String[])stringArray);
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"\n", "\n", SwaggerBundle.message("diff.markers.removed", new Object[0]), " ", elementType, "\n", "==================\n"};
                StringBuilder stringBuilder2 = StringsKt.append((StringBuilder)$this$renderTopLevelHeader_u24lambda_u2413, (String[])stringArray);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"\n", "\n", SwaggerBundle.message("diff.markers.modified", new Object[0]), " ", elementType, "\n", "==================\n"};
                StringBuilder stringBuilder2 = StringsKt.append((StringBuilder)$this$renderTopLevelHeader_u24lambda_u2413, (String[])stringArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringBuilder.toString();
    }

    private final void withIndent(StringBuilder $this$withIndent, int indent) {
        $this$withIndent.append("\n");
        int n = 0;
        while (n < indent) {
            int it = n++;
            boolean bl = false;
            $this$withIndent.append("   ");
        }
    }

    private final void withMarker(StringBuilder $this$withMarker, Object modelElement, RenderContext renderContext) {
        StringBuilder stringBuilder = renderContext.isTopLevelContext() && (modelElement instanceof SwUrl || modelElement instanceof SwDefinition) ? $this$withMarker.append("#### ") : (modelElement instanceof SwModifiedPrimitive || modelElement instanceof SwModifiedReferencedObject ? $this$withMarker.append("> ") : $this$withMarker.append("* "));
        if (renderContext.getRenderType() == SwRenderType.CREATED) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.markers.new.element", new Object[0]), " "};
            StringsKt.append((StringBuilder)$this$withMarker, (String[])stringArray);
        } else if (renderContext.getRenderType() == SwRenderType.REMOVED) {
            String[] stringArray = new String[]{SwaggerBundle.message("diff.markers.removed.element", new Object[0]), " "};
            StringsKt.append((StringBuilder)$this$withMarker, (String[])stringArray);
        }
    }

    private final <Type extends SwModelElement> String renderElementLink(Type element, Function1<? super Type, String> elementIdentifier) {
        String string;
        PsiElement navigationElement = element.getSourcePsi();
        String identifier = (String)elementIdentifier.invoke(element);
        if (this.needRenderNavigatableLinks()) {
            Integer offset;
            String path = SwRenderUtilsKt.containingFilePathFromContentRoot(navigationElement);
            PsiElement psiElement = navigationElement;
            Integer n = offset = psiElement != null ? Integer.valueOf(psiElement.getTextOffset()) : null;
            if (path != null && offset != null) {
                String string2 = NAVIGATABLE_LINK_PATTERN;
                Object[] objectArray = new Object[]{identifier, path, offset};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                string = this.quotedOrEmpty(identifier);
            }
        } else {
            string = this.quotedOrEmpty(identifier);
        }
        return string;
    }

    private final String quotedOrEmpty(Object $this$quotedOrEmpty) {
        return this.escapeWith($this$quotedOrEmpty, "`");
    }

    private final String bold(String $this$bold) {
        return this.escapeWith($this$bold, "**");
    }

    private final String deprecated(String $this$deprecated, boolean isDeprecated2) {
        return isDeprecated2 ? this.escapeWith($this$deprecated, "~~") : $this$deprecated;
    }

    private final String escapeWith(Object $this$escapeWith, String symbol) {
        String string;
        Object stringValue;
        Object object = $this$escapeWith;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        if (StringsKt.isBlank((CharSequence)((CharSequence)(stringValue = object)))) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$escapeWith_u24lambda_u2415 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String[] stringArray = new String[]{symbol, stringValue, symbol};
            StringsKt.append((StringBuilder)$this$escapeWith_u24lambda_u2415, (String[])stringArray);
            string = stringBuilder.toString();
        }
        return string;
    }

    private static final String renderModelElementInfo$lambda$10$lambda$8(Object $modelElement, SwUrl $this$renderElementLink) {
        Intrinsics.checkNotNullParameter((Object)$this$renderElementLink, (String)"$this$renderElementLink");
        return ((SwUrl)$modelElement).getUrlString();
    }

    private static final String renderModelElementInfo$lambda$10$lambda$9(Object $modelElement, SwDefinition $this$renderElementLink) {
        Intrinsics.checkNotNullParameter((Object)$this$renderElementLink, (String)"$this$renderElementLink");
        return ((SwDefinition)$modelElement).getName().getValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwRenderType.values().length];
            try {
                nArray[SwRenderType.CREATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwRenderType.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwRenderType.PRESERVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

