/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceWidgetItem;
import com.intellij.lang.typescript.compiler.languageService.frameworks.PluggableTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigurePluginRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigurePluginRequestArguments;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VuejsIcons;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VuePluginTypeScriptServiceKt;
import org.jetbrains.vuejs.options.VueConfigurable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VuePluginTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getInitialOpenCommands", "", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "createConfigureCommand", "isAcceptableForHighlighting", "", "file", "Lcom/intellij/psi/PsiFile;", "isAcceptableNonTsFile", "service", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigService;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createWidgetItem", "Lcom/intellij/platform/lang/lsWidget/LanguageServiceWidgetItem;", "currentFile", "getProcessName", "", "isTypeEvaluationEnabled", "intellij.vuejs"})
public final class VuePluginTypeScriptService
extends PluggableTypeScriptService {
    public VuePluginTypeScriptService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, VuePluginTypeScriptServiceKt.access$getVueTypeScriptPlugin$p());
    }

    @NotNull
    protected List<JSLanguageServiceSimpleCommand> getInitialOpenCommands() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createConfigureCommand()), (Iterable)super.getInitialOpenCommands());
    }

    private final JSLanguageServiceSimpleCommand createConfigureCommand() {
        return (JSLanguageServiceSimpleCommand)new ConfigurePluginRequest(new ConfigurePluginRequestArguments("typescript-vue-plugin", MapsKt.emptyMap()));
    }

    public boolean isAcceptableForHighlighting(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.isAcceptableForHighlighting(file) || VueFileTypeKt.isVueFile(file);
    }

    protected boolean isAcceptableNonTsFile(@NotNull Project project, @NotNull TypeScriptConfigService service, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return super.isAcceptableNonTsFile(project, service, virtualFile) || VueFileTypeKt.isVueFile(virtualFile);
    }

    @NotNull
    public LanguageServiceWidgetItem createWidgetItem(@Nullable VirtualFile currentFile) {
        TypeScriptServerServiceImpl typeScriptServerServiceImpl = (TypeScriptServerServiceImpl)this;
        Icon icon = VuejsIcons.Vue;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vue");
        Icon icon2 = VuejsIcons.Vue;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Vue");
        return (LanguageServiceWidgetItem)new TypeScriptServiceWidgetItem(typeScriptServerServiceImpl, currentFile, icon, icon2, VueConfigurable.class);
    }

    @NotNull
    public String getProcessName() {
        return "Vue + TypeScript";
    }

    public boolean isTypeEvaluationEnabled() {
        return false;
    }
}

