/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueCodeStyleSettings;
import org.jetbrains.vuejs.options.VueCodeStyleMainPanel;
import org.jetbrains.vuejs.options.VueIndentOptionsEditor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/vuejs/options/VueCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "getCodeSample", "", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "createFileFromText", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "customizeDefaults", "", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "customizeSettings", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "intellij.vuejs"})
public final class VueCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return (Language)VueLanguage.Companion.getINSTANCE();
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return "  <template>\n    <div id=\"app\">\n          <img      alt=\"Vue logo\"        \n src=\"./assets/logo.png\">\n    <HelloWorld  \n msg =  \"Welcome to Your Vue.js App\"/></div>\n <span>{{descr    }}</span>\n <span>{{ (function (){ alert(\"Vue is great!\"); return \"Really great!\"} )() }}</span>\n</template>\n\n <script>\n    import HelloWorld  from './components/HelloWorld.vue'\n\n    export  default  {\n  name:    'App'  ,\n     components:     {\n    HelloWorld}\n  }\n</script>\n\n  <style>\n       #app      {\n  font-family: Avenir, Helvetica, Arial, sans-serif;\n   text-align: center;   color    : #2c3e50;}\n</style>";
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a.{{.}}.#@injected@#.html", (Language)VueLanguage.Companion.getINSTANCE(), (CharSequence)text, false, true);
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new VueIndentOptionsEditor();
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        String string = this.getConfigurableDisplayName();
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(baseSettings, modelSettings, string){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                return (CodeStyleAbstractPanel)new VueCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.vuecodestyle";
            }
        };
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        indentOptions.TAB_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new VueCodeStyleSettings(settings);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                consumer.showCustomOption(VueCodeStyleSettings.class, "SPACES_WITHIN_INTERPOLATION_EXPRESSIONS", JavaScriptBundle.message((String)"javascript.formatting.web.spacing.within.interpolations", (Object[])new Object[0]), JavaScriptBundle.message((String)"javascript.formatting.web.spacing.within.group", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES};
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_WRAP", JavaScriptBundle.message((String)"javascript.formatting.web.wrapping.interpolations", (Object[])new Object[0]), null, objectArray);
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER", JavaScriptBundle.message((String)"javascript.formatting.web.wrapping.new-line-after-start-delimiter", (Object[])new Object[0]), JavaScriptBundle.message((String)"javascript.formatting.web.wrapping.interpolations", (Object[])new Object[0]), new Object[0]);
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER", JavaScriptBundle.message((String)"javascript.formatting.web.wrapping.new-line-before-end-delimiter", (Object[])new Object[0]), JavaScriptBundle.message((String)"javascript.formatting.web.wrapping.interpolations", (Object[])new Object[0]), new Object[0]);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

