/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.editor;

import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document == null) {
            DjangoTemplateLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        int wrapPosition = super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
        if (isSoftWrap) {
            return wrapPosition;
        }
        if (project == null) {
            return -1;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager == null) {
            return -1;
        }
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return -1;
        }
        PsiElement element = psiFile.findElementAt(wrapPosition);
        if (element == null || element instanceof PsiComment) {
            return -1;
        }
        DjangoTagElementImpl tag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        if (tag != null) {
            wrapPosition = tag.getTextRange().getStartOffset();
        }
        return wrapPosition > startOffset ? wrapPosition : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/python/django/lang/template/editor/DjangoTemplateLineWrapPositionStrategy", "calculateWrapPosition"));
    }
}

