/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.python.django.ui.CreateTemplateDialog;
import com.intellij.python.django.ui.DjangoTemplateFileFactory;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateViewQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateViewQuickFix.class);
    private final ViewParameters myParameters;

    public CreateViewQuickFix(ViewParameters params) {
        this.myParameters = params;
    }

    @NotNull
    public String getFamilyName() {
        String string = DjangoBundle.message((String)"create-view-quick-fix-name", (Object[])new Object[0]);
        if (string == null) {
            CreateViewQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        if (project == null) {
            CreateViewQuickFix.$$$reportNull$$$0(1);
        }
        if (problemDescriptor == null) {
            CreateViewQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement element = problemDescriptor.getPsiElement();
        if (this.myParameters.getViewsFile() == null) {
            String path = this.myParameters.getViewsPath();
            String msg = DjangoBundle.message((String)"no-view", (Object[])new Object[]{path != null ? path : "views.py"});
            Messages.showErrorDialog((String)msg, (String)this.getTitle());
            return;
        }
        CreateTemplateDialog dialog = new CreateTemplateDialog(project, element);
        dialog.setTitle(DjangoBundle.message((String)"django-create-view-method", (Object[])new Object[0]));
        dialog.setTemplateName(this.myParameters.getMethodName() + ".html");
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        DjangoTemplateFileFactory templateFileFactory = dialog.getTemplateFileFactory();
        if (dialog.isCreateTemplate() && !templateFileFactory.isValid(dialog.getTemplateName())) {
            Messages.showErrorDialog((String)DjangoBundle.message((String)"template-name-error", (Object[])new Object[0]), (String)this.getTitle());
            return;
        }
        PsiDirectory folder = dialog.getTemplatesFolder();
        String templateName = dialog.getTemplateName();
        try {
            ApplicationManager.getApplication().runWriteAction(() -> this.create(project, templateFileFactory, folder, templateName));
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
            this.showError(ex.getMessage());
        }
    }

    private void showError(@NlsSafe String msg) {
        Messages.showErrorDialog((String)msg, (String)this.getTitle());
    }

    @Nls
    private String getTitle() {
        String name = this.myParameters.getMethodName();
        return DjangoBundle.message((String)"create-view", (Object[])new Object[]{name != null ? name : ""});
    }

    public void create(@NotNull Project project, @NotNull DjangoTemplateFileFactory templateFileFactory, @Nullable PsiDirectory templateFolder, @Nullable String templateName) {
        if (project == null) {
            CreateViewQuickFix.$$$reportNull$$$0(3);
        }
        if (templateFileFactory == null) {
            CreateViewQuickFix.$$$reportNull$$$0(4);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{this.myParameters.getViewsFile()}).withName(DjangoBundle.message((String)"django.create.view.quickfix", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            PyFunction viewMethod;
            PsiReference renderToResponseRef;
            PsiFile templateFile = null;
            if (templateFolder != null && templateName != null) {
                templateFile = templateFileFactory.createTemplate(templateFolder, templateName);
            }
            if ((renderToResponseRef = (viewMethod = this.createViewMethod(templateFile != null ? templateName : null)).findReferenceAt(viewMethod.getText().indexOf("render_to_response") + 1)) != null && renderToResponseRef.resolve() == null) {
                AddImportHelper.addFromImportStatement((PsiFile)viewMethod.getContainingFile(), (String)"django.shortcuts", (String)"render_to_response", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
            }
            if (templateName != null && templateFile == null) {
                Messages.showInfoMessage((String)DjangoBundle.message((String)"skip-template-create", (Object[])new Object[0]), (String)this.getTitle());
            }
            viewMethod.navigate(true);
        });
    }

    private PyFunction createViewMethod(String templateName) {
        String methodName;
        @NotNull PyFile views = this.myParameters.getViewsFile();
        PyFunction function = views.findTopLevelFunction(methodName = this.myParameters.getMethodName());
        if (function == null) {
            PyFunctionBuilder builder = this.getFunctionText(templateName);
            function = builder.addFunction((PsiElement)views);
        }
        return function;
    }

    private PyFunctionBuilder getFunctionText(@Nullable String templateName) {
        String methodName = this.myParameters.getMethodName();
        PyFunctionBuilder builder = new PyFunctionBuilder(methodName, (PsiElement)this.myParameters.getViewsFile());
        builder.parameter("request");
        for (String p : this.myParameters.getParameters()) {
            builder.parameter(p);
        }
        if (templateName != null) {
            builder.statement("return render_to_response('" + templateName + "')");
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/ref/CreateViewQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/ref/CreateViewQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

