/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JComboBox<String> myBracePlacementCombo;
    private JComboBox<String> myAlignValueCombo;
    private JComboBox<String> myQuotesCombo;
    private JCheckBox myEnforceQuotesOnFormat;
    private JCheckBox mySpaceAfterColonCheckBox;
    private JCheckBox mySpaceBeforeOpeningBraceCheckBox;
    private JCheckBox myAlignClosingBraceWithPropertiesCheckBox;
    private JCheckBox myKeepSingleLineBlocksCheckBox;
    private JCheckBox myConvertColorCaseCheckBox;
    private JRadioButton myColorLowerCaseRadioButton;
    private JRadioButton myColorUpperCaseRadioButton;
    private JCheckBox myConvertColorFormatCheckBox;
    private JRadioButton myLongFormatRadioButton;
    private JRadioButton myShortFormatRadioButton;
    private JPanel myCommentStyleComponent;
    private JBScrollPane myJBScrollPane;
    private CommenterForm myCommenterForm;
    @NotNull
    private final Class<? extends CssCodeStyleSettings> myCustomSettingsClass;
    @NotNull
    private final FileType myFileType;

    public <T extends CssCodeStyleSettings> CssCodeStylePanel(@NotNull CodeStyleSettings settings, @NotNull Class<T> customSettingsClass, @NotNull FileType fileType) {
        if (settings == null) {
            CssCodeStylePanel.$$$reportNull$$$0(0);
        }
        if (customSettingsClass == null) {
            CssCodeStylePanel.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            CssCodeStylePanel.$$$reportNull$$$0(2);
        }
        super(settings);
        this.myCustomSettingsClass = customSettingsClass;
        this.myFileType = fileType;
        this.$$$setupUI$$$();
        this.myConvertColorCaseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CssCodeStylePanel.this.myConvertColorCaseCheckBox.isSelected()) {
                    CssCodeStylePanel.this.myColorLowerCaseRadioButton.setEnabled(true);
                    CssCodeStylePanel.this.myColorUpperCaseRadioButton.setEnabled(true);
                    if (!CssCodeStylePanel.this.myColorUpperCaseRadioButton.isSelected() && !CssCodeStylePanel.this.myColorLowerCaseRadioButton.isSelected()) {
                        CssCodeStylePanel.this.myColorLowerCaseRadioButton.doClick();
                    }
                } else {
                    CssCodeStylePanel.this.myColorLowerCaseRadioButton.setEnabled(false);
                    CssCodeStylePanel.this.myColorUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        this.myConvertColorFormatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CssCodeStylePanel.this.myConvertColorFormatCheckBox.isSelected()) {
                    CssCodeStylePanel.this.myLongFormatRadioButton.setEnabled(true);
                    CssCodeStylePanel.this.myShortFormatRadioButton.setEnabled(true);
                    if (!CssCodeStylePanel.this.myLongFormatRadioButton.isSelected() && !CssCodeStylePanel.this.myShortFormatRadioButton.isSelected()) {
                        CssCodeStylePanel.this.myLongFormatRadioButton.doClick();
                    }
                } else {
                    CssCodeStylePanel.this.myLongFormatRadioButton.setEnabled(false);
                    CssCodeStylePanel.this.myShortFormatRadioButton.setEnabled(false);
                }
            }
        });
        this.myBracePlacementCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CssBundle.message("css.code.style.braces.end.of.line", new Object[0]), CssBundle.message("css.code.style.braces.next.line", new Object[0])}));
        this.myAlignValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CssBundle.message("css.code.style.value.align.do.not.align", new Object[0]), CssBundle.message("css.code.style.value.align.on.colon", new Object[0]), CssBundle.message("css.code.style.value.align.on.value", new Object[0])}));
        this.myQuotesCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CssBundle.message("css.code.style.quote.marks.double", new Object[0]), CssBundle.message("css.code.style.quote.marks.single", new Object[0])}));
        this.addPanelToWatch(this.myPanel);
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CssCodeStylePanel.$$$reportNull$$$0(3);
        }
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(this.myCustomSettingsClass);
        CssCodeStylePanel.setValue(this.myBracePlacementCombo, cssSettings.BRACE_PLACEMENT);
        CssCodeStylePanel.setValue(this.myAlignValueCombo, cssSettings.VALUE_ALIGNMENT);
        this.myQuotesCombo.setSelectedIndex(cssSettings.USE_DOUBLE_QUOTES ? 0 : 1);
        this.myEnforceQuotesOnFormat.setSelected(cssSettings.ENFORCE_QUOTES_ON_FORMAT);
        CssCodeStylePanel.setValue(this.mySpaceAfterColonCheckBox, cssSettings.SPACE_AFTER_COLON);
        CssCodeStylePanel.setValue(this.mySpaceBeforeOpeningBraceCheckBox, cssSettings.SPACE_BEFORE_OPENING_BRACE);
        CssCodeStylePanel.setValue(this.myAlignClosingBraceWithPropertiesCheckBox, cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES);
        CssCodeStylePanel.setValue(this.myKeepSingleLineBlocksCheckBox, cssSettings.KEEP_SINGLE_LINE_BLOCKS);
        if (cssSettings.HEX_COLOR_UPPER_CASE) {
            this.enableColorCaseButtons(true);
            this.myColorUpperCaseRadioButton.doClick();
        } else if (cssSettings.HEX_COLOR_LOWER_CASE) {
            this.enableColorCaseButtons(true);
            this.myColorLowerCaseRadioButton.doClick();
        } else {
            this.enableColorCaseButtons(false);
        }
        if (cssSettings.HEX_COLOR_LONG_FORMAT) {
            this.enableColorFormatButtons(true);
            this.myLongFormatRadioButton.doClick();
        } else if (cssSettings.HEX_COLOR_SHORT_FORMAT) {
            this.enableColorFormatButtons(true);
            this.myShortFormatRadioButton.doClick();
        } else {
            this.enableColorFormatButtons(false);
        }
        this.myCommenterForm.reset(settings);
    }

    private void enableColorFormatButtons(boolean state) {
        this.myConvertColorFormatCheckBox.setSelected(state);
        this.myLongFormatRadioButton.setEnabled(state);
        this.myShortFormatRadioButton.setEnabled(state);
    }

    private void enableColorCaseButtons(boolean state) {
        this.myConvertColorCaseCheckBox.setSelected(state);
        this.myColorUpperCaseRadioButton.setEnabled(state);
        this.myColorLowerCaseRadioButton.setEnabled(state);
    }

    private static void setValue(@NotNull JComboBox<?> box, int value) {
        if (box == null) {
            CssCodeStylePanel.$$$reportNull$$$0(4);
        }
        box.setSelectedIndex(value);
    }

    private static void setValue(@NotNull JCheckBox box, boolean value) {
        if (box == null) {
            CssCodeStylePanel.$$$reportNull$$$0(5);
        }
        box.setSelected(value);
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            CssCodeStylePanel.$$$reportNull$$$0(6);
        }
        return new LexerEditorHighlighter((SyntaxHighlighter)new CssHighlighter(), scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    @NotNull
    protected FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            CssCodeStylePanel.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    @NonNls
    protected String getPreviewText() {
        return CssCodeStylePanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.css.template");
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CssCodeStylePanel.$$$reportNull$$$0(8);
        }
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(this.myCustomSettingsClass);
        cssSettings.BRACE_PLACEMENT = CssCodeStylePanel.getComboValue(this.myBracePlacementCombo);
        cssSettings.VALUE_ALIGNMENT = CssCodeStylePanel.getComboValue(this.myAlignValueCombo);
        cssSettings.USE_DOUBLE_QUOTES = this.myQuotesCombo.getSelectedIndex() == 0;
        cssSettings.ENFORCE_QUOTES_ON_FORMAT = this.myEnforceQuotesOnFormat.isSelected();
        cssSettings.SPACE_AFTER_COLON = this.mySpaceAfterColonCheckBox.isSelected();
        cssSettings.SPACE_BEFORE_OPENING_BRACE = this.mySpaceBeforeOpeningBraceCheckBox.isSelected();
        cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES = this.myAlignClosingBraceWithPropertiesCheckBox.isSelected();
        cssSettings.KEEP_SINGLE_LINE_BLOCKS = this.myKeepSingleLineBlocksCheckBox.isSelected();
        cssSettings.HEX_COLOR_UPPER_CASE = this.myConvertColorCaseCheckBox.isSelected() && this.myColorUpperCaseRadioButton.isSelected();
        cssSettings.HEX_COLOR_LOWER_CASE = this.myConvertColorCaseCheckBox.isSelected() && this.myColorLowerCaseRadioButton.isSelected();
        cssSettings.HEX_COLOR_LONG_FORMAT = this.myConvertColorFormatCheckBox.isSelected() && this.myLongFormatRadioButton.isSelected();
        cssSettings.HEX_COLOR_SHORT_FORMAT = this.myConvertColorFormatCheckBox.isSelected() && this.myShortFormatRadioButton.isSelected();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        CssCodeStyleSettings cssSettings = (CssCodeStyleSettings)settings.getCustomSettings(this.myCustomSettingsClass);
        if (cssSettings.BRACE_PLACEMENT != CssCodeStylePanel.getComboValue(this.myBracePlacementCombo)) {
            return true;
        }
        if (cssSettings.VALUE_ALIGNMENT != CssCodeStylePanel.getComboValue(this.myAlignValueCombo)) {
            return true;
        }
        if (cssSettings.USE_DOUBLE_QUOTES != (this.myQuotesCombo.getSelectedIndex() == 0)) {
            return true;
        }
        if (cssSettings.ENFORCE_QUOTES_ON_FORMAT != this.myEnforceQuotesOnFormat.isSelected()) {
            return true;
        }
        if (cssSettings.SPACE_AFTER_COLON != this.mySpaceAfterColonCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.SPACE_BEFORE_OPENING_BRACE != this.mySpaceBeforeOpeningBraceCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES != this.myAlignClosingBraceWithPropertiesCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.KEEP_SINGLE_LINE_BLOCKS != this.myKeepSingleLineBlocksCheckBox.isSelected()) {
            return true;
        }
        if (cssSettings.HEX_COLOR_UPPER_CASE != (this.myConvertColorCaseCheckBox.isSelected() && this.myColorUpperCaseRadioButton.isSelected())) {
            return true;
        }
        if (cssSettings.HEX_COLOR_LOWER_CASE != (this.myConvertColorCaseCheckBox.isSelected() && this.myColorLowerCaseRadioButton.isSelected())) {
            return true;
        }
        if (cssSettings.HEX_COLOR_LONG_FORMAT != (this.myConvertColorFormatCheckBox.isSelected() && this.myLongFormatRadioButton.isSelected())) {
            return true;
        }
        if (cssSettings.HEX_COLOR_SHORT_FORMAT != (this.myConvertColorFormatCheckBox.isSelected() && this.myShortFormatRadioButton.isSelected())) {
            return true;
        }
        return this.myCommenterForm.isModified(settings);
    }

    private static int getComboValue(JComboBox<?> comboBox) {
        return comboBox.getSelectedIndex();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myPreviewPanel = new JPanel();
        this.installPreviewPanel(this.myPreviewPanel);
        this.myJBScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                return new Dimension(prefSize.width + 15, prefSize.height);
            }
        };
        this.myCommenterForm = new CommenterForm(((LanguageFileType)this.myFileType).getLanguage(), CssBundle.message("css.settings.comments", new Object[0]));
        this.myCommentStyleComponent = this.myCommenterForm.getCommenterPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = this.myJBScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.braces.placement"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(113, 26), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.align.value"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.spaces.frame.title"), (int)0, (int)0, null, null));
        this.mySpaceAfterColonCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.space.after.colon"));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpaceBeforeOpeningBraceCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.space.before.opening.brace"));
        jPanel4.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignClosingBraceWithPropertiesCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.tab.before.closing.brace"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKeepSingleLineBlocksCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.keep.single.line.blocks"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myBracePlacementCombo = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myAlignValueCombo = jComboBox2;
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.frame.title"), (int)0, (int)0, null, null));
        this.myConvertColorCaseCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.case.checkbox"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myColorLowerCaseRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.case.lower"));
        jPanel6.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myColorUpperCaseRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.case.upper"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConvertColorFormatCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.format.checkbox"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLongFormatRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.format.long"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShortFormatRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.colors.format.short"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.quote.marks"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myQuotesCombo = jComboBox3;
        jPanel3.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myEnforceQuotesOnFormat = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CssBundle", CssCodeStylePanel.class).getString("css.code.style.quotes.enforce.on.format"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = this.myCommentStyleComponent;
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel8, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = this.myPreviewPanel;
        jPanel.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettingsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "box";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/codeStyle/CssCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/codeStyle/CssCodeStylePanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

