/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssPseudoSelector;
import org.jetbrains.annotations.NotNull;

public class CssReplacePseudoPrefixQuickFix
implements LocalQuickFix {
    private final int oldLength;
    private final int newLength;

    public CssReplacePseudoPrefixQuickFix(int actualLength, int expectedLength) {
        this.oldLength = actualLength;
        this.newLength = expectedLength;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = CssBundle.message("css.inspections.invalid.pseudo.prefix.quickfix", StringUtil.repeatSymbol((char)':', (int)this.oldLength), StringUtil.repeatSymbol((char)':', (int)this.newLength));
        if (string == null) {
            CssReplacePseudoPrefixQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("css.inspections.invalid.pseudo.prefix.quickfix.family.name", new Object[0]);
        if (string == null) {
            CssReplacePseudoPrefixQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CssReplacePseudoPrefixQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CssReplacePseudoPrefixQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement pseudoSelector = descriptor.getPsiElement();
        if (this.newLength > 0 && pseudoSelector instanceof CssPseudoSelector) {
            String name = ((CssPseudoSelector)pseudoSelector).getName();
            CssElementFactory elementFactory = CssElementFactory.getInstance(project);
            boolean isEscaped = StringUtil.startsWithChar((CharSequence)pseudoSelector.getText().trim(), (char)'\\');
            CssPseudoSelector newPseudoSelector = elementFactory.createPseudoSelector(StringUtil.repeatSymbol((char)':', (int)this.newLength) + name, CssPsiUtil.getStylesheetLanguage(pseudoSelector), isEscaped);
            pseudoSelector.replace((PsiElement)newPseudoSelector);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/fixes/CssReplacePseudoPrefixQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/fixes/CssReplacePseudoPrefixQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

