/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.ref;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jinja/ref/Jinja2Reference;", "Lcom/intellij/psi/PsiReference;", "myElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getCanonicalText", "", "handleElementRename", "newElementName", "bindToElement", "element", "isReferenceTo", "", "isSoft", "intellij.jinja"})
public abstract class Jinja2Reference
implements PsiReference {
    @NotNull
    private final PsiElement myElement;

    public Jinja2Reference(@NotNull PsiElement myElement) {
        Intrinsics.checkNotNullParameter((Object)myElement, (String)"myElement");
        this.myElement = myElement;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        if (this.myElement instanceof PsiNamedElement) {
            PsiElement psiElement = ((PsiNamedElement)this.myElement).setName(newElementName);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"setName(...)");
            return psiElement;
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)this.resolve(), (Object)element);
    }

    public boolean isSoft() {
        return false;
    }
}

