/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.templates.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pyramid.templates.ChameleonLanguage;
import com.intellij.python.pyramid.templates.file.ChameleonFileViewProvider;
import com.intellij.python.pyramid.templates.lexer.ChameleonTokenTypes;
import com.intellij.python.pyramid.templates.psi.ChameleonReferenceExpression;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ChameleonPrefixTypesCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NonNls
    private static final String[] PREFIX_TYPES_ELEMENTS = new String[]{"exists", "import", "load", "not", "python", "string", "structure"};
    public static final Set<String> PREFIX_TYPES = new HashSet<String>();
    private static final int KEYWORD_PRIORITY = 1;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiFile file;
        FileViewProvider provider;
        if (parameters == null) {
            ChameleonPrefixTypesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ChameleonPrefixTypesCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((provider = (file = parameters.getOriginalFile()).getViewProvider()) instanceof ChameleonFileViewProvider) {
            PsiElement prevSibling;
            PsiElement chameleonElement = provider.findElementAt(parameters.getOffset() - 1, ChameleonLanguage.class);
            if (chameleonElement == null) {
                return;
            }
            ASTNode chameleonNode = chameleonElement.getNode();
            ChameleonReferenceExpression reference = (ChameleonReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)chameleonElement, ChameleonReferenceExpression.class);
            if (reference != null && !reference.isQualified() && (prevSibling = reference.getPrevSibling()) != null) {
                chameleonNode = prevSibling.getNode();
            }
            if (chameleonNode != null && (chameleonNode.getElementType() == ChameleonTokenTypes.SUBSTITUTION_EXPR || chameleonNode.getElementType() == ChameleonTokenTypes.ATTR_START_DELIM)) {
                for (String prefix : PREFIX_TYPES) {
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)(prefix + ":")), (double)1.0));
                }
            }
        }
    }

    static {
        PREFIX_TYPES.addAll(Arrays.asList(PREFIX_TYPES_ELEMENTS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pyramid/templates/completion/ChameleonPrefixTypesCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

