/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import com.jetbrains.gateway.impl.BootstrapClassLoaderUtil;
import com.jetbrains.gateway.impl.ExternalGatewayConfigMerger;
import com.jetbrains.gateway.plugins.IdeaPluginDescriptorExKt;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000eJ\b\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/gateway/impl/GatewayStarter;", "", "<init>", "()V", "gatewayPluginId", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "runGatewayProcess", "", "url", "extraEnv", "Lkotlin/Pair;", "onSuccessfulDeploy", "Lkotlin/Function1;", "getGatewayAppInfo", "addDefaultVmOptions", "javaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "options", "getCurrentTimeString", "isGatewayRunning", "", "configPath", "Ljava/nio/file/Path;", "systemPath", "cleanTrustedHostsSettingsIfExists", "intellij.gateway.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGatewayStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,360:1\n1#2:361\n23609#3,10:362\n14#4:372\n*S KotlinDebug\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarter\n*L\n107#1:362,10\n44#1:372\n*E\n"})
public final class GatewayStarter {
    @NotNull
    public static final GatewayStarter INSTANCE = new GatewayStarter();
    @NotNull
    public static final String gatewayPluginId = "com.jetbrains.gateway";
    @NotNull
    private static final Logger logger;

    private GatewayStarter() {
    }

    public final void runGatewayProcess(@NotNull String url, @NotNull Pair<String, String> extraEnv, @NotNull Function1<? super String, Unit> onSuccessfulDeploy) {
        int debugPort;
        String licensePropertyName;
        String licenseProperty;
        Object vmOptionsPath;
        Object gatewayPluginPath;
        File currentConfigPath;
        File file2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(extraEnv, (String)"extraEnv");
        Intrinsics.checkNotNullParameter(onSuccessfulDeploy, (String)"onSuccessfulDeploy");
        GatewayUsagesCollector.INSTANCE.onGtwFromStandaloneIdeStarted();
        boolean isInDevServerMode = AppMode.isDevServer();
        boolean isProductionMode = isInDevServerMode || !PluginManagerCore.isRunningFromSources();
        File javaHome = new File(System.getProperty("java.home"));
        if (!JdkUtil.checkForJre((Path)javaHome.toPath())) {
            File file = javaHome.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            javaHome = file;
            if (!JdkUtil.checkForJre((Path)javaHome.toPath())) {
                throw new IllegalStateException("Invalid Java home " + System.getProperty("java.home"));
            }
        }
        SimpleJavaParameters javaParameters = new SimpleJavaParameters();
        SimpleJavaSdkType sdkType = new SimpleJavaSdkType();
        Sdk jdk = sdkType.createJdk("", javaHome.getPath());
        File it = file2 = new File(PathManager.getTempPath(), "JetBrainsGateway");
        boolean bl = false;
        it.mkdirs();
        File rootTempDir = file2;
        File it2 = it = new File(rootTempDir, "config");
        boolean bl2 = false;
        it2.mkdirs();
        File configDir = it;
        File it3 = it2 = new File(configDir, "plugins");
        boolean bl3 = false;
        it3.mkdirs();
        File pluginDir = it2;
        File it4 = it3 = new File(rootTempDir, "system");
        boolean bl4 = false;
        it4.mkdirs();
        File systemDir = it3;
        File it5 = it4 = FilesKt.resolve((File)new File(PathManager.getLogPath(), "gateway"), (String)this.getCurrentTimeString());
        boolean bl5 = false;
        it5.mkdirs();
        File logDir = it4;
        Path path2 = configDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        this.cleanTrustedHostsSettingsIfExists(path2);
        StoreUtil.saveSettings((ComponentManager)((ComponentManager)ApplicationKt.getApplication()), (boolean)true);
        File currentOptionsDir = new File(PathManager.getOptionsPath());
        if (currentOptionsDir.isDirectory()) {
            FileUtil.copyDir((File)currentOptionsDir, (File)new File(configDir, "options"));
        }
        if ((currentConfigPath = new File(PathManager.getConfigPath())).isDirectory()) {
            File[] fileArray = currentConfigPath.listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            for (File configFile : fileArray) {
                String string = configFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith((String)string, (String)"key", (boolean)true)) {
                    String string2 = configFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!StringsKt.endsWith((String)string2, (String)"kdbx", (boolean)true)) {
                        String string3 = configFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        if (!StringsKt.endsWith((String)string3, (String)"pwd", (boolean)true)) continue;
                    }
                }
                String string4 = configFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                File target = FilesKt.resolve((File)configDir, (String)string4);
                try {
                    logger.info("Copy \"" + configFile + "\" -> \"" + target + "\"");
                    Intrinsics.checkNotNull((Object)configFile);
                    File file = FilesKt.copyTo$default((File)configFile, (File)target, (boolean)false, (int)0, (int)6, null);
                }
                catch (Exception ex) {
                    logger.warn((Throwable)ex);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        ExternalGatewayConfigMerger stateUpdater = new ExternalGatewayConfigMerger();
        Path path3 = configDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
        Path path4 = systemDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
        boolean isGatewayRunning = this.isGatewayRunning(path3, path4);
        if (isProductionMode && !isGatewayRunning) {
            IdeaPluginDescriptor[] $this$partition$iv = PluginManagerCore.getPlugins();
            boolean $i$f$partition = false;
            ArrayList<IdeaPluginDescriptor> arrayList = new ArrayList<IdeaPluginDescriptor>();
            ArrayList<IdeaPluginDescriptor> second$iv = new ArrayList<IdeaPluginDescriptor>();
            int n = $this$partition$iv.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it6 = element$iv = $this$partition$iv[i];
                boolean bl6 = false;
                boolean bl7 = it6 instanceof IdeaPluginDescriptorImpl && IdeaPluginDescriptorExKt.isGatewayPlugin((IdeaPluginDescriptorImpl)it6) ? arrayList.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(arrayList, second$iv);
            List gatewayPlugins = (List)pair.component1();
            List pluginsToDisable = (List)pair.component2();
            for (IdeaPluginDescriptor pluginDescriptor : gatewayPlugins) {
                Path ideaPluginPath = pluginDescriptor.getPluginPath();
                Intrinsics.checkNotNull((Object)ideaPluginPath);
                String pluginDirName = PathsKt.getName((Path)ideaPluginPath);
                gatewayPluginPath = new File(pluginDir, pluginDirName);
                if (((File)gatewayPluginPath).exists()) {
                    try {
                        FileUtil.deleteRecursively((Path)((File)gatewayPluginPath).toPath());
                    }
                    catch (Throwable t) {
                        logger.info("Failed to delete file(s) in directory: <" + ((File)gatewayPluginPath).getCanonicalPath() + ">", t);
                        continue;
                    }
                }
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(ideaPluginPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                try {
                    FileUtil.copyDir((File)ideaPluginPath.toFile(), (File)gatewayPluginPath);
                }
                catch (Throwable t) {
                    logger.info("Unable to copy plugin path: <" + ((Object)ideaPluginPath).toString() + "> -> <" + ((File)gatewayPluginPath).getCanonicalPath() + ">");
                }
            }
            FilesKt.writeText$default((File)FilesKt.resolve((File)configDir, (String)"disabled_plugins.txt"), (String)CollectionsKt.joinToString$default((Iterable)pluginsToDisable, (CharSequence)"\n", null, null, (int)0, null, GatewayStarter::runGatewayProcess$lambda$6, (int)30, null), null, (int)2, null);
        }
        File gatewayAppInfoPath = FilesKt.resolve((File)configDir, (String)"info.xml");
        String gatewayAppInfo = this.getGatewayAppInfo();
        FilesKt.writeText$default((File)gatewayAppInfoPath, (String)gatewayAppInfo, null, (int)2, null);
        javaParameters.getVMParametersList().defineProperty("idea.application.info.value", gatewayAppInfoPath.getPath());
        if (isProductionMode) {
            String[] stringArray = new String[]{gatewayPluginId};
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.findId(stringArray));
            if (plugin == null) {
                throw new Exception("Can not start gateway: plugin com.jetbrains.gateway is not found.");
            }
            Path path5 = plugin.getPluginPath().resolve("lib").resolve("gateway-standalone");
            Intrinsics.checkNotNull((Object)path5);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new Exception("Can not start gateway: directory \"" + path5 + "\" is not found in plugin com.jetbrains.gateway.");
            }
            List additionalClassPath = new ArrayList();
            for (Path standaloneFile : PathsKt.listDirectoryEntries$default((Path)path5, null, (int)1, null)) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(standaloneFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !StringsKt.equals((String)PathsKt.getExtension((Path)standaloneFile), (String)"jar", (boolean)true)) continue;
                javaParameters.getClassPath().add(standaloneFile.toFile());
                additionalClassPath.add(((Object)standaloneFile).toString());
            }
            ParametersList parametersList = javaParameters.getVMParametersList();
            Path path6 = plugin.getPluginPath();
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"getPluginPath(...)");
            parametersList.defineProperty("com.jetbrains.gateway.plugin.path.for.remote.dev.workers", ((Object)path6.toAbsolutePath()).toString());
            ParametersList parametersList2 = javaParameters.getVMParametersList();
            Iterable iterable = additionalClassPath;
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
            parametersList2.defineProperty("idea.additional.classpath", CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
            vmOptionsPath = plugin.getPluginPath().resolve("resources").resolve("gateway.vmoptions");
            Intrinsics.checkNotNull((Object)vmOptionsPath);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists((Path)vmOptionsPath, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                throw new Exception("Can not start gateway: resource \"" + (Path)vmOptionsPath + "\" is not found in plugin com.jetbrains.gateway.");
            }
            logger.info("Use vmOptions: " + (Path)vmOptionsPath);
            this.addDefaultVmOptions(javaParameters, PathsKt.readText$default((Path)vmOptionsPath, null, (int)1, null));
        } else {
            Path path7 = PathManager.getJarForClass(GatewayStarter.class);
            Intrinsics.checkNotNull((Object)path7);
            Path root = path7.getParent();
            Path path8 = root.resolve("intellij.gateway");
            Intrinsics.checkNotNull((Object)path8);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path8, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new Exception("Can not find \"intellij.gateway\" in \"" + (Path)root + "\", try rebuild whole project and restart IDE.");
            }
            javaParameters.getClassPath().add(path8.toFile());
            URL vmOptionsPath2 = GatewayStarter.class.getResource("/gateway.vmoptions");
            if (vmOptionsPath2 == null) {
                throw new Exception("Can not find \"gateway.vmoptions\" in resources, try rebuild whole project and restart IDE.");
            }
            logger.info("Use vmOptions from resources");
            vmOptionsPath = vmOptionsPath2;
            Charset standaloneFile = Charsets.UTF_8;
            gatewayPluginPath = TextStreamsKt.readBytes((URL)vmOptionsPath);
            this.addDefaultVmOptions(javaParameters, new String((byte[])gatewayPluginPath, standaloneFile));
        }
        for (Path path9 : BootstrapClassLoaderUtil.getProductClassPath()) {
            Intrinsics.checkNotNull((Object)path9);
            if (StringsKt.equals((String)PathsKt.getName((Path)path9), (String)"intellij.gateway.plugin", (boolean)true)) continue;
            javaParameters.getClassPath().add(path9.toFile());
        }
        javaParameters.setJdk(jdk);
        javaParameters.setMainClass("com.intellij.idea.Main");
        javaParameters.setShortenCommandLine(ShortenCommandLine.ARGS_FILE, null);
        javaParameters.getVMParametersList().defineProperty("idea.platform.prefix", "Gateway");
        javaParameters.getVMParametersList().defineProperty("idea.parent.product", PlatformUtils.getPlatformPrefix());
        javaParameters.getVMParametersList().defineProperty("idea.config.path", configDir.getPath());
        javaParameters.getVMParametersList().defineProperty("idea.system.path", systemDir.getPath());
        javaParameters.getVMParametersList().defineProperty("idea.log.path", logDir.getPath());
        javaParameters.getVMParametersList().defineProperty("gateway.trusted.host.ui.not.changeable", "true");
        if (!isProductionMode) {
            javaParameters.getVMParametersList().defineProperty("idea.is.internal", "true");
        }
        Object[] objectArray = new String[]{"jna.boot.library.path", "pty4j.preferred.native.folder", "intellij.platform.runtime.repository.path"};
        List propertiesToPass = CollectionsKt.listOf((Object[])objectArray);
        for (String property : propertiesToPass) {
            javaParameters.getVMParametersList().defineProperty(property, System.getProperty(property));
        }
        String string = "idea.suppressed.plugins.set.selector";
        String suppressedPluginsSetValue = System.getProperty("idea.suppressed.plugins.set.selector");
        vmOptionsPath = suppressedPluginsSetValue;
        if (!(vmOptionsPath == null || StringsKt.isBlank((CharSequence)vmOptionsPath))) {
            javaParameters.getVMParametersList().defineProperty(string, suppressedPluginsSetValue);
        }
        if ((licenseProperty = System.getProperty(licensePropertyName = "eap.require.license")) != null && ((CharSequence)licenseProperty).length() > 0) {
            javaParameters.getVMParametersList().defineProperty(licensePropertyName, licenseProperty);
        }
        if ((debugPort = Registry.Companion.get("gateway.embedded.process.debug.port").asInteger()) > 0) {
            String suspend = Registry.Companion.is("gateway.embedded.process.debug.suspend") ? "y" : "n";
            javaParameters.getVMParametersList().add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort);
        }
        javaParameters.getProgramParametersList().add(url);
        javaParameters.addEnv((String)extraEnv.getFirst(), (String)extraEnv.getSecond());
        logger.info("Start Gateway process, log directory: " + logDir);
        OSProcessHandler oSProcessHandler = javaParameters.createOSProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createOSProcessHandler(...)");
        OSProcessHandler processHandler = oSProcessHandler;
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(logDir, stateUpdater, configDir, onSuccessfulDeploy){
            final /* synthetic */ File $logDir;
            final /* synthetic */ ExternalGatewayConfigMerger $stateUpdater;
            final /* synthetic */ File $configDir;
            final /* synthetic */ Function1<String, Unit> $onSuccessfulDeploy;
            {
                this.$logDir = $logDir;
                this.$stateUpdater = $stateUpdater;
                this.$configDir = $configDir;
                this.$onSuccessfulDeploy = $onSuccessfulDeploy;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                File logFile;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                File file = logFile = ProcessOutputType.isStdout(outputType) ? FilesKt.resolve((File)this.$logDir, (String)"out.log") : (ProcessOutputType.isStderr(outputType) ? FilesKt.resolve((File)this.$logDir, (String)"err.log") : null);
                if (file != null) {
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    FilesKt.appendText$default((File)file, (String)((Object)StringsKt.trim((CharSequence)string)).toString(), null, (int)2, null);
                }
                File file2 = logFile;
                if (file2 != null) {
                    FilesKt.appendText$default((File)file2, (String)"\n", null, (int)2, null);
                }
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.checkForSuccessfulDeploy(string);
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.syncTrustedHosts();
            }

            private final void syncTrustedHosts() {
                Path path2 = this.$configDir.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                Path path3 = path2;
                Path path4 = path3.resolve("options");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                path3 = path4;
                Path path5 = path3.resolve("GatewayTrustedHostsConfigProvider.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                this.$stateUpdater.updateTrustedHostsState(path5);
            }

            private final void checkForSuccessfulDeploy(String message) {
                if (!StringsKt.contains$default((CharSequence)message, (CharSequence)"Deployment Successful #$hi#", (boolean)false, (int)2, null)) {
                    return;
                }
                this.syncTrustedHosts();
                this.$onSuccessfulDeploy.invoke((Object)message);
            }
        });
        processHandler.startNotify();
        File launchLogFile = FilesKt.resolve((File)logDir, (String)"launch.log");
        String string5 = processHandler.getCommandLineForLog();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getCommandLineForLog(...)");
        FilesKt.appendText$default((File)launchLogFile, (String)string5, null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\nClassPath:", null, (int)2, null);
        for (String path7 : javaParameters.getClassPath().getPathList()) {
            FilesKt.appendText$default((File)launchLogFile, (String)("\n" + path7), null, (int)2, null);
        }
        FilesKt.appendText$default((File)launchLogFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\nApplicationInfo:", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)("\n" + gatewayAppInfo), null, (int)2, null);
    }

    private final String getGatewayAppInfo() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
        ApplicationInfoEx appInfo = applicationInfoEx;
        URL gatewayAppInfoResource = GatewayStarter.class.getResource("/template.xml");
        if (gatewayAppInfoResource == null) {
            throw new Exception("Can not start gateway: template.xml is not found in plugin com.jetbrains.gateway.");
        }
        URL uRL = gatewayAppInfoResource;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String gatewayAppInfoTemplate = new String(byArray, charset);
        String string = appInfo.getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMajorVersion(...)");
        String string2 = StringsKt.replace$default((String)gatewayAppInfoTemplate, (String)"__MAJOR__", (String)string, (boolean)false, (int)4, null);
        String string3 = appInfo.getMinorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMinorVersion(...)");
        String string4 = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"__MINOR__", (String)string3, (boolean)false, (int)4, null), (String)"__EAP__", (String)(appInfo.isEAP() ? "true" : "false"), (boolean)false, (int)4, null);
        String string5 = appInfo.getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"asStringWithoutProductCode(...)");
        return StringsKt.replace$default((String)string4, (String)"__BUILD__", (String)string5, (boolean)false, (int)4, null);
    }

    private final void addDefaultVmOptions(SimpleJavaParameters javaParameters, String options) {
        for (String option : StringsKt.lines((CharSequence)options)) {
            if (StringsKt.isBlank((CharSequence)option)) continue;
            javaParameters.getVMParametersList().add(option);
        }
    }

    private final String getCurrentTimeString() {
        String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final boolean isGatewayRunning(Path configPath, Path systemPath) {
        Path lockPath;
        block11: {
            block10: {
                Path portPath = systemPath.resolve(".port");
                lockPath = configPath.resolve(".lock");
                Intrinsics.checkNotNull((Object)portPath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(portPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
                Intrinsics.checkNotNull((Object)lockPath);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.notExists(lockPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block11;
            }
            Path path2 = configPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            logger.info("Gateway .port or .lock file does not exist in parent directory: <" + ((Object)path2).toString() + ">. Process is not running.");
            return false;
        }
        try {
            Object object;
            Integer pid;
            block9: {
                String pidString = PathsKt.readText$default((Path)lockPath, null, (int)1, null);
                pid = StringsKt.toIntOrNull((String)pidString);
                if (pid == null) {
                    logger.info("Read Gateway process PID value that cannot be cast to integer: <" + pid + ">");
                    return false;
                }
                ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
                Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
                for (Object object2 : (Object[])processInfoArray) {
                    ProcessInfo process = (ProcessInfo)object2;
                    boolean bl = false;
                    Integer n = pid;
                    if (!(n != null && process.getPid() == n.intValue())) continue;
                    object = object2;
                    break block9;
                }
                object = null;
            }
            ProcessInfo runningProcess = (ProcessInfo)object;
            if (runningProcess != null) {
                logger.info("Found running Gateway process with expected PID: <" + pid + ">");
                return true;
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to read running Gateway process PID from: " + ((Object)lockPath).toString(), t);
        }
        return false;
    }

    private final void cleanTrustedHostsSettingsIfExists(Path configPath) {
        Path path2 = configPath.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("GatewayTrustedHostsConfigProvider.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path trustedHostsSettingsFile = path3;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(trustedHostsSettingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete$default((Path)trustedHostsSettingsFile, (boolean)false, (int)1, null);
        }
    }

    private static final CharSequence runGatewayProcess$lambda$6(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginId().getIdString();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GatewayStarter.logger = logger;
    }
}

