/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.remoteDev.RemoteDevSystemSettings;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapper;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapperConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/gateway/ssh/DefaultCachingProductsJsonWrapperConfiguration;", "Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapperConfiguration;", "<init>", "()V", "getReleasePatternRegex", "Lkotlin/text/Regex;", "shouldShowOnlyLatestVersion", "", "getProductsJsonUrl", "", "productCode", "intellij.gateway.core"})
public final class DefaultCachingProductsJsonWrapperConfiguration
implements CachingProductsJsonWrapperConfiguration {
    @Override
    @Nullable
    public Regex getReleasePatternRegex() {
        Regex regex;
        String regValue = GatewayCoreRegistry.INSTANCE.downloadsReleasePattern();
        if (Intrinsics.areEqual((Object)regValue, (Object)"")) {
            return null;
        }
        try {
            regex = new Regex(regValue);
        }
        catch (Exception e) {
            CachingProductsJsonWrapper.Companion.getLogger$intellij_gateway_core().warn("Failed to parse release pattern regex. pattern: '" + regValue + "'", (Throwable)e);
            return null;
        }
        Regex regex2 = regex;
        CachingProductsJsonWrapper.Companion.getLogger$intellij_gateway_core().info("Pattern for release downloading is set to: '" + regex2.getPattern() + "'");
        return regex2;
    }

    @Override
    public boolean shouldShowOnlyLatestVersion() {
        return GatewayCoreRegistry.INSTANCE.isDownloadShowOnlyLatestVersionEnabled();
    }

    @Override
    @NotNull
    public String getProductsJsonUrl(@NotNull String productCode) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        return (String)RemoteDevSystemSettings.INSTANCE.getProductsUrl(productCode).getValue();
    }
}

