/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.HSet;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbTestUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.annotations.Attribute;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Dbms
implements Comparable<Dbms> {
    private static final Logger LOG = Logger.getInstance(Dbms.class);
    public static final Dbms SYNAPSE = Dbms.create("SYNAPSE", "Azure Synapse Analytics", () -> AllIcons.Providers.Azure, Dbms.defaultPattern("azure sql data warehouse"));
    public static final Dbms UNKNOWN = Dbms.create("UNKNOWN", () -> DatabaseIcons.Dbms);
    public static final Dbms ORACLE = Dbms.create("Oracle", () -> AllIcons.Providers.Oracle);
    public static final Dbms MEMSQL = Dbms.create("MEMSQL", "SingleStore", () -> AllIcons.Providers.Singlestore, Dbms.defaultPattern("singlestore|memsql"));
    public static final Dbms MARIA = Dbms.create("MariaDB", () -> AllIcons.Providers.Mariadb);
    public static final Dbms MYSQL_AURORA = Dbms.create("MYSQL_AURORA", "Amazon Aurora MySQL", () -> AllIcons.Providers.Mysql, Dbms.defaultPattern("mysql_aurora") + "|software\\.aws\\.rds\\.jdbc\\.Driver");
    public static final Dbms MYSQL = Dbms.create("MySQL", () -> AllIcons.Providers.Mysql);
    public static final Dbms POSTGRES = Dbms.create("POSTGRES", "PostgreSQL", () -> AllIcons.Providers.Postgresql);
    public static final Dbms REDSHIFT = Dbms.create("REDSHIFT", "Amazon Redshift", () -> AllIcons.Providers.Redshift);
    public static final Dbms GREENPLUM = Dbms.create("GREENPLUM", "Greenplum", () -> AllIcons.Providers.Greenplum);
    public static final Dbms SYBASE = Dbms.create("SYBASE", "Sybase ASE", () -> AllIcons.Providers.Sybase, Dbms.defaultPattern("sybase|adaptive server") + "|ase.*");
    public static final Dbms AZURE = Dbms.create("AZURE", "Azure SQL Database", () -> AllIcons.Providers.Azure);
    public static final Dbms MSSQL_LOCALDB = Dbms.create("MSSQL_LOCALDB", "Microsoft SQL Server LocalDB", () -> AllIcons.Providers.SqlServer, Dbms.defaultPattern("(mssql|sqlserver).localdb"));
    public static final Dbms MSSQL = Dbms.create("MSSQL", "Microsoft SQL Server", () -> AllIcons.Providers.SqlServer, Dbms.defaultPattern("microsoft|sqlserver|jtds"));
    public static final Dbms DB2_LUW = Dbms.create("DB2_LUW", "IBM Db2 LUW", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2_IS = Dbms.create("DB2_IS", "IBM Db2 iSeries", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2_ZOS = Dbms.create("DB2_ZOS", "IBM Db2 z/OS", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2 = Dbms.create("DB2", "IBM Db2", () -> AllIcons.Providers.DB2, "(?i).*(?:\\bDB2|[:.]as400[:.]).*");
    public static final Dbms SQLITE = Dbms.create("SQLite", () -> AllIcons.Providers.Sqlite);
    public static final Dbms HSQL = Dbms.create("HSQLDB", "HSQLDB", () -> AllIcons.Providers.Hsqldb, Dbms.defaultPattern("hsql"));
    public static final Dbms H2 = Dbms.create("H2", () -> AllIcons.Providers.H2);
    public static final Dbms DERBY = Dbms.create("DERBY", "Apache Derby", () -> AllIcons.Providers.ApacheDerby);
    public static final Dbms EXASOL = Dbms.create("EXASOL", "Exasol", () -> AllIcons.Providers.Exasol, Dbms.defaultPattern("exasol|exa"));
    public static final Dbms CLICKHOUSE = Dbms.create("ClickHouse", () -> AllIcons.Providers.ClickHouse);
    public static final Dbms CASSANDRA = Dbms.create("CASSANDRA", "Apache Cassandra", () -> AllIcons.Providers.Cassandra);
    public static final Dbms VERTICA = Dbms.create("Vertica", () -> AllIcons.Providers.Vertica);
    public static final Dbms HIVE = Dbms.create("HIVE", "Apache Hive", () -> AllIcons.Providers.Hive);
    public static final Dbms SPARK = Dbms.create("SPARK", "Apache Spark", () -> AllIcons.Providers.Spark, Dbms.defaultPattern("spark"));
    public static final Dbms DATABRICKS = Dbms.create("DATABRICKS", "Databricks", () -> AllIcons.Providers.Databricks, Dbms.defaultPattern("databricks"));
    public static final Dbms SNOWFLAKE = Dbms.create("Snowflake", () -> AllIcons.Providers.Snowflake);
    public static final Dbms MONGO = Dbms.create("MONGO", "MongoDB", () -> AllIcons.Providers.MongoDB, Dbms.defaultPattern("mongo|documentdb"));
    public static final Dbms COCKROACH = Dbms.create("COCKROACH", "CockroachDB", () -> AllIcons.Providers.CockroachDB);
    public static final Dbms BIGQUERY = Dbms.create("BIGQUERY", "BigQuery", () -> AllIcons.Providers.BigQuery);
    public static final Dbms COUCHBASE_QUERY = Dbms.create("COUCHBASE", "Couchbase Query", () -> AllIcons.Providers.Couchbase);
    public static final HSet POSTGRES_LIKE = HSet.create("POSTGRES_LIKE");
    public static final HSet MYSQL_LIKE = HSet.create("MYSQL_LIKE");
    public static final HSet DB2_LIKE = HSet.create("DB2_LIKE");
    public static final HSet AZURE_LIKE = HSet.create("AZURE_LIKE");
    public static final HSet MSSQL_LIKE = HSet.create("MSSQL_LIKE");
    public static final HSet PRESTO_LIKE = HSet.create("PRESTO_LIKE");
    public static final HSet TRANSACT_SQL = HSet.create("TRANSACT_SQL");
    public static final HSet ORACLE_LIKE = HSet.create("ORACLE_LIKE");
    public static final HSet HIVE_LIKE = HSet.create("HIVE_LIKE");
    public static final HSet SPARK_LIKE = HSet.create("SPARK_LIKE");
    public static final HSet DOCUMENT_ORIENTED = HSet.create("DOCUMENT_ORIENTED");
    public static final HSet PSEUDO_SUPPORTED = HSet.create("PSEUDO_SUPPORTED");
    private final String myName;
    private final String myDisplayName;
    private final NotNullLazyValue<Icon> myIcon;
    private final HSet mySet;
    private final Pattern myDetector;
    private static final ExtensionPointName<DbmsBean> DBMS_EP = ExtensionPointName.create((String)"com.intellij.database.dbms");
    private static final KeyedExtensionCollector<DbmsBean, String> DBMS_COLLECTOR = new KeyedExtensionCollector(DBMS_EP);

    @NotNull
    public static Dbms create(@NotNull String displayName, @NotNull Supplier<Icon> icon) {
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(1);
        }
        return Dbms.create(displayName, displayName, icon);
    }

    @NotNull
    public static Dbms create(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(3);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(4);
        }
        return Dbms.create(name2, displayName, icon, null);
    }

    @NotNull
    public static Dbms create(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon, @RegExp @Nullable String detectPattern) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(7);
        }
        name2 = Strings.toUpperCase((String)name2);
        String pattern = detectPattern == null ? Dbms.defaultPattern(name2) : detectPattern;
        return new Dbms(name2, displayName, icon, Pattern.compile(pattern));
    }

    public static String defaultPattern(@NotNull String name2) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(8);
        }
        return String.format("(?i).*\\b(?:%s).*", name2.replace("_", ".*"));
    }

    private Dbms(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon, @NotNull Pattern detector) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(9);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(10);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(11);
        }
        if (detector == null) {
            Dbms.$$$reportNull$$$0(12);
        }
        this.myName = name2;
        this.myDisplayName = displayName;
        this.myIcon = NotNullLazyValue.lazy(icon);
        this.mySet = HSet.create(name2);
        this.myDetector = detector;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = (Icon)this.myIcon.getValue();
        if (icon == null) {
            Dbms.$$$reportNull$$$0(15);
        }
        return icon;
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public HSet getHSet() {
        HSet hSet = this.mySet;
        if (hSet == null) {
            Dbms.$$$reportNull$$$0(16);
        }
        return hSet;
    }

    public boolean isOracle() {
        return this.in(ORACLE_LIKE);
    }

    public boolean isMysql() {
        return this.in(MYSQL_LIKE);
    }

    public boolean isPostgres() {
        return this.in(POSTGRES_LIKE);
    }

    public boolean isBigQuery() {
        return this.is(BIGQUERY);
    }

    public boolean isRedshift() {
        return this.is(REDSHIFT);
    }

    public boolean isGreenplum() {
        return this.is(GREENPLUM);
    }

    public boolean isVertica() {
        return this.is(VERTICA);
    }

    public boolean isMicrosoft() {
        return this.in(MSSQL_LIKE);
    }

    public boolean isSybase() {
        return this.is(SYBASE);
    }

    public boolean isDb2() {
        return this.in(DB2_LIKE);
    }

    public boolean isHsqldb() {
        return this.is(HSQL);
    }

    public boolean isH2() {
        return this.is(H2);
    }

    public boolean isDerby() {
        return this.is(DERBY);
    }

    public boolean isSqlite() {
        return this.is(SQLITE);
    }

    public boolean isExasol() {
        return this.is(EXASOL);
    }

    public boolean isClickHouse() {
        return this.is(CLICKHOUSE);
    }

    public boolean isCassandra() {
        return this.is(CASSANDRA);
    }

    public boolean isHive() {
        return this.in(HIVE_LIKE);
    }

    public boolean isSpark() {
        return this.in(SPARK_LIKE);
    }

    public boolean isSnowflake() {
        return this.is(SNOWFLAKE);
    }

    public boolean isMongo() {
        return this.is(MONGO);
    }

    public boolean isCouchbase() {
        return this.is(COUCHBASE_QUERY);
    }

    public boolean isTransactSql() {
        return this.in(TRANSACT_SQL);
    }

    public boolean eq(@Nullable Dbms dbms) {
        return this == dbms;
    }

    public boolean is(@Nullable Dbms dbms) {
        return this.eq(dbms);
    }

    public boolean in(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(17);
        }
        return this.in(dbms.getHSet());
    }

    public boolean in(@NotNull HSet set) {
        if (set == null) {
            Dbms.$$$reportNull$$$0(18);
        }
        return set.contains(this.mySet);
    }

    @NotNull
    public static Dbms forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        Dbms result2 = Dbms.fromString(o.getUrl());
        if (result2 != UNKNOWN) {
            Dbms dbms = result2;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        return Dbms.fromString(o.getDriverClass());
    }

    @NotNull
    public static Dbms fromString(@Nullable String text2) {
        if (text2 == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(21);
            }
            return dbms;
        }
        Collection<Dbms> values = Dbms.allValues();
        for (Dbms dbms : values) {
            if (!dbms.myDetector.matcher(text2).matches()) continue;
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                Dbms.$$$reportNull$$$0(22);
            }
            return dbms2;
        }
        String pattern = "(?i).*\\b(?:%s).*";
        for (Dbms dbms : values) {
            if (!text2.matches(String.format(pattern, dbms.getName()))) continue;
            Dbms dbms3 = dbms;
            if (dbms3 == null) {
                Dbms.$$$reportNull$$$0(23);
            }
            return dbms3;
        }
        Dbms dbms = UNKNOWN;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(24);
        }
        return dbms;
    }

    @Nullable
    public static Dbms byName(@Nullable String name2) {
        DbmsBean bean = name2 == null ? null : Dbms.findBeanOpt(name2);
        return bean == null ? null : bean.getDbms();
    }

    @NotNull
    public static Collection<Dbms> allValues() {
        List list = ContainerUtil.mapNotNull(Dbms.allBeans(), DbmsBean::getDbms);
        if (list == null) {
            Dbms.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static HSet asSet(Dbms ... dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(26);
        }
        HSet[] sets = new HSet[dbms.length];
        for (int i2 = 0; i2 < dbms.length; ++i2) {
            sets[i2] = dbms[i2].getHSet();
        }
        HSet hSet = HSet.create(sets);
        if (hSet == null) {
            Dbms.$$$reportNull$$$0(27);
        }
        return hSet;
    }

    @NotNull
    public static Iterable<Dbms> allValues(@NotNull HSet set) {
        if (set == null) {
            Dbms.$$$reportNull$$$0(28);
        }
        JBIterable jBIterable = JBIterable.from(Dbms.allValues()).filter(d -> d.in(set));
        if (jBIterable == null) {
            Dbms.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    @Override
    public int compareTo(@NotNull Dbms o) {
        if (o == null) {
            Dbms.$$$reportNull$$$0(30);
        }
        return Comparing.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
    }

    public static PluginDescriptor getPluginDescriptor(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(31);
        }
        return Dbms.findBean(dbms.getName()).getPluginDescriptor();
    }

    public static boolean isPredefined(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(32);
        }
        DbmsBean bean = Dbms.findBean(dbms.getName());
        return bean.instance.startsWith(Dbms.class.getName());
    }

    @NotNull
    private static DbmsBean findBean(@NotNull String name2) {
        DbmsBean bean;
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(33);
        }
        if ((bean = Dbms.findBeanOpt(name2)) == null) {
            throw new AssertionError((Object)(name2 + " should register DbmsBean with `id=\"" + name2 + "\"` in xml"));
        }
        DbmsBean dbmsBean = bean;
        if (dbmsBean == null) {
            Dbms.$$$reportNull$$$0(34);
        }
        return dbmsBean;
    }

    @Nullable
    private static DbmsBean findBeanOpt(@NotNull String name2) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(35);
        }
        if (Dbms.shouldFallback(ApplicationManager.getApplication())) {
            return (DbmsBean)Dbms.getFallbackBeans().find(b -> b.id.equals(name2));
        }
        List beans = DBMS_COLLECTOR.forKey((Object)name2);
        if (beans.isEmpty()) {
            return null;
        }
        if (beans.size() != 1) {
            LOG.error("Multiple DBMS registered with id=" + name2 + " in plugins: [" + StringUtil.join((Collection)beans, b -> b.getPluginDescriptor().getPluginId().getIdString(), (String)", ") + "]");
        }
        return (DbmsBean)beans.get(0);
    }

    private static Iterable<DbmsBean> allBeans() {
        Application app = ApplicationManager.getApplication();
        if (Dbms.shouldFallback(app)) {
            return Dbms.getFallbackBeans();
        }
        return DBMS_EP.getExtensionList();
    }

    @NotNull
    private static JBIterable<DbmsBean> getFallbackBeans() {
        JBIterable<DbmsBean> jBIterable = DbTestUtils.loadBeans(DBMS_EP.getName(), DbmsBean.class);
        if (jBIterable == null) {
            Dbms.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    private static boolean shouldFallback(Application app) {
        return app == null || !app.getExtensionArea().hasExtensionPoint(DBMS_EP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 27, 29, 34, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/Dbms";
                break;
            }
            case 17: 
            case 26: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/Dbms";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHSet";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 25: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "allValues";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "asSet";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findBean";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "defaultPattern";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 34: 
            case 36: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "in";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "allValues";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isPredefined";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findBean";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findBeanOpt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 27, 29, 34, 36 -> new IllegalStateException(string);
        };
    }

    public static final class DbmsBean
    implements KeyedLazyInstance<DbmsBean>,
    PluginAware {
        @Attribute(value="id")
        public String id;
        @Attribute(value="instance")
        public String instance;
        private Ref<Dbms> myDbms;
        private PluginDescriptor myPluginDescriptor;

        @NotNull
        public String getKey() {
            String string = this.id;
            if (string == null) {
                DbmsBean.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public DbmsBean getInstance() {
            DbmsBean dbmsBean = this;
            if (dbmsBean == null) {
                DbmsBean.$$$reportNull$$$0(1);
            }
            return dbmsBean;
        }

        @Nullable
        public Dbms getDbms() {
            if (this.myDbms == null) {
                this.myDbms = Ref.create((Object)this.getDbms((ComponentManager)ApplicationManager.getApplication()));
            }
            return (Dbms)this.myDbms.get();
        }

        public PluginDescriptor getPluginDescriptor() {
            return this.myPluginDescriptor;
        }

        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                DbmsBean.$$$reportNull$$$0(2);
            }
            this.myPluginDescriptor = pluginDescriptor;
        }

        private Dbms getDbms(@Nullable ComponentManager componentManager) {
            int dotIdx = this.instance.lastIndexOf(46);
            if (dotIdx < 0) {
                LOG.error("Class field reference should contain `.` in: " + this.instance + "[" + String.valueOf(this.myPluginDescriptor.getPluginId()) + "]");
                return null;
            }
            try {
                String className = this.instance.substring(0, dotIdx);
                Class holder = componentManager == null ? this.myPluginDescriptor.getClassLoader().loadClass(className) : componentManager.loadClass(className, this.myPluginDescriptor);
                Dbms dbms = (Dbms)ReflectionUtil.getStaticFieldValue((Class)holder, Dbms.class, (String)this.instance.substring(dotIdx + 1));
                if (dbms == null) {
                    LOG.error("Static field not found: " + this.instance + "[" + String.valueOf(this.myPluginDescriptor.getPluginId()) + "]");
                } else if (!this.id.equals(dbms.getName())) {
                    LOG.error("Declared id=" + this.id + " does not match " + dbms.getName() + ":" + this.instance + "[" + String.valueOf(this.myPluginDescriptor.getPluginId()) + "]");
                }
                return dbms;
            }
            catch (Exception e) {
                LOG.error("Unable to find dbms: " + this.instance + "[" + String.valueOf(this.myPluginDescriptor.getPluginId()) + "]", (Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/Dbms$DbmsBean";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/Dbms$DbmsBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setPluginDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

