/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraRecordColumn;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCollectionTypeElementImpl;
import com.intellij.sql.dialects.oracle.psi.OraRecordTypeElementImpl;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0013H\u0014J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010-\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u00063"}, d2={"Lcom/intellij/database/dialects/oracle/OraObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getOraTypeContentRange", "getOraBodyContentRange", "buildTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "buildMatView", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "buildSingleRoutine", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "getRoutineBodyRange", "buildCluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "buildClusterColumn", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "buildCollectionType", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "buildObjectType", "Lcom/intellij/database/dialects/oracle/model/OraObjectType;", "buildAliasType", "Lcom/intellij/database/dialects/oracle/model/OraAliasType;", "buildPackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "buildPackageBody", "Lcom/intellij/database/dialects/oracle/model/OraPackageBody;", "buildObjectTypeBody", "Lcom/intellij/database/dialects/oracle/model/OraObjectTypeBody;", "assignName", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "buildOraIndex", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraObjectBuilder.kt\ncom/intellij/database/dialects/oracle/OraObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n648#2:201\n660#2,6:202\n648#2:208\n660#2,3:209\n663#2,3:213\n625#2,5:216\n625#2,5:221\n644#2:226\n660#2,6:227\n644#2:233\n660#2,6:234\n644#2:240\n660#2,6:241\n625#2,5:247\n644#2:252\n660#2,6:253\n1#3:212\n*S KotlinDebug\n*F\n+ 1 OraObjectBuilder.kt\ncom/intellij/database/dialects/oracle/OraObjectBuilder\n*L\n69#1:201\n69#1:202,6\n102#1:208\n102#1:209,3\n102#1:213,3\n119#1:216,5\n124#1:221,5\n130#1:226\n130#1:227,6\n131#1:233\n131#1:234,6\n132#1:240\n132#1:241,6\n193#1:247,5\n78#1:252\n78#1:253,6\n*E\n"})
public final class OraObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof OraCluster) {
            this.buildCluster((OraCluster)obj2, source, context);
        } else if (basicModElement instanceof OraClusterColumn) {
            this.buildClusterColumn((OraClusterColumn)obj2, source, context);
        } else if (basicModElement instanceof OraCollectionTypeBase) {
            this.buildCollectionType((OraCollectionTypeBase)obj2, source, context);
        } else if (basicModElement instanceof OraObjectType) {
            this.buildObjectType((OraObjectType)obj2, source, context);
        } else if (basicModElement instanceof OraAliasType) {
            this.buildAliasType((OraAliasType)obj2, source, context);
        } else if (basicModElement instanceof OraSingleRoutine) {
            this.buildSingleRoutine((OraSingleRoutine)obj2, source, context);
        } else if (basicModElement instanceof OraPackage) {
            this.buildPackage((OraPackage)obj2, source, context);
        } else if (basicModElement instanceof OraPackageBody) {
            this.buildPackageBody((OraPackageBody)obj2, source, context);
        } else if (basicModElement instanceof OraObjectTypeBody) {
            this.buildObjectTypeBody((OraObjectTypeBody)obj2, source, context);
        } else if (basicModElement instanceof OraMatView) {
            this.buildMatView((OraMatView)obj2, source, context);
        } else if (basicModElement instanceof OraTrigger) {
            this.buildTrigger((OraTrigger)obj2, source, context);
        } else if (basicModElement instanceof OraIndex) {
            this.buildOraIndex((OraIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? this.getOraTypeContentRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE) ? this.getOraBodyContentRange(def) : super.getCompactDefinition(path, text2, def)));
    }

    private final TextRange getOraTypeContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement = def;
        SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType), (String)"SQL_LEFT_PAREN");
        PsiElement psiElement2 = this.findChild(psiElement, sqlTokenType);
        if (psiElement2 != null) {
            int n;
            PsiElement it = psiElement2;
            boolean bl = false;
            int n2 = it.getTextRange().getEndOffset();
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType2), (String)"SQL_RIGHT_PAREN");
            PsiElement psiElement3 = this.findSibling(it, sqlTokenType2);
            if (psiElement3 != null && (psiElement3 = psiElement3.getTextRange()) != null) {
                n = psiElement3.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                n = psiObject.getTextRange().getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange getOraBodyContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement;
        block5: {
            void this_$iv;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement el$iv = def;
            boolean $i$f$findChild = false;
            void var5_5 = this_$iv;
            PsiElement psiElement2 = el$iv;
            PsiElement element$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)((Object)SqlTokens.SQL_IS)) || Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)((Object)SqlTokens.SQL_AS)))) continue;
                psiElement = tmp$iv$iv;
                break block5;
            }
            psiElement = null;
        }
        if (psiElement != null) {
            int n;
            PsiElement it = psiElement;
            boolean bl = false;
            int n2 = it.getTextRange().getEndOffset();
            SqlTokenType sqlTokenType = SqlTokens.SQL_END;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType), (String)"SQL_END");
            PsiElement psiElement3 = this.findSibling(it, sqlTokenType);
            if (psiElement3 != null && (psiElement3 = psiElement3.getTextRange()) != null) {
                n = psiElement3.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                n = psiObject.getTextRange().getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    private final void buildTrigger(OraTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger((BasicModTrigger)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildTrigger$lambda$5(source, this)));
    }

    private final void buildMatView(OraMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildMatView$lambda$6(this, source)));
    }

    private final void buildSingleRoutine(OraSingleRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildRoutine(obj2, source, context);
    }

    @Override
    protected void buildRoutineSources(@NotNull BasicModSourceAware obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildRoutineSources$lambda$9(this, source)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected TextRange getRoutineBodyRange(@Nullable PsiObject source) {
        SqlRoutineDefinition sqlRoutineDefinition;
        Integer s;
        TextRange textRange;
        block6: {
            void this_$iv;
            if (source == null) {
                return null;
            }
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement el$iv = source;
            boolean $i$f$findChild = false;
            void var7_5 = this_$iv;
            PsiElement element$iv$iv = el$iv.getFirstChild();
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement e = tmp$iv$iv;
                boolean bl = false;
                IElementType it = PsiUtilCore.getElementType((PsiElement)e);
                boolean bl2 = false;
                boolean bl3 = Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_IS)) || Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_AS));
                if (!bl3) continue;
                textRange = tmp$iv$iv;
                break block6;
            }
            textRange = null;
        }
        TextRange textRange2 = textRange;
        if (textRange != null && (textRange2 = textRange2.getTextRange()) != null) {
            int it = textRange2.getEndOffset();
            boolean bl = false;
            Object object = source.getContainingFile();
            if (object == null || (object = object.getNode()) == null || (object = object.getChars()) == null) {
                object = "";
            }
            v4 = this.skipSpaces(it, (CharSequence)object, 1);
        } else {
            v4 = s = null;
        }
        if (((sqlRoutineDefinition = source instanceof SqlRoutineDefinition ? (SqlRoutineDefinition)source : null) == null || (sqlRoutineDefinition = sqlRoutineDefinition.getBody()) == null || (sqlRoutineDefinition = this.unionRanges((JBIterable<? extends PsiElement>)sqlRoutineDefinition)) == null) && (sqlRoutineDefinition = this.extractSomethingAfter((PsiElement)(source instanceof SqlStatement ? (SqlStatement)((Object)source) : null))) == null) {
            TextRange textRange3 = TextRange.from((int)source.getTextRange().getEndOffset(), (int)0);
            sqlRoutineDefinition = textRange3;
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"from(...)");
        }
        SqlRoutineDefinition stmts = sqlRoutineDefinition;
        Integer n = s;
        return n == null ? stmts : stmts.union(TextRange.create((int)n, (int)s));
    }

    private final void buildCluster(OraCluster obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
    }

    /*
     * Unable to fully structure code
     */
    private final void buildClusterColumn(OraClusterColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        block10: {
            block9: {
                this.buildBasicElement(obj, source, context);
                if (!context.isStubBuilder()) {
                    v0 = source instanceof DasTypedObject != false ? (DasTypedObject)source : null;
                    if (v0 == null || (v0 = v0.getDasType()) == null || (v0 = DasTypeUtilsKt.remapAgainst((DasType)v0, obj)) == null) {
                        v0 = DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setStoredType((DasType)v0);
                }
                var4_4 = this;
                $this$stubbed$iv = source;
                $i$f$stubbed = false;
                var7_7 = $this$stubbed$iv;
                if (var7_7 instanceof OraClusterColumn) {
                    v1 = (BasicElement)$this$stubbed$iv;
                } else if (var7_7 instanceof SqlStubbedElement) {
                    var8_8 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    v2 = var8_8 instanceof SqlDefinitionStub != false ? (SqlDefinitionStub)var8_8 : null;
                    v3 = v2 != null ? v2.getElement() : null;
                    if (!(v3 instanceof OraClusterColumn)) {
                        v3 = null;
                    }
                    v1 = (OraClusterColumn)v3;
                } else {
                    v1 = null;
                }
                v4 = (OraClusterColumn)v1;
                if (v4 == null) break block9;
                v5 = v4.isSorted();
                break block10;
            }
            if (!(source instanceof SqlColumnDefinition)) ** GOTO lbl-1000
            v6 = (PsiElement)source;
            v7 = OraTypes.ORA_SORT;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ORA_SORT");
            if (this.findChild(v6, v7) != null) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
        }
        obj.setSorted(v5);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildCollectionType(OraCollectionTypeBase obj2, DasObject source, SqlObjectBuilder.Context context) {
        PsiElement psiElement;
        OraCollectionTypeBase oraCollectionTypeBase;
        OraCollectionTypeElementImpl collectionTypeElement;
        Object this_$iv;
        Object el$iv;
        block14: {
            void el$iv2;
            void this_$iv2;
            PsiElement psiElement2;
            block13: {
                Object $this$buildCollectionType_u24lambda_u2413;
                OraCollectionTypeBase oraCollectionTypeBase2;
                StubElement stubElement;
                BasicElement basicElement;
                this.buildBasicElement(obj2, source, context);
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                DasObject $this$stubbed$iv = source;
                boolean $i$f$stubbed = false;
                DasObject dasObject = $this$stubbed$iv;
                if (dasObject instanceof OraCollectionTypeBase) {
                    basicElement = (BasicElement)$this$stubbed$iv;
                } else if (dasObject instanceof SqlStubbedElement) {
                    stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
                    SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                    BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(basicElement2 instanceof OraCollectionTypeBase)) {
                        basicElement2 = null;
                    }
                    basicElement = (OraCollectionTypeBase)basicElement2;
                } else {
                    basicElement = null;
                }
                if ((oraCollectionTypeBase2 = (OraCollectionTypeBase)basicElement) != null) {
                    $this$buildCollectionType_u24lambda_u2413 = oraCollectionTypeBase2;
                    boolean bl = false;
                    obj2.setElementStoredType($this$buildCollectionType_u24lambda_u2413.getElementType());
                    obj2.setTypeKind($this$buildCollectionType_u24lambda_u2413.getTypeKind());
                    return;
                }
                SqlTypedDefinition typed = source instanceof SqlTypedDefinition ? (SqlTypedDefinition)source : null;
                $this$buildCollectionType_u24lambda_u2413 = this;
                el$iv = typed;
                boolean $i$f$findChild = false;
                stubElement = this_$iv;
                PsiElement psiElement3 = el$iv;
                PsiElement element$iv$iv = psiElement3 != null ? psiElement3.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof OraCollectionTypeElementImpl)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block13;
                }
                psiElement2 = null;
            }
            collectionTypeElement = (OraCollectionTypeElementImpl)psiElement2;
            SqlObjectBuilderImpl $i$f$findChild = this;
            PsiElement this_$iv$iv = (PsiElement)collectionTypeElement;
            oraCollectionTypeBase = obj2;
            boolean $i$f$findChild2 = false;
            void $i$f$findSibling = this_$iv2;
            void v5 = el$iv2;
            PsiElement element$iv$iv = v5 != null ? v5.getFirstChild() : null;
            boolean $i$f$findSibling2 = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlTypeElement)) continue;
                psiElement = tmp$iv$iv;
                break block14;
            }
            psiElement = null;
        }
        SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement;
        OraCollectionTypeBase oraCollectionTypeBase3 = oraCollectionTypeBase;
        Object object = sqlTypeElement;
        if (sqlTypeElement == null || (object = object.getDasType()) == null) {
            PsiElement psiElement4;
            block15: {
                void el$iv3;
                void this_$iv3;
                SqlObjectBuilderImpl $i$f$findChild2 = this;
                PsiElement this_$iv$iv = (PsiElement)collectionTypeElement;
                oraCollectionTypeBase = oraCollectionTypeBase3;
                boolean $i$f$findChild = false;
                void $i$f$findSibling2 = this_$iv3;
                void v10 = el$iv3;
                PsiElement element$iv$iv = v10 != null ? v10.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement4 = tmp$iv$iv;
                    break block15;
                }
                psiElement4 = null;
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement4;
            oraCollectionTypeBase3 = oraCollectionTypeBase;
            object = sqlReferenceExpression != null ? sqlReferenceExpression.getDasType() : null;
        }
        oraCollectionTypeBase3.setElementStoredType((DasType)((this_$iv = object) != null && (el$iv = DasTypeUtilsKt.remapAgainst((DasType)this_$iv, obj2)) != null ? el$iv : (DasType)DasTypeSystemBase.UNKNOWN));
        Object object2 = collectionTypeElement;
        if (object2 == null || (object2 = object2.getKind()) == null) {
            object2 = OraCollectionTypeKind.NESTED_TABLE;
        }
        obj2.setTypeKind((OraCollectionTypeKind)((Object)object2));
        if (obj2 instanceof OraPackageCollectionType && ((OraPackageCollectionType)obj2).getTypeKind() == OraCollectionTypeKind.ASSOCIATIVE_ARRAY) {
            PsiElement psiElement5 = (PsiElement)collectionTypeElement;
            IElementType iElementType = OraTypes.ORA_INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ORA_INDEX");
            PsiElement indexKeyword = this.findChild(psiElement5, iElementType);
            SqlTypeElement indexTypeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)indexKeyword, SqlTypeElement.class);
            OraPackageCollectionType oraPackageCollectionType = (OraPackageCollectionType)obj2;
            Object object3 = indexTypeElement;
            if (object3 == null || (object3 = object3.getDasType()) == null || (object3 = DasTypeUtilsKt.remapAgainst((DasType)object3, obj2)) == null) {
                object3 = DasTypeSystemBase.UNKNOWN;
            }
            oraPackageCollectionType.setIndexElementStoredType((DasType)object3);
        }
    }

    private final void buildObjectType(OraObjectType obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        if (source instanceof SqlCreateTypeStatementImpl) {
            SqlReferenceExpression ref;
            SqlReferenceExpression sqlReferenceExpression = ref = ((SqlCreateTypeStatementImpl)source).getSuperTypeReference();
            obj2.setSuperObjectName(sqlReferenceExpression != null ? this.extractName((PsiElement)sqlReferenceExpression) : null);
            SqlExpression sqlExpression = ref;
            obj2.setSuperSchemaName(sqlExpression != null && (sqlExpression = sqlExpression.getQualifierExpression()) != null ? this.extractName((PsiElement)sqlExpression) : null);
        }
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildObjectType$lambda$15(this, source)));
    }

    private final void buildAliasType(OraAliasType obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        if (!context.isStubBuilder()) {
            SqlTypeElement innerTypeElement;
            SqlTypeDefinitionImpl sqlTypeDefinitionImpl = source instanceof SqlTypeDefinitionImpl ? (SqlTypeDefinitionImpl)source : null;
            SqlTypeElement sqlTypeElement = innerTypeElement = sqlTypeDefinitionImpl != null ? sqlTypeDefinitionImpl.getAliasedTypeElement() : null;
            if (innerTypeElement instanceof OraRecordTypeElementImpl) {
                Iterator iterator = ((Iterable)((OraRecordTypeElementImpl)innerTypeElement).getColumns()).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i2 = n++;
                    DasTypedObject sourceField = (DasTypedObject)iterator.next();
                    OraRecordColumn field = (OraRecordColumn)obj2.getRecordColumns().createOrGetAt((short)(i2 + 1));
                    Intrinsics.checkNotNull((Object)field);
                    BasicModElement basicModElement = field;
                    Intrinsics.checkNotNull((Object)sourceField);
                    this.build(basicModElement, sourceField, context);
                }
            }
        }
    }

    private final void buildPackage(OraPackage obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildPackage$lambda$17(this, source)));
    }

    private final void buildPackageBody(OraPackageBody obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildPackageBody$lambda$19(this, source)));
    }

    private final void buildObjectTypeBody(OraObjectTypeBody obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> OraObjectBuilder.buildObjectTypeBody$lambda$21(this, source)));
    }

    @Override
    protected void assignName(@NotNull BasicModNamedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isIntrospector()) {
            Casing casing = OraDialect.INSTANCE.getCasing(source.getKind(), source);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
            Casing casing2 = casing;
            obj2.setName(SqlImplUtil.getEffectiveName(source.getName(), DbSqlUtilCore.isQuoted(source), casing2));
        } else {
            super.assignName(obj2, source, context);
        }
    }

    private final void buildOraIndex(OraIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        OraIndex oraIndex;
        BasicElement basicElement;
        super.buildIndex(obj2, source, context);
        if (!(source instanceof SqlCreateIndexStatement)) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof OraIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof OraIndex)) {
                basicElement2 = null;
            }
            basicElement = (OraIndex)basicElement2;
        } else {
            basicElement = null;
        }
        if ((oraIndex = (OraIndex)basicElement) != null) {
            OraIndex $this$buildOraIndex_u24lambda_u2422 = oraIndex;
            boolean bl = false;
            obj2.setIndextypeRef($this$buildOraIndex_u24lambda_u2422.getIndextypeRef());
            return;
        }
        PsiElement indextypeRef = SqlImplUtil.getChildOfType((PsiElement)source, OraElementTypes.Extra.ORA_INDEXTYPE_REFERENCE);
        obj2.setIndextypeRef(indextypeRef != null ? SqlObjectBuilderImpl.extractNameRef$default(this, indextypeRef, false, 1, null) : null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final CompositeText buildTrigger$lambda$5(DasObject $source, OraObjectBuilder this$0) {
        SimpleCompositeText simpleCompositeText;
        SqlCreateTriggerStatement sqlCreateTriggerStatement;
        SqlCreateTriggerStatement sqlCreateTriggerStatement2 = sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        if (sqlCreateTriggerStatement != null) {
            String string;
            String string2;
            PsiElement psiElement;
            String string3;
            SqlCreateTriggerStatement ct;
            block5: {
                void this_$iv;
                ct = sqlCreateTriggerStatement;
                boolean bl = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this$0;
                PsiElement el$iv = ct;
                boolean $i$f$findChild = false;
                string3 = this_$iv;
                PsiElement element$iv$iv = el$iv.getFirstChild();
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof SqlStatement)) continue;
                    psiElement = tmp$iv$iv;
                    break block5;
                }
                psiElement = null;
            }
            SqlStatement sqlStatement = (SqlStatement)psiElement;
            if (sqlStatement != null) {
                SqlStatement it = sqlStatement;
                boolean bl = false;
                String string4 = ct.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                string3 = string4;
                int n = it.getStartOffsetInParent();
                String string5 = string3.substring(n);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string2 = null;
            }
            if ((string = string2) != null) {
                simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this$0, string, null, 1, null);
                return simpleCompositeText;
            }
        }
        simpleCompositeText = null;
        return simpleCompositeText;
    }

    private static final CompositeText buildMatView$lambda$6(OraObjectBuilder this$0, DasObject $source) {
        return this$0.getViewQuery($source, CompositeText.Kind.ORIGINAL_TEXT);
    }

    private static final boolean buildRoutineSources$lambda$9$lambda$7(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_FUNCTION)) || Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_PROCEDURE));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final CompositeText buildRoutineSources$lambda$9(OraObjectBuilder this$0, DasObject $source) {
        CharSequence charSequence;
        FileASTNode fileASTNode;
        SimpleCompositeText simpleCompositeText;
        Integer n = this$0.extractOraSourceStart($source, (Function1<? super IElementType, Boolean>)((Function1)OraObjectBuilder::buildRoutineSources$lambda$9$lambda$7));
        if (n == null) {
            simpleCompositeText = null;
            return simpleCompositeText;
        }
        int it = ((Number)n).intValue();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$source, (String)"null cannot be cast to non-null type com.intellij.database.model.PsiObject");
        PsiObject cfr_ignored_0 = (PsiObject)$source;
        TextRange rg = ((PsiObject)$source).getTextRange();
        PsiFile psiFile = ((PsiObject)$source).getContainingFile();
        if (psiFile != null && (fileASTNode = psiFile.getNode()) != null && (charSequence = fileASTNode.getChars()) != null) {
            CharSequence charSequence2 = charSequence;
            int n2 = rg.getStartOffset() + it;
            TextRange textRange = this$0.getRoutineBodyRange((PsiObject)$source);
            int n3 = RangesKt.coerceAtLeast((int)rg.getEndOffset(), (int)(textRange != null ? textRange.getEndOffset() : it));
            String string = ((Object)charSequence2.subSequence(n2, n3)).toString();
            if (string != null) {
                simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this$0, string, null, 1, null);
                return simpleCompositeText;
            }
        }
        simpleCompositeText = null;
        return simpleCompositeText;
    }

    private static final boolean buildObjectType$lambda$15$lambda$14(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_TYPE));
    }

    private static final CompositeText buildObjectType$lambda$15(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, (Function1<? super IElementType, Boolean>)((Function1)OraObjectBuilder::buildObjectType$lambda$15$lambda$14));
    }

    private static final boolean buildPackage$lambda$17$lambda$16(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_PACKAGE));
    }

    private static final CompositeText buildPackage$lambda$17(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, (Function1<? super IElementType, Boolean>)((Function1)OraObjectBuilder::buildPackage$lambda$17$lambda$16));
    }

    private static final boolean buildPackageBody$lambda$19$lambda$18(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_PACKAGE));
    }

    private static final CompositeText buildPackageBody$lambda$19(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, (Function1<? super IElementType, Boolean>)((Function1)OraObjectBuilder::buildPackageBody$lambda$19$lambda$18));
    }

    private static final boolean buildObjectTypeBody$lambda$21$lambda$20(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)((Object)SqlCommonKeywords.SQL_TYPE));
    }

    private static final CompositeText buildObjectTypeBody$lambda$21(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, (Function1<? super IElementType, Boolean>)((Function1)OraObjectBuilder::buildObjectTypeBody$lambda$21$lambda$20));
    }
}

