/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDmlHelper;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDmlHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBasePredicatesHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0014J,\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J.\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\"\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002JP\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u0007H\u0014J$\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u001c\u0010\"\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0012\u0010&\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\fH\u0014J$\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J&\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInOperator", "", "getSupportsInOperator", "()Z", "cannotCastToTextTypes", "", "", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "version", "Lcom/intellij/database/util/Version;", "alias", "compareOidAndRegprocedure", "parameterNeedsCastInWhereClause", "ftsPredicate", "columnRef", "supportsFts", "likePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "getDomain", "typeName", "shouldCastToText", "getInnerDomain", "Lcom/intellij/database/model/DasColumn;", "defType", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;", "registry", "Lcom/intellij/database/data/types/DomainRegistry;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "intellij.database.dialects.postgresgreenplumbase"})
@SourceDebugExtension(value={"SMAP\nPgGPlumBasePredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgGPlumBasePredicatesHelper.kt\ncom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,205:1\n1761#2,3:206\n1#3:209\n1069#4,2:210\n*S KotlinDebug\n*F\n+ 1 PgGPlumBasePredicatesHelper.kt\ncom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper\n*L\n109#1:206,3\n194#1:210,2\n*E\n"})
public class PgGPlumBasePredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<String> cannotCastToTextTypes;

    public PgGPlumBasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"abstime", "aclitem", "bit", "bool", "boolean", "box", "bytea", "cid", "circle", "line", "lseg", "money", "path", "point", "polygon", "refcursor", "regclass", "regoper", "regoperator", "regproc", "regprocedure", "regtype", "reltime", "smgr", "tid", "tinterval", "varbit", "bit varying", "xid", "xml"};
        this.cannotCastToTextTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        ComparePredicateOperation operator;
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        PredicatesHelper.PredicateProducer producer = this.compareOidAndRegprocedure(column2, value, op, alias);
        if (producer != null) {
            return producer;
        }
        Domain domain = this.getDomain(column2, value, version);
        ComparePredicateOperation comparePredicateOperation = operator = op instanceof EqualsPredicateOperation && domain != null && PgBaseJdbcHelper.isCustomOperatorType((String)domain.simpleName()) ? (ComparePredicateOperation)new EqualsPredicateOperation("~=") : op;
        if (value instanceof Placeholder && this.parameterNeedsCastInWhereClause(column2, value, version)) {
            return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PgGPlumBasePredicatesHelper.equalsPredicate$lambda$0(column2, value, quote, this, alias, operator, arg_0)));
        }
        return PredicatesUtilKt.defaultEqualsPredicate(column2, value, quote, this.getDbms(), alias, operator);
    }

    private final PredicatesHelper.PredicateProducer compareOidAndRegprocedure(ColumnRef column2, PredicateValue value, ComparePredicateOperation op, String alias) {
        if (Intrinsics.areEqual((Object)column2.getName(), (Object)"oid") && value instanceof StringPredicateValue && StringsKt.endsWith$default((String)((StringPredicateValue)value).getStr(), (String)")", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((StringPredicateValue)value).getStr(), (CharSequence)"(", (boolean)false, (int)2, null)) {
            return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PgGPlumBasePredicatesHelper.compareOidAndRegprocedure$lambda$1(alias, column2, op, value, this, arg_0)));
        }
        return null;
    }

    private final boolean parameterNeedsCastInWhereClause(ColumnRef column2, PredicateValue value, Version version) {
        BasicTableOrViewColumn dasColumn = PredicatesUtilKt.toBasicColumn(column2);
        if (dasColumn instanceof PgGPlumBaseLikeColumn && PgGPlumBaseDmlHelperKt.isNonBasicType((PgGPlumBaseLikeColumn)dasColumn)) {
            return true;
        }
        Domain domain = this.getDomain(column2, value, version);
        Domain domain2 = domain;
        return CollectionsKt.contains((Iterable)PgGPlumBaseDmlHelper.Companion.getNeedsCastWhenValueIsPassedAsParameterInInsertOrUpdate(), (Object)(domain2 != null ? domain2.simpleName() : null));
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        if (!this.supportsFts(columnRef, value, version)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, ContainsInIndexedTextOperation.INSTANCE, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PgGPlumBasePredicatesHelper.ftsPredicate$lambda$2(alias, columnRef, value, this, arg_0)));
    }

    private final boolean supportsFts(ColumnRef columnRef, PredicateValue value, Version version) {
        boolean bl;
        block9: {
            Domain domain;
            Domain domain2 = domain = this.getDomain(columnRef, value, version);
            if (!(domain2 != null ? domain2.supports(OperationKt.FULL_TEXT_SEARCH_OPERATION) : false)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)domain.name(), (Object)"tsvector")) {
                return true;
            }
            BasicTableOrViewColumn basicTableOrViewColumn = PredicatesUtilKt.toBasicColumn(columnRef);
            PgBaseLikeColumn pgBaseLikeColumn = basicTableOrViewColumn instanceof PgBaseLikeColumn ? (PgBaseLikeColumn)basicTableOrViewColumn : null;
            if (pgBaseLikeColumn == null) {
                return false;
            }
            PgBaseLikeColumn column2 = pgBaseLikeColumn;
            BasicLikeTable basicLikeTable = column2.getLikeTable();
            PgBaseLikeTable pgBaseLikeTable = basicLikeTable instanceof PgBaseLikeTable ? (PgBaseLikeTable)basicLikeTable : null;
            if (pgBaseLikeTable == null) {
                return false;
            }
            PgBaseLikeTable table = pgBaseLikeTable;
            Family family = table.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
            Iterable $this$any$iv = family;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    BasicModIndex i2 = (BasicModIndex)element$iv;
                    boolean bl3 = false;
                    if (i2.getColNames().size() != 1) {
                        bl2 = false;
                    } else {
                        String expression = StringUtil.trim((String)i2.getColNames().get(0));
                        Intrinsics.checkNotNull((Object)expression);
                        bl2 = StringsKt.startsWith$default((String)expression, (String)"to_tsvector(", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)expression, (String)(column2.getName() + "::text)"), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)expression, (String)("\"" + column2.getName() + "\"::text)"), (boolean)false, (int)2, null));
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        boolean canCast;
        Domain domain2;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        Domain domain3 = domain2 = this.getDomain(columnRef, value, version);
        boolean typeSupportsOperation = domain3 != null ? domain3.supports(OperationKt.LIKE_OPERATION) : false;
        boolean bl = canCast = canCastToText && domain2 != null && this.canCastToText(StringUtil.toLowerCase((String)domain2.simpleName()), version) && this.shouldCastToText(StringUtil.toLowerCase((String)domain2.simpleName())) && !domain2.supports(OperationKt.EQUALS_TO_NUMBER_OPERATION);
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        String string = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), this.getDbms(), version, inUpdate);
        if (string == null) {
            return null;
        }
        String likeWord = string;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> PgGPlumBasePredicatesHelper.likePredicate$lambda$4(alias, columnRef, typeSupportsOperation, likeWord, value, this, op, arg_0)));
    }

    @Override
    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                object = PredicatesUtilKt.toBasicColumn(columnRef);
                if (object == null) break block2;
                BasicTableOrViewColumn col = object;
                boolean bl = false;
                Domain domain = this.getInnerDomain(col, this.getDbms(), version);
                object = domain;
                if (domain != null) break block3;
            }
            object = super.getDomain(columnRef, value, version);
        }
        return object;
    }

    protected boolean canCastToText(@Nullable String typeName, @Nullable Version version) {
        return typeName != null && !this.cannotCastToTextTypes.contains(typeName);
    }

    protected boolean shouldCastToText(@Nullable String typeName) {
        return true;
    }

    private final Domain getInnerDomain(DasColumn column2, Dbms dbms, Version version) {
        if (!(column2 instanceof PgGPlumBaseTableColumn)) {
            return null;
        }
        DomainRegistry domainRegistry = BaseDomainRegistry.get(dbms, version);
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
        DomainRegistry registry = domainRegistry;
        PgGPlumBaseDefType defType = ((PgGPlumBaseTableColumn)column2).getType();
        if (defType != null) {
            return this.getInnerDomain(defType, registry);
        }
        DasType dasType = ((PgGPlumBaseTableColumn)column2).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        String typeName = DasTypeUtilsKt.getTypeName(dasType);
        return registry.getDomain(new TypeNameColumnDescriptor(typeName));
    }

    private final Domain getInnerDomain(PgGPlumBaseDefType defType, DomainRegistry registry) {
        Domain domain = registry.getDomain(new TypeNameColumnDescriptor(defType.getName()));
        if (domain != null) {
            return domain;
        }
        PgGPlumBaseDefType innerDefType = defType.getBaseType();
        if (innerDefType != null) {
            return this.getInnerDomain(innerDefType, registry);
        }
        String definition = defType.getDefinition();
        return definition == null || Intrinsics.areEqual((Object)definition, (Object)"-") ? null : registry.getDomain(new TypeNameColumnDescriptor(definition));
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        FormatTester formatTester;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        if (domain == null) {
            PgGPlumBaseDefType pgGPlumBaseDefType;
            PgDataTypeSubKind[] pgDataTypeSubKindArray = PredicatesUtilKt.toBasicColumn(columnRef);
            PgGPlumBaseTableColumn pgGPlumBaseTableColumn = pgDataTypeSubKindArray instanceof PgGPlumBaseTableColumn ? (PgGPlumBaseTableColumn)pgDataTypeSubKindArray : null;
            PgGPlumBaseDefType defType = pgGPlumBaseTableColumn != null ? pgGPlumBaseTableColumn.getType() : null;
            pgDataTypeSubKindArray = new PgDataTypeSubKind[]{PgDataTypeSubKind.ENUM};
            PgGPlumBaseDefType pgGPlumBaseDefType2 = pgGPlumBaseDefType = PgGPlumBasePredicatesHelperKt.findType(defType, pgDataTypeSubKindArray);
            formatTester = pgGPlumBaseDefType2 == null ? null : PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)arg_0 -> PgGPlumBasePredicatesHelper.getFormatTester$lambda$6(pgGPlumBaseDefType2, arg_0)));
        } else if (Intrinsics.areEqual((Object)domain.simpleName(), (Object)"bytea")) {
            formatTester = new FormatTester(true, false, PgGPlumBasePredicatesHelper::getFormatTester$lambda$7, 2, null);
        } else {
            String it = domain.simpleName();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it, (Object)"oid") || Intrinsics.areEqual((Object)it, (Object)"xid") || Intrinsics.areEqual((Object)it, (Object)"cid");
            if (bl2) {
                formatTester = PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)PgGPlumBasePredicatesHelper::getFormatTester$lambda$10));
            } else {
                Dbms dbms = this.getDbms();
                LogicalType logicalType = domain.getLogicType();
                Intrinsics.checkNotNullExpressionValue((Object)logicalType, (String)"getLogicType(...)");
                formatTester = PredicatesUtilKt.getFormatTester(columnRef, dbms, logicalType);
            }
        }
        return formatTester;
    }

    private static final Unit equalsPredicate$lambda$0(ColumnRef $column, PredicateValue $value, boolean $quote, PgGPlumBasePredicatesHelper this$0, String $alias, ComparePredicateOperation $operator, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.defaultEqualsPredicate($column, $value, $quote, this$0.getDbms(), $alias, $operator).getProduce().invoke((Object)builder);
        DasColumn dasColumn = PredicatesUtilKt.toDasColumn($column);
        if (dasColumn != null) {
            builder.symbol("::").type(dasColumn.getDasType().toDataType());
        }
        return Unit.INSTANCE;
    }

    private static final Unit compareOidAndRegprocedure$lambda$1(String $alias, ColumnRef $column, ComparePredicateOperation $op, PredicateValue $value, PgGPlumBasePredicatesHelper this$0, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = PredicatesUtilKt.identifier(builder, $alias, $column).plain("::").type("regprocedure").plain("::").type("text").space().symbol($op.getOperator()).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        PredicatesUtilKt.value(ddlBuilder, $value, $column, this$0.getDbms(), DbImplUtilCore.StringLiteralDecorator.PLAIN);
        return Unit.INSTANCE;
    }

    private static final Unit ftsPredicate$lambda$2(String $alias, ColumnRef $columnRef, PredicateValue $value, PgGPlumBasePredicatesHelper this$0, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = PredicatesUtilKt.identifier(builder, $alias, $columnRef).space().symbol("@@").space().plain("plainto_tsquery(");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        PredicatesUtilKt.value(ddlBuilder, $value, $columnRef, this$0.getDbms(), DbImplUtilCore.StringLiteralDecorator.PLAIN).plain(")");
        return Unit.INSTANCE;
    }

    private static final Unit likePredicate$lambda$4(String $alias, ColumnRef $columnRef, boolean $typeSupportsOperation, String $likeWord, PredicateValue $value, PgGPlumBasePredicatesHelper this$0, LikePredicateOperation $op, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.identifier(builder, $alias, $columnRef);
        if (!$typeSupportsOperation) {
            builder.symbol("::").type("text");
        }
        DdlBuilder ddlBuilder = builder.space().keyword($likeWord).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        PredicatesUtilKt.value(ddlBuilder, $value, $columnRef, this$0.getDbms(), $op.getLikeType().getDecorator());
        return Unit.INSTANCE;
    }

    private static final boolean getFormatTester$lambda$6(PgGPlumBaseDefType $enum, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $enum.getLabels().contains(it);
    }

    private static final FormatTestResult getFormatTester$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith((String)it, (String)"e'", (boolean)true) ? FormatTestResult.NOT_QUOTE : FormatTestResult.QUOTE;
    }

    private static final boolean getFormatTester$lambda$10(String value) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }
}

