/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class DataTypeFactory {
    private static final Pattern INNER_PATTERN = Pattern.compile("^\\s*(\\d+|\\*|max)\\s*(,\\s*(-?\\d+))?\\s*(chars?|bytes?|digits?|octets?|codeunits16?|codeunits32?)?\\s*$", 2);
    private static final ConcurrentMap<DataType, DataType> ourInterner = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    private static final Set<String> ENUMS_SETS = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("enum", "enum8", "enum16", "set"));

    @NotNull
    public static DataType of(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(0);
        }
        return DataTypeFactory.of(specification, 0, false, false, null, false);
    }

    @NotNull
    public static DataType withTypeName(@NotNull DataType type, @NotNull String typeName) {
        if (type == null) {
            DataTypeFactory.$$$reportNull$$$0(1);
        }
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(2);
        }
        return DataTypeFactory.of(type.schemaName, type.packageName, typeName, type.size, type.scale, type.sizeUnit, type.suffix, type.sizeUnitExplicit, type.custom, type.jdbcType);
    }

    @NotNull
    public static DataType withSuffix(@NotNull DataType type, @Nullable String suffix) {
        if (type == null) {
            DataTypeFactory.$$$reportNull$$$0(3);
        }
        if (Objects.equals(type.suffix, suffix)) {
            DataType dataType = type;
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(4);
            }
            return dataType;
        }
        return DataTypeFactory.of(type.schemaName, type.packageName, type.typeName, type.size, type.scale, type.sizeUnit, suffix, type.sizeUnitExplicit, type.vagueArg, type.enumValues, type.custom, type.jdbcType);
    }

    @NotNull
    public static DataType dropSuffix(@NotNull DataType type) {
        if (type == null) {
            DataTypeFactory.$$$reportNull$$$0(5);
        }
        return DataTypeFactory.withSuffix(type, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static DataType of(@NotNull String specification, int jdbcType, boolean custom, boolean hasPackage, @Nullable Variant v, boolean explicitUnits) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(6);
        }
        Trio trio = DataTypeFactory.smartSplit(specification);
        if (trio.inner != null) {
            boolean isCustom;
            boolean ok;
            if (v == null && ENUMS_SETS.contains(trio.primary) || v == Variant.ENUM) {
                return DataTypeFactory.createEnumOrRet(trio, custom, hasPackage, jdbcType);
            }
            TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
            Matcher m = v == Variant.VAGUE ? null : INNER_PATTERN.matcher(trio.inner);
            boolean bl = ok = m != null && m.matches();
            boolean bl2 = v == null ? packAndName.schemaName != null : (isCustom = custom);
            if (ok) {
                LengthUnit unit;
                String sizeStr = m.group(1);
                int size = sizeStr.equals("*") ? 0x7FFFFFFE : (sizeStr.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.parseInt(sizeStr));
                int scale = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                LengthUnit lengthUnit = unit = m.group(4) != null ? LengthUnit.of(m.group(4)) : null;
                if (v == null && unit == null && scale != 0) {
                    unit = LengthUnit.DIGIT;
                }
                if (v == null) {
                    explicitUnits = m.group(4) != null;
                }
                return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, size, scale, unit, trio.suffix, explicitUnits, isCustom, jdbcType);
            }
            if (!trio.inner.isEmpty()) {
                return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, null, trio.suffix, false, trio.inner, null, custom, jdbcType);
            }
            return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, null, trio.suffix, false, isCustom, jdbcType);
        }
        TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
        return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, LengthUnit.NONE, trio.suffix, explicitUnits, v == null ? packAndName.schemaName != null : custom, jdbcType);
    }

    @Contract(pure=true)
    private static Trio smartSplit(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(7);
        }
        if (StringUtil.startsWithIgnoreCase((String)specification, (String)"setof ")) {
            Trio res = new Trio();
            res.primary = "setof";
            res.suffix = StringUtil.trim((String)specification.substring("setof ".length()));
            return res;
        }
        int n = specification.length();
        int p1 = Integer.MIN_VALUE;
        int p2 = Integer.MIN_VALUE;
        Stack stack = new Stack();
        block5: for (int i2 = 0; i2 < n; ++i2) {
            char x;
            char c2 = specification.charAt(i2);
            char c3 = x = stack.isEmpty() ? (char)'\u0000' : ((Character)stack.peek()).charValue();
            if (c2 == '(' && p1 < 0 && stack.isEmpty()) {
                p1 = i2;
            }
            if (c2 == ')' && p1 >= 0 && p2 < 0 && stack.size() == 1 && x == ')') {
                p2 = i2;
            }
            if (c2 == x) {
                stack.pop();
                if (!stack.isEmpty() || p2 <= 0) continue;
                break;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    stack.push((Object)Character.valueOf(c2));
                    continue block5;
                }
                case '[': {
                    stack.push((Object)Character.valueOf(']'));
                    continue block5;
                }
                case '(': {
                    stack.push((Object)Character.valueOf(')'));
                }
            }
        }
        Trio trio = new Trio();
        if (p2 > 0) {
            assert (p1 >= 0);
            trio.primary = specification.substring(0, p1).trim();
            trio.inner = specification.substring(p1 + 1, p2).trim();
            trio.suffix = specification.substring(p2 + 1).trim();
            if (trio.suffix.isEmpty()) {
                trio.suffix = null;
            }
        } else {
            trio.primary = specification.trim();
        }
        return trio;
    }

    @NotNull
    private static DataType createEnumOrRet(@NotNull Trio trio, boolean custom, boolean hasPackage, int jdbcType) {
        if (trio == null) {
            DataTypeFactory.$$$reportNull$$$0(8);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String s : StringUtil.split((String)trio.inner, (String)",")) {
            res.add(StringUtil.trim((String)s));
        }
        TypeAsParts couple = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
        return DataTypeFactory.of(couple.schemaName, couple.packageName, couple.typeName, -1, 0, null, trio.suffix, false, null, List.copyOf(res), custom, jdbcType);
    }

    @NotNull
    public static DataType ofArgs(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(9);
        }
        return DataTypeFactory.ofArgs(schemaName, null, typeName, vagueArg, custom, 0);
    }

    @NotNull
    private static DataType ofArgs(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(10);
        }
        DataType type = new DataType(schemaName, packageName, typeName, vagueArg, custom, jdbcType);
        return DataTypeFactory.intern(type);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(11);
        }
        return DataTypeFactory.of(schemaName, null, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, jdbcType);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, @Nullable String vagueArg, @Nullable @Unmodifiable List<String> enumValues, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(12);
        }
        return DataTypeFactory.intern(new DataType(schemaName, packageName, typeName, size, scale, sizeUnit, sizeUnitExplicit, vagueArg, enumValues, suffix, custom, jdbcType));
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(13);
        }
        return DataTypeFactory.of(schemaName, packageName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, null, null, custom, jdbcType);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(14);
        }
        return DataTypeFactory.of(schemaName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(15);
        }
        return DataTypeFactory.of(schemaName, packageName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
    }

    @NotNull
    public static DataType ofValues(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @NotNull List<String> values, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(16);
        }
        if (values == null) {
            DataTypeFactory.$$$reportNull$$$0(17);
        }
        DataType type = new DataType(schemaName, packageName, typeName, custom, values, 0);
        return DataTypeFactory.intern(type);
    }

    @NotNull
    private static TypeAsParts splitPackAndName(@NotNull String string, boolean hasPackage) {
        int typeNameStartOffset;
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(18);
        }
        if ((typeNameStartOffset = string.lastIndexOf(46)) < 0) {
            return new TypeAsParts(null, null, string.trim());
        }
        String qualifier = string.substring(0, typeNameStartOffset);
        String typeName = string.substring(typeNameStartOffset + 1).trim();
        if (!hasPackage) {
            return new TypeAsParts(qualifier, null, typeName);
        }
        int packageStartOffset = qualifier.lastIndexOf(46);
        if (packageStartOffset < 0) {
            return new TypeAsParts(null, qualifier, typeName);
        }
        String schemaName = qualifier.substring(0, packageStartOffset);
        String packageName = qualifier.substring(packageStartOffset + 1);
        return new TypeAsParts(schemaName, packageName, typeName);
    }

    @NotNull
    private static DataType intern(@NotNull DataType dataType) {
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(19);
        }
        DataType dataType2 = (DataType)ConcurrencyUtil.cacheOrGet(ourInterner, (Object)dataType, (Object)dataType);
        if (dataType2 == null) {
            DataTypeFactory.$$$reportNull$$$0(20);
        }
        return dataType2;
    }

    @NotNull
    public static String serialize(@NotNull DataType value) {
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(21);
        }
        StringBuilder res = new StringBuilder();
        res.append(value.getSpecification(true, false)).append("|").append(value.jdbcType);
        if (value.sizeUnitExplicit) {
            res.append("u");
        }
        if (value.custom) {
            res.append("c");
        }
        if (value.packageName != null) {
            res.append("p");
        }
        res.append(Variant.of((DataType)value).code);
        String string = res.toString();
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static DataType deserialize(@NotNull String value) {
        int idx;
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(23);
        }
        if ((idx = value.lastIndexOf("|")) != -1) {
            try {
                boolean explicitUnit;
                boolean custom;
                boolean hasPackage;
                int e = value.length();
                Variant v = Variant.of(value.charAt(e - 1));
                if (v != null) {
                    --e;
                }
                boolean bl = hasPackage = value.charAt(e - 1) == 'p';
                if (hasPackage) {
                    --e;
                }
                boolean bl2 = custom = value.charAt(e - 1) == 'c';
                if (custom) {
                    --e;
                }
                boolean bl3 = explicitUnit = value.charAt(e - 1) == 'u';
                if (explicitUnit) {
                    --e;
                }
                return DataTypeFactory.of(value.substring(0, idx), Integer.parseInt(value.substring(idx + 1, e)), custom, hasPackage, v, explicitUnit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DataTypeFactory.of(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specification";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trio";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withSuffix";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withSuffix";
                break;
            }
            case 4: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dropSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "smartSplit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEnumOrRet";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ofArgs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ofValues";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "splitPackAndName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 20, 22 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum Variant {
        SIZED('s'),
        VAGUE('v'),
        ENUM('e');

        private final char code;

        private Variant(char c2) {
            this.code = c2;
        }

        @Nullable
        static Variant of(char c2) {
            for (Variant v : Variant.values()) {
                if (v.code != c2) continue;
                return v;
            }
            return null;
        }

        @NotNull
        static Variant of(@NotNull DataType dt) {
            if (dt == null) {
                Variant.$$$reportNull$$$0(0);
            }
            if (dt.vagueArg != null) {
                Variant variant = VAGUE;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(1);
                }
                return variant;
            }
            if (dt.enumValues != null) {
                Variant variant = ENUM;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(2);
                }
                return variant;
            }
            Variant variant = SIZED;
            if (variant == null) {
                Variant.$$$reportNull$$$0(3);
            }
            return variant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dt";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Trio {
        String primary;
        String inner;
        String suffix;

        private Trio() {
        }
    }

    private static final class TypeAsParts {
        final String schemaName;
        final String packageName;
        final String typeName;

        TypeAsParts(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName) {
            if (typeName == null) {
                TypeAsParts.$$$reportNull$$$0(0);
            }
            this.schemaName = schemaName;
            this.packageName = packageName;
            this.typeName = typeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/properties/DataTypeFactory$TypeAsParts", "<init>"));
        }
    }
}

