/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.Dbms;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcMigrationUtils {
    private DbSrcMigrationUtils() {
    }

    @Nullable
    public static CompositeText getOrCreateCompactDefinition(@NotNull Project project, @NotNull Dbms dbms, @NotNull BasicSourceAware e) {
        CompositeText text2;
        if (project == null) {
            DbSrcMigrationUtils.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            DbSrcMigrationUtils.$$$reportNull$$$0(1);
        }
        if (e == null) {
            DbSrcMigrationUtils.$$$reportNull$$$0(2);
        }
        if ((text2 = e.getSourceText()) == null) {
            return null;
        }
        CompositeText.Fragment cf = (CompositeText.Fragment)ContainerUtil.find(text2.getFragments(), f -> f.getKind() == CompositeText.Kind.COMPACT_DEFINITION);
        if (cf != null) {
            return new SimpleCompositeText(cf.getText(), cf.getKind());
        }
        BasicModel model = e.getModel();
        if (model == null) {
            return null;
        }
        TextRange rg = DbSrcMigrationUtils.findCompactDefinitionRange(project, dbms, ObjectPaths.of(e), text2, (Function<CompositeText, CompositeText>)((Function)t -> {
            ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
            task.getElements().add(e);
            task.setOptions(new CustomScriptingOptions(Map.of(ScriptingOptionStatic.IGNORE_COMPACT, true, ScriptingOptionStatic.USE_COMPACT_DEFINITION, false)));
            return ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).makeScript(project, task.build()).getScript();
        }));
        return rg == null ? null : new SimpleCompositeText(rg.subSequence(text2.getText()), CompositeText.Kind.COMPACT_DEFINITION);
    }

    @Nullable
    public static TextRange findCompactDefinitionRange(@NotNull Project project, Dbms dbms, ObjectPath path, CompositeText sql, Function<CompositeText, CompositeText> makeParsable) {
        if (project == null) {
            DbSrcMigrationUtils.$$$reportNull$$$0(3);
        }
        TextRange rg = null;
        if (!ContainerUtil.exists(sql.getFragments(), f -> f.getKind() == CompositeText.Kind.COMPACT_DEFINITION)) {
            TextRange content;
            SqlObjectBuilder builder = SqlObjectBuilder.EP.forDbms(dbms);
            rg = builder.getCompactDefinition(path, sql, null);
            if (rg == null) {
                TextRange r = sql.getContentRange();
                if (r == null) {
                    return null;
                }
                PsiObject object = null;
                int offset = 0;
                CompositeText parsable = sql;
                try {
                    parsable = (CompositeText)makeParsable.fun((Object)sql);
                    if (parsable != sql) {
                        TextRange pr = parsable.getContentRange();
                        if (pr == null) {
                            parsable = sql;
                        } else {
                            offset = r.getStartOffset() - pr.getStartOffset();
                        }
                    }
                    SqlFile file = SqlPsiFacade.getInstance(project).createROFile(DbSqlUtilCore.getSqlDialect(dbms), parsable.getText());
                    object = (PsiObject)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots(file.getDdl())).expandAndSkip(o -> o instanceof SqlAlterStatement)).filter(PsiObject.class).first();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (object != null && (rg = builder.getCompactDefinition(path, parsable, object)) != null) {
                    rg = rg.shiftRight(offset);
                }
            }
            if (rg != null && (content = sql.getContentRange()) != null) {
                rg = rg.intersection(content);
            }
        }
        return rg == null || rg.isEmpty() ? null : rg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/script/DbSrcMigrationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateCompactDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCompactDefinitionRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

