/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final BidirectionalMap<String, Integer> SPECIAL_VALUES = new BidirectionalMap();
    private final int @NotNull [] myElements;
    public static final Version ZERO;
    public static final Version INFINITY;
    public static final Version NEG_INFINITY;

    @Contract(value="!null->!null;null->null")
    public static Version of(@Nullable String string) {
        String[] elements;
        if (string == null) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(5);
        for (String element : elements = string.split("[.,\\-_ ]|(?<=\\d)(?!\\d)|(?<!\\d)(?=\\d)")) {
            String e = StringUtil.toLowerCase((String)element.trim());
            if (e.isEmpty()) continue;
            Integer value = (Integer)SPECIAL_VALUES.get((Object)e);
            if (value == null) {
                try {
                    value = Integer.parseInt(e);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Failed to parse version \"" + string + "\"", nfe);
                }
            }
            res.add(value);
        }
        if (res.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse version \"" + string + "\"");
        }
        if (string.endsWith("-")) {
            res.add(Integer.MIN_VALUE);
        }
        return new Version(ArrayUtil.toIntArray(res));
    }

    @Nullable
    public static Version parse(@Nullable String string) {
        try {
            return string == null ? null : Version.of(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Version of(int ... elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(0);
        }
        return new Version(elements);
    }

    private Version(int @NotNull [] elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(1);
        }
        this.myElements = elements;
    }

    public int get(int index) {
        return index < this.myElements.length ? this.myElements[index] : 0;
    }

    public int size() {
        return this.myElements.length;
    }

    public boolean eqCoarse(int ... elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(2);
        }
        return this.truncate(elements.length).compareTo(elements) == 0;
    }

    public boolean eqCoarse(@NotNull Version v) {
        if (v == null) {
            Version.$$$reportNull$$$0(3);
        }
        return this.eqCoarse(v.myElements);
    }

    @NotNull
    public Version truncate(int n) {
        if (this.myElements.length <= n) {
            Version version = this;
            if (version == null) {
                Version.$$$reportNull$$$0(4);
            }
            return version;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative desired size: " + n);
        }
        int[] newElements = Arrays.copyOf(this.myElements, n);
        return new Version(newElements);
    }

    @NotNull
    public Version truncateNegatives() {
        int n = this.myElements.length;
        for (int k = 0; k < n; ++k) {
            if (this.myElements[k] >= 0) continue;
            Version version = this.truncate(k);
            if (version == null) {
                Version.$$$reportNull$$$0(5);
            }
            return version;
        }
        Version version = this;
        if (version == null) {
            Version.$$$reportNull$$$0(6);
        }
        return version;
    }

    @NotNull
    public Version decStep() {
        int len = this.myElements.length;
        int[] newElements = new int[len + 1];
        System.arraycopy(this.myElements, 0, newElements, 0, len);
        newElements[len] = Integer.MIN_VALUE;
        Version version = Version.of(newElements);
        if (version == null) {
            Version.$$$reportNull$$$0(7);
        }
        return version;
    }

    @NotNull
    public Version incStep() {
        int len = this.myElements.length;
        int[] newElements = new int[len + 4];
        System.arraycopy(this.myElements, 0, newElements, 0, len);
        newElements[len] = 0;
        newElements[len + 1] = 0;
        newElements[len + 2] = 0;
        newElements[len + 3] = 1;
        Version version = Version.of(newElements);
        if (version == null) {
            Version.$$$reportNull$$$0(8);
        }
        return version;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        if (that == null) {
            Version.$$$reportNull$$$0(9);
        }
        if (this == that) {
            return 0;
        }
        return this.compareTo(that.myElements);
    }

    @Override
    public int compareTo(int ... that) {
        int res = 0;
        int tLen = that.length;
        int e = Math.max(this.size(), tLen);
        for (int i2 = 0; i2 < e && res == 0; ++i2) {
            res = Integer.compare(this.get(i2), i2 >= tLen ? 0 : that[i2]);
        }
        return res;
    }

    public boolean isOrGreater(int ... than) {
        return this.compareTo(than) >= 0;
    }

    public boolean isOrGreater(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(10);
        }
        return this.compareTo(than) >= 0;
    }

    public boolean less(int ... than) {
        return this.compareTo(than) < 0;
    }

    public boolean isOrLess(int ... than) {
        return this.compareTo(than) <= 0;
    }

    public boolean less(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(11);
        }
        return this.compareTo(than) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version ov = (Version)o;
        int e = Math.max(this.size(), ov.size());
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.get(i2) == ov.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (int i2 = this.myElements.length - 1; i2 >= 0; --i2) {
            hc = this.myElements[i2] + 31 * hc;
        }
        return hc;
    }

    @NotNull
    public String toString() {
        if (this == INFINITY) {
            return "\u221e";
        }
        String string = this.toString(2, 100);
        if (string == null) {
            Version.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String toString(int from, int to) {
        boolean dec;
        int n = MathUtil.clamp((int)this.myElements.length, (int)from, (int)to);
        boolean bl = dec = n > 1 && this.get(n - 1) == Integer.MIN_VALUE;
        if (dec) {
            --n;
        }
        StringBuilder b = new StringBuilder();
        int delimiter = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            int item = this.get(i2);
            String special = (String)ContainerUtil.getFirstItem((List)SPECIAL_VALUES.getKeysByValue((Object)item));
            if (delimiter != 0) {
                b.append((char)(special != null ? 32 : delimiter));
            }
            if (special != null) {
                b.append(special);
                delimiter = 32;
                continue;
            }
            b.append(item);
            delimiter = 46;
        }
        if (dec) {
            b.append("-");
        }
        String string = b.toString();
        if (string == null) {
            Version.$$$reportNull$$$0(13);
        }
        return string;
    }

    static {
        SPECIAL_VALUES.put((Object)"devel", (Object)-40);
        SPECIAL_VALUES.put((Object)"alpha", (Object)-30);
        SPECIAL_VALUES.put((Object)"a", (Object)-30);
        SPECIAL_VALUES.put((Object)"beta", (Object)-20);
        SPECIAL_VALUES.put((Object)"b", (Object)-20);
        SPECIAL_VALUES.put((Object)"rc", (Object)-10);
        ZERO = Version.of(0);
        INFINITY = Version.of(Integer.MAX_VALUE);
        NEG_INFINITY = Version.of(Integer.MIN_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/Version";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "than";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/Version";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "truncate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateNegatives";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "decStep";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "incStep";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eqCoarse";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOrGreater";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "less";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 12, 13 -> new IllegalStateException(string);
        };
    }
}

