/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.mysql.MysqlDialectBase;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLockTableStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlDialect
extends MysqlDialectBase {
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    private MysqlDialect() {
        super("MySQL");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(MysqlTokens.class);
        if (tokensHelper == null) {
            MysqlDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MYSQL;
        if (dbms == null) {
            MysqlDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        if (name2 == null) {
            MysqlDialect.$$$reportNull$$$0(2);
        }
        if (name2.equals("MYSQL_JSON_COLUMNS_CLAUSE")) {
            return MysqlTypes.MYSQL_JSON_COLUMNS_CLAUSE;
        }
        return super.getFunctionParserExtension(name2);
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(3);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlLockTableStatement.class}) != null;
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier identifier, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkLeadingDollars(identifier, manager, onTheFly);
        return result2 != null ? result2 : super.checkIdentifierText(identifier, manager, onTheFly);
    }

    @Nullable
    private ProblemDescriptor checkLeadingDollars(@NotNull SqlIdentifier identifier, InspectionManager manager, boolean onTheFly) {
        PsiFile psiFile;
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(4);
        }
        if (!((psiFile = identifier.getContainingFile()) instanceof SqlFile)) {
            return null;
        }
        SqlFile sqlFile = (SqlFile)psiFile;
        Version maxVersion = (Version)SqlImplUtil.getDbVersions(sqlFile).sort(Version::compareTo).last();
        if (maxVersion == null) {
            return null;
        }
        if (maxVersion.less(8, 0, 32)) {
            return null;
        }
        if (!MysqlDialect.shouldLookForDollars(identifier)) {
            return null;
        }
        String text2 = identifier.getText();
        boolean startsWithDollar = !text2.isEmpty() && text2.charAt(0) == '$';
        boolean hasMoreDollars = startsWithDollar && text2.indexOf(36, 1) > 0;
        ProblemHighlightType type = MysqlDialect.getHighlightType(maxVersion, hasMoreDollars, startsWithDollar);
        return this.makeProblemDescriptor(type, identifier, manager, onTheFly);
    }

    private static boolean shouldLookForDollars(@NotNull SqlIdentifier o) {
        PsiElement parent;
        if (o == null) {
            MysqlDialect.$$$reportNull$$$0(5);
        }
        if (PsiUtilCore.getElementType((PsiElement)(parent = o.getParent())) == SqlCompositeElementTypes.SQL_AS_EXPRESSION) {
            return true;
        }
        if (parent instanceof SqlReferenceExpression) {
            SqlReferenceExpression expr = (SqlReferenceExpression)parent;
            SqlReference ref = expr.getReference();
            ObjectKind kind = ref.getReferenceElementType().getTargetKind();
            return kind == ObjectKind.SCHEMA || kind == ObjectKind.TABLE || kind == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.COLUMN;
        }
        return false;
    }

    @Nullable
    private static ProblemHighlightType getHighlightType(@NotNull Version maxVersion, boolean hasMoreDollars, boolean startsWithDollar) {
        if (maxVersion == null) {
            MysqlDialect.$$$reportNull$$$0(6);
        }
        if (maxVersion.isOrGreater(8, 1)) {
            return hasMoreDollars ? ProblemHighlightType.ERROR : (startsWithDollar ? ProblemHighlightType.WEAK_WARNING : null);
        }
        if (maxVersion.isOrGreater(8, 0, 32)) {
            return startsWithDollar ? ProblemHighlightType.WEAK_WARNING : null;
        }
        return null;
    }

    @Nullable
    private ProblemDescriptor makeProblemDescriptor(@Nullable ProblemHighlightType highlightType, @NotNull SqlIdentifier identifier, @NotNull InspectionManager manager, boolean onTheFly) {
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            MysqlDialect.$$$reportNull$$$0(8);
        }
        if (highlightType == null) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)identifier, SqlBundle.message("identifier.begins.with.dollar.should.be.quoted", identifier.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), highlightType, onTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxVersion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkLeadingDollars";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldLookForDollars";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeProblemDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

