/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTableParenthesizedColumnsSection;
import com.intellij.sql.formatter.model.StartUntilPattern;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "<init>", "()V", "whetherToFlatten", "", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "userRequiresExpand", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "Companion", "TableHeaderSection", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCreateTableBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCreateTableBlock.kt\ncom/intellij/sql/formatter/model/SqlCreateTableBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n1#1,125:1\n945#2,2:126\n1#3:128\n1#3:130\n456#4:129\n*S KotlinDebug\n*F\n+ 1 SqlCreateTableBlock.kt\ncom/intellij/sql/formatter/model/SqlCreateTableBlock\n*L\n44#1:126,2\n58#1:130\n58#1:129\n*E\n"})
public final class SqlCreateTableBlock
extends SqlDdlStatementBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<FlowPattern> patterns;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getElementType() == SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE) return true;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST))) return true;
        SqlFormattingContext sqlFormattingContext = this.getContext();
        Dbms dbms = Dbms.SQLITE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SQLITE");
        if (!sqlFormattingContext.isDialect(dbms)) return false;
        if (node.getElementType() == SqlCompositeElementTypes.SQL_CLAUSE) return true;
        if (!Intrinsics.areEqual((Object)node.getElementType().toString(), (Object)"SQL_MODULE_REFERENCE")) return false;
        return true;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getElementType().toString();
        return switch (string.hashCode()) {
            case 200314079 -> {
                if (string.equals("PG_INHERITS_TABLE_CLAUSE")) {
                    void parent$iv;
                    void $this$withSetup$iv;
                    SqlRangeBlock var3_3 = new SqlPostfixClauseBlock();
                    SqlBlock var4_4 = this;
                    ASTNode outerNode$iv = node;
                    boolean $i$f$withSetup = false;
                    TextRange v0 = outerNode$iv.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTextRange(...)");
                    $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, v0, SqlFormattingModelFun.listChildren(outerNode$iv));
                    yield var3_3;
                }
            }
            default -> super.makeBlock(node);
        };
    }

    @Override
    protected void configureFormattingAttributes() {
        Object v7;
        Object object;
        Object it2;
        Object object2;
        Wrap w;
        block23: {
            SqlBlock asWord;
            Iterator iterator;
            Object object3;
            block22: {
                Iterable $this$find$iv;
                Object v0;
                Indent i2;
                int openingSetting;
                block20: {
                    openingSetting = this.getContext().getSql().TABLE_OPENING;
                    w = SqlFlowBlock.makeWrap$default(this, this.getContext().getSql().TABLE_COLLAPSE ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS, false, 2, null);
                    i2 = openingSetting == 4 ? Indent.getNormalIndent((boolean)true) : SqlFormattingFunKt.getNONE_INDENT();
                    object3 = this.getNestedBlocks();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        Object t = object2.next();
                        it2 = (SqlBlock)t;
                        boolean bl = false;
                        if (!(it2 instanceof SqlTableParenthesizedColumnsSection)) continue;
                        v0 = t;
                        break block20;
                    }
                    v0 = null;
                }
                SqlBlock columnSection = v0;
                if (columnSection != null) {
                    if (this.getContext().getSql().TABLE_OPENING == 3) {
                        Object v3;
                        Object v2;
                        Alignment sectionAlignment;
                        block21: {
                            sectionAlignment = SqlFormattingModelFun.makeLeftAlignment();
                            SqlBlock sqlBlock = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
                            if (sqlBlock != null) {
                                sqlBlock.setMyAlign(sectionAlignment);
                            }
                            $this$find$iv = this.getNestedBlocks();
                            boolean $i$f$find = false;
                            it2 = $this$find$iv;
                            Iterator bl = it2.iterator();
                            while (bl.hasNext()) {
                                Object t = bl.next();
                                Block it$iv = (Block)t;
                                boolean bl2 = false;
                                if (!(it$iv instanceof SqlTableParenthesizedColumnsSection)) continue;
                                v2 = t;
                                break block21;
                            }
                            v2 = v3 = null;
                        }
                        if (!(v2 instanceof SqlTableParenthesizedColumnsSection)) {
                            v3 = null;
                        }
                        SqlTableParenthesizedColumnsSection sqlTableParenthesizedColumnsSection = (SqlTableParenthesizedColumnsSection)((Block)v3);
                        if (sqlTableParenthesizedColumnsSection != null) {
                            sqlTableParenthesizedColumnsSection.setSectionAlignment(sectionAlignment);
                        }
                    }
                    columnSection.setMyIndent(i2);
                    columnSection.setMyWrap((Wrap)(openingSetting > 1 ? w : null));
                }
                $this$find$iv = this.getNestedBlocks();
                for (Object it2 : $this$find$iv) {
                    SqlBlock it3 = it2;
                    boolean bl = false;
                    if (!(it3 instanceof SqlKeyword && ((SqlKeyword)it3).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    iterator = it2;
                    break block22;
                }
                iterator = null;
            }
            SqlBlock sqlBlock = asWord = (SqlBlock)((Object)iterator);
            if (sqlBlock != null) {
                Object it4 = object3 = sqlBlock;
                boolean bl = false;
                ((SqlBlock)it4).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
                ((SqlBlock)it4).setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
            object = this.getNestedBlocks();
            it2 = object.iterator();
            while (it2.hasNext()) {
                Object it3 = it2.next();
                SqlBlock it5 = (SqlBlock)it3;
                boolean bl = false;
                if (!(it5 instanceof SqlQueryBlock || it5 instanceof SqlParenthesizedSubqueryBlock)) continue;
                v7 = it3;
                break block23;
            }
            v7 = null;
        }
        SqlBlock querySection = v7;
        if (querySection != null) {
            Object v8;
            block24: {
                it2 = this.getNestedBlocks();
                Iterator it3 = it2.iterator();
                while (it3.hasNext()) {
                    Object t = it3.next();
                    SqlBlock it6 = (SqlBlock)t;
                    boolean bl = false;
                    if (!(it6 instanceof SqlKeyword && ((SqlKeyword)it6).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    v8 = t;
                    break block24;
                }
                v8 = null;
            }
            SqlBlock sqlBlock = v8;
            if (sqlBlock != null) {
                it2 = object = sqlBlock;
                boolean bl = false;
                ((SqlBlock)it2).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
            }
            object2 = querySection;
            if (object2 instanceof SqlQueryBlock) {
                ((SqlQueryBlock)querySection).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_QUERY ? w : null));
                ((SqlQueryBlock)querySection).setMyIndent(this.getContext().getSql().VIEW_INDENT_QUERY ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
            } else if (object2 instanceof SqlParenthesizedSubqueryBlock) {
                ((SqlParenthesizedSubqueryBlock)querySection).setMyWrap((Wrap)(this.getContext().getSql().SUBQUERY_OPENING > 1 ? w : null));
                SqlParenthesizedSubqueryBlock sqlParenthesizedSubqueryBlock = (SqlParenthesizedSubqueryBlock)querySection;
                sqlParenthesizedSubqueryBlock.setMyIndent(switch (this.getContext().getSql().SUBQUERY_OPENING) {
                    case 3 -> Indent.getSpaceIndent((int)0, (boolean)true);
                    case 4 -> Indent.getNormalIndent((boolean)true);
                    default -> SqlFormattingFunKt.getNORMAL_INDENT();
                });
            }
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (this.getShape().getCollapsing()) {
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
        if (block2 instanceof SqlTableParenthesizedColumnsSection) {
            switch (this.getContext().getSql().TABLE_OPENING) {
                case 1: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    protected boolean userRequiresExpand() {
        return !this.getContext().getSql().TABLE_COLLAPSE;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        return blocks.getBlock2() instanceof SqlTableParenthesizedColumnsSection ? SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, this.getContext().getSql().TABLE_OPENING == 4, false, 10, null) : super.getNewLineIndent(blocks);
    }

    static {
        Object[] objectArray = new FlowPattern[9];
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_CREATE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType), (String)"SQL_CREATE");
        NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType);
        Object[] objectArray2 = new IElementType[5];
        Intrinsics.checkNotNullExpressionValue((Object)((Object)SqlCommonTokens.SQL_LEFT_PAREN), (String)"SQL_LEFT_PAREN");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST), (String)"SQL_TABLE_ELEMENT_LIST");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION), (String)"SQL_QUERY_EXPRESSION");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION), (String)"SQL_PARENTHESIZED_QUERY_EXPRESSION");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)SqlCommonKeywords.SQL_AS), (String)"SQL_AS");
        objectArray[0] = new StartUntilPattern(null, null, nodeMatcher, NodeMatcherKt.matchType((IElementType[])objectArray2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType2), (String)"SQL_LEFT_PAREN");
        objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new EndIncElementContinuePattern(SetsKt.setOf((Object)((Object)SqlCommonTokens.SQL_RIGHT_PAREN)), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_ENGINE_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlCompositeElementType), (String)"SQL_ENGINE_CLAUSE");
        objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlCompositeElementType2), (String)"SQL_GENERIC_SETTINGS_CLAUSE");
        objectArray[3] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlCommonKeywords.SQL_ON;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType3), (String)"SQL_ON");
        objectArray2 = new SqlTokenType[]{SqlCommonKeywords.SQL_COMMIT, SqlCommonKeywords.SQL_PRESERVE, SqlCommonKeywords.SQL_DELETE, SqlCommonKeywords.SQL_ROWS};
        objectArray[4] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])objectArray2), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.5.INSTANCE)));
        SqlTokenType sqlTokenType4 = SqlCommonKeywords.SQL_TABLESPACE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType4), (String)"SQL_TABLESPACE");
        objectArray[5] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType4), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)((Object)SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE)), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.6.INSTANCE)));
        SqlTokenType sqlTokenType5 = SqlCommonKeywords.SQL_WITH;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType5), (String)"SQL_WITH");
        objectArray2 = new SqlTokenType[]{SqlCommonKeywords.SQL_OIDS, SqlCommonTokens.SQL_RIGHT_PAREN};
        Set set = SetsKt.setOf((Object[])objectArray2);
        objectArray2 = new SqlTokenType[]{SqlCommonKeywords.SQL_WITH, SqlCommonKeywords.SQL_TABLESPACE};
        objectArray[6] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType5), new EndIncElementContinuePattern(set, SetsKt.setOf((Object[])objectArray2), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.7.INSTANCE)));
        SqlTokenType sqlTokenType6 = SqlCommonKeywords.SQL_WITHOUT;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType6), (String)"SQL_WITHOUT");
        objectArray[7] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType6), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)((Object)SqlCommonKeywords.SQL_OIDS)), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.8.INSTANCE)));
        SqlTokenType sqlTokenType7 = SqlCommonKeywords.SQL_USING;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType7), (String)"SQL_USING");
        objectArray[8] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType7), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)((Object)SqlCompositeElementTypes.SQL_IDENTIFIER)), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.9.INSTANCE)));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$TableHeaderSection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "intellij.database.sql.core.impl"})
    public static final class TableHeaderSection
    extends SqlRangeBlock {
    }
}

