/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlParenthesizedBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0014J\b\u0010\u0011\u001a\u00020\fH\u0014J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedBlock;", "<init>", "()V", "openingBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "closingBlock", "queryBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "defaultIndent", "Lcom/intellij/formatting/Indent;", "adjustNestedNodes", "", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "tuneNestedNodesAfterAnalysis", "configureFormattingAttributes", "defaultChildIndent", "block", "userRequiresExpand", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlParenthesizedBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n295#2,2:204\n*S KotlinDebug\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock\n*L\n56#1:204,2\n*E\n"})
public class SqlParenthesizedSubqueryBlock
extends SqlParenthesizedBlock {
    @Nullable
    private SqlBlock openingBlock;
    @Nullable
    private SqlBlock closingBlock;
    @Nullable
    private SqlQueryBlock queryBlock;
    @NotNull
    private Indent defaultIndent = SqlFormattingFunKt.getNORMAL_INDENT();

    @Override
    protected void adjustNestedNodes() {
        super.adjustNestedNodes();
        if (this.getNestedNodes().size() == 1 && this.getNestedNodes().get(0).getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)SqlParenthesizedSubqueryBlock::adjustNestedNodes$lambda$0));
        }
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SqlBlock b = super.makeBlock(node);
        char[] cArray = new char[]{'('};
        if (SqlUtilFun.isSymbol(node, cArray)) {
            if (this.openingBlock == null) {
                this.openingBlock = b;
            }
        } else {
            cArray = new char[]{')'};
            if (SqlUtilFun.isSymbol(node, cArray)) {
                this.closingBlock = b;
            } else if (b instanceof SqlQueryBlock) {
                this.queryBlock = (SqlQueryBlock)b;
            }
        }
        return b;
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        Object v0;
        block4: {
            super.tuneNestedNodesAfterAnalysis();
            if (this.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
                return;
            }
            Iterable $this$firstOrNull$iv = this.getNestedBlocks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBlock it = (SqlBlock)element$iv;
                boolean bl = false;
                if (!(it instanceof SqlQueryBlock)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        SqlBlock sqlBlock = v0;
        if (sqlBlock == null) {
            return;
        }
        SqlBlock q = sqlBlock;
        if (q.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
            q.setShape(this.getShape());
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        block16: {
            SqlBlock sqlBlock;
            Indent indent;
            SqlCodeStyleSettings s = this.getContext().getSql();
            Wrap w = SqlFlowBlock.makeWrap$default(this, this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
            switch (s.SUBQUERY_CONTENT) {
                case 3: {
                    Indent indent2 = Indent.getSpaceIndent((int)0, (boolean)true);
                    indent = indent2;
                    Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getSpaceIndent(...)");
                    break;
                }
                case 4: {
                    Indent indent3 = Indent.getNormalIndent((boolean)true);
                    indent = indent3;
                    Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"getNormalIndent(...)");
                    break;
                }
                default: {
                    indent = SqlFormattingFunKt.getNORMAL_INDENT();
                }
            }
            this.defaultIndent = indent;
            Alignment a1 = null;
            SqlBlock sqlBlock2 = this.openingBlock;
            if (sqlBlock2 != null) {
                Alignment parentAlignment;
                SqlBlock sqlBlock3;
                SqlBlock it = sqlBlock3 = sqlBlock2;
                boolean bl = false;
                it.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                Alignment alignment = parentAlignment = SqlFormattingModelFun.isAlways(this.getParent().getMyWrap()) ? this.getParent().getMyAlign() : null;
                if (parentAlignment == null) {
                    a1 = SqlFormattingModelFun.makeLeftAlignment();
                    it.setMyAlign(a1);
                } else {
                    a1 = parentAlignment;
                    it.setMyAlign(null);
                }
            }
            Alignment a2 = null;
            SqlQueryBlock sqlQueryBlock = this.queryBlock;
            if (sqlQueryBlock != null) {
                sqlBlock = sqlQueryBlock;
                SqlQueryBlock it = sqlBlock;
                boolean bl = false;
                it.setMyWrap((Wrap)(s.SUBQUERY_CONTENT >= 2 ? w : null));
                a2 = s.SUBQUERY_CONTENT == 3 ? a1 : (s.SUBQUERY_CLOSING == 6 ? SqlFormattingModelFun.makeLeftAlignment() : null);
                it.setMyIndent(this.defaultIndent);
                it.setMyAlign(a2);
            }
            SqlBlock sqlBlock4 = this.closingBlock;
            if (sqlBlock4 == null) break block16;
            SqlBlock it = sqlBlock = sqlBlock4;
            boolean bl = false;
            it.setMyWrap((Wrap)(s.SUBQUERY_CLOSING >= 2 ? w : null));
            it.setMyIndent(switch (s.SUBQUERY_CLOSING) {
                case 3, 4 -> Indent.getSpaceIndent((int)0, (boolean)true);
                case 6 -> this.defaultIndent;
                default -> SqlFormattingFunKt.getNONE_INDENT();
            });
            it.setMyAlign(switch (s.SUBQUERY_CLOSING) {
                case 4 -> a1;
                case 6 -> a2;
                default -> null;
            });
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.defaultIndent;
    }

    @Override
    protected boolean userRequiresExpand() {
        return this.getContext().getSql().QUERY_IN_ONE_STRING == 1 || this.getContext().getSql().SUBQUERY_CONTENT >= 2;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlCodeStyleSettings s = this.getContext().getSql();
        return block2 == this.queryBlock ? this.getContext().makeSpace(s.SUBQUERY_PAR_SPACE_INSIDE, s.SUBQUERY_CONTENT > 1) : (block2 == this.closingBlock ? this.getContext().makeSpace(s.SUBQUERY_PAR_SPACE_INSIDE, s.SUBQUERY_CLOSING > 1) : super.decideSpacing(block1, block2));
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock b1 = blocks.getBlock1();
        Object object = b1;
        if (object == null || (object = object.getRole()) == null) {
            object = BlockRole.NOTHING;
        }
        Object r1 = object;
        if (r1 == BlockRole.PREFIX && this.queryBlock != null) {
            SqlFormattingContext sqlFormattingContext = this.getContext();
            SqlQueryBlock sqlQueryBlock = this.queryBlock;
            Intrinsics.checkNotNull((Object)sqlQueryBlock);
            string = SqlFormattingContext.currIndentOf$default(sqlFormattingContext, sqlQueryBlock, true, false, false, 12, null);
        } else if (r1 == BlockRole.BODY) {
            SqlBlock sqlBlock = b1;
            if ((sqlBlock == null || (sqlBlock = sqlBlock.getLastNestedSqlBlock()) == null) && (sqlBlock = b1) == null) {
                return null;
            }
            SqlBlock b = sqlBlock;
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), b, true, false, false, 12, null);
        } else {
            string = super.getNewLineIndent(blocks);
        }
        return string;
    }

    private static final boolean adjustNestedNodes$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION;
    }
}

