/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalUnknownInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.database.Dbms;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaJoinType;
import com.intellij.sql.inspections.dataflow.SqlDfaPsiUtilKt;
import com.intellij.sql.inspections.dataflow.SqlDfaUnionType;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.SqlPsiRangeSetUtilKt;
import com.intellij.sql.inspections.dataflow.sql.SqlFlowAnalyser;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlClauseAnchor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlNAryExpressionPartAnchor;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlAssignAliasInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBetweenInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanAllAnyInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanAndOrInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanInInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanLikeInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanRelationInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanXorInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlCrossJoinInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlDeleteInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlFilteringInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlFunctionCallInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlGroupByInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlInsertInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlJoinByConditionInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlJoinByUsingInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlLimitInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNaturalJoinInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNotInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNumericBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlOffsetInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlOrderByInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlParenthesizeInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlReferenceAccessInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlSelectInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlStringConcatInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlUnionInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlUpdateInstruction;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlIntersectExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlTypeConversionUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0003-./B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser;", "Lcom/intellij/psi/PsiElementVisitor;", "element", "Lcom/intellij/psi/PsiElement;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getFactory", "()Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "currentFlow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "sqlVisitor", "Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor;", "dbms", "Lcom/intellij/database/Dbms;", "Lorg/jetbrains/annotations/NotNull;", "buildControlFlow", "startElement", "", "finishElement", "addInstruction", "i", "Lcom/intellij/codeInspection/dataFlow/lang/ir/Instruction;", "push", "dfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "pop", "pushUnknown", "createEmptyTable", "o", "Lcom/intellij/sql/psi/SqlTableExpression;", "getInstructionCount", "", "visitElement", "visitErrorElement", "Lcom/intellij/psi/PsiErrorElement;", "Companion", "Visitor", "CannotAnalyzeException", "intellij.database.sql.core.impl"})
public final class SqlFlowAnalyser
extends PsiElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement element;
    @NotNull
    private final DfaValueFactory factory;
    @NotNull
    private final SqlLanguageDialectEx dialect;
    private ControlFlow currentFlow;
    @NotNull
    private final Visitor sqlVisitor;
    @NotNull
    private final Dbms dbms;

    public SqlFlowAnalyser(@NotNull PsiElement element, @NotNull DfaValueFactory factory, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        this.element = element;
        this.factory = factory;
        this.dialect = dialect;
        this.sqlVisitor = new Visitor();
        Dbms dbms = this.dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dbms = dbms;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public final DfaValueFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    private final ControlFlow buildControlFlow() {
        this.currentFlow = new ControlFlow(this.factory, this.element);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        try {
            this.element.accept((PsiElementVisitor)this);
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.finish();
        ControlFlow controlFlow2 = this.currentFlow;
        if (controlFlow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow2 = null;
        }
        return controlFlow2;
    }

    private final void startElement(PsiElement element) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.startElement(element);
    }

    private final void finishElement(PsiElement element) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.finishElement(element);
        if (element instanceof SqlStatement || element instanceof SqlQueryExpression) {
            this.addInstruction((Instruction)new FinishElementInstruction(element));
        }
    }

    private final void addInstruction(Instruction i2) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.addInstruction(i2);
    }

    private final void push(DfType dfType, SqlExpression expression) {
        this.addInstruction((Instruction)new PushValueInstruction(dfType, (DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(expression)));
    }

    private final void pop() {
        this.addInstruction((Instruction)new PopInstruction());
    }

    private final void pushUnknown() {
        this.addInstruction((Instruction)new PushValueInstruction(DfType.TOP, null));
    }

    private final void createEmptyTable(SqlTableExpression o) {
        SqlExpressionAnchor sqlExpressionAnchor = SqlExpressionAnchor.Companion.getAnchor(o);
        this.addInstruction((Instruction)new EvalInstruction(o, sqlExpressionAnchor){
            final /* synthetic */ SqlTableExpression $o;
            {
                this.$o = $o;
                super((DfaAnchor)$super_call_param$1, 0);
            }

            public DfaValue eval(DfaValueFactory factory, DfaMemoryState state, DfaValue ... arguments) {
                Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
                return SqlDfaUtilKt.createTableValue((PsiElement)this.$o, null, factory, state, SqlDfTypesKt.getEMPTY_TABLE());
            }

            public String toString() {
                return "EMPTY_TABLE";
            }
        });
    }

    public final int getInstructionCount() {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        return controlFlow.getInstructionCount();
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof SqlElement) {
            ((SqlElement)element).accept(this.sqlVisitor);
        }
    }

    public void visitErrorElement(@NotNull PsiErrorElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new CannotAnalyzeException();
    }

    @JvmStatic
    @Nullable
    public static final ControlFlow buildFlow(@NotNull PsiElement element, @NotNull DfaValueFactory valueFactory, @NotNull SqlLanguageDialectEx dialect) {
        return Companion.buildFlow(element, valueFactory, dialect);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$CannotAnalyzeException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class CannotAnalyzeException
    extends RuntimeException {
        public CannotAnalyzeException() {
            super(null, null, false, false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Companion;", "", "<init>", "()V", "buildFlow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "element", "Lcom/intellij/psi/PsiElement;", "valueFactory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ControlFlow buildFlow(@NotNull PsiElement element, @NotNull DfaValueFactory valueFactory, @NotNull SqlLanguageDialectEx dialect) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)valueFactory, (String)"valueFactory");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            return new SqlFlowAnalyser(element, valueFactory, dialect).buildControlFlow();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0019H\u0002J\u0012\u0010\u001d\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\t\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u0010\t\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\t\u001a\u000203H\u0016J4\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002030:H\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u0010\r\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J(\u0010>\u001a\u00020\u00052\u0006\u0010\r\u001a\u0002032\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010N\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020=2\u0006\u0010\t\u001a\u00020]H\u0002J\u0010\u0010_\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020]H\u0002J\u000e\u0010`\u001a\u0004\u0018\u000108*\u00020]H\u0002J\u0010\u0010a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020jH\u0016\u00a8\u0006k"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor;", "Lcom/intellij/sql/psi/SqlVisitor;", "<init>", "(Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser;)V", "acceptOrPushUnknown", "", "element", "Lcom/intellij/sql/psi/SqlElement;", "visitSqlUnaryExpression", "o", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "getOperand", "Lcom/intellij/sql/psi/SqlExpression;", "expression", "visitSqlSelectStatement", "Lcom/intellij/sql/psi/SqlSelectStatement;", "visitSqlUpdateStatement", "Lcom/intellij/sql/psi/SqlUpdateStatement;", "visitSqlDeleteStatement", "Lcom/intellij/sql/psi/SqlDeleteStatement;", "visitSqlInsertStatement", "Lcom/intellij/sql/psi/SqlInsertStatement;", "accept", "Lcom/intellij/sql/psi/SqlInsertDmlInstruction;", "acceptSqlUpdateInstruction", "Lcom/intellij/sql/psi/SqlDmlInstruction;", "visitSqlSetAssignment", "Lcom/intellij/sql/psi/SqlSetAssignment;", "acceptSqlDeleteInstruction", "visitSqlDmlInstruction", "visitSqlMergeStatement", "Lcom/intellij/sql/psi/SqlMergeStatement;", "visitSqlExplicitTableExpression", "Lcom/intellij/sql/psi/SqlExplicitTableExpression;", "visitSqlParenthesizedExpression", "Lcom/intellij/sql/psi/SqlParenthesizedExpression;", "visitSqlReferenceList", "Lcom/intellij/sql/psi/SqlReferenceList;", "visitSqlWhereClause", "Lcom/intellij/sql/psi/SqlWhereClause;", "visitSqlCaseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "visitSqlFromClause", "Lcom/intellij/sql/psi/SqlFromClause;", "visitSqlFunctionCallExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "visitSqlHavingClause", "Lcom/intellij/sql/psi/SqlHavingClause;", "visitSqlLiteralExpression", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "visitSqlBinaryExpression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "generateBinOpChain", "op", "Lcom/intellij/psi/tree/IElementType;", "opElement", "Lcom/intellij/psi/PsiElement;", "operands", "", "expressionChain", "isAssignment", "", "generateBinOp", "resType", "Lcom/intellij/database/types/DasTypeCategory;", "visitSqlQueryExpression", "Lcom/intellij/sql/psi/SqlQueryExpression;", "visitSqlWithQueryExpression", "Lcom/intellij/sql/psi/SqlWithQueryExpression;", "visitSqlIntersectExpression", "Lcom/intellij/sql/psi/SqlIntersectExpression;", "visitSqlGroupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "visitSqlUnionExpression", "Lcom/intellij/sql/psi/SqlUnionExpression;", "acceptNAryExpression", "Lcom/intellij/sql/psi/SqlNAryExpression;", "visitSqlExpression", "visitSqlReferenceExpression", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "visitSqlWhenClause", "Lcom/intellij/sql/psi/SqlWhenClause;", "visitSqlThenClause", "Lcom/intellij/sql/psi/SqlThenClause;", "visitSqlElseClause", "Lcom/intellij/sql/psi/SqlElseClause;", "visitSqlSelectClause", "Lcom/intellij/sql/psi/SqlSelectClause;", "visitSqlExpressionList", "Lcom/intellij/sql/psi/SqlExpressionList;", "visitSqlOrderByClause", "Lcom/intellij/sql/psi/SqlOrderByClause;", "visitSqlJoinExpression", "Lcom/intellij/sql/psi/SqlJoinExpression;", "isMssqlOuterApply", "visitMssqlOuterApply", "getOpSignElementSafe", "visitSqlAsExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "visitSqlTableExpression", "Lcom/intellij/sql/psi/SqlTableExpression;", "visitSqlBetweenExpression", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "visitSqlLimitClause", "Lcom/intellij/sql/psi/SqlLimitClause;", "visitSqlOffsetClause", "Lcom/intellij/sql/psi/SqlOffsetClause;", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlFlowAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFlowAnalyser.kt\ncom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,650:1\n1#2:651\n1#2:653\n2756#3:652\n1869#3,2:654\n1869#3,2:656\n1869#3,2:658\n1869#3,2:660\n1869#3,2:662\n1869#3,2:664\n1869#3,2:668\n1869#3,2:670\n1869#3,2:672\n1869#3,2:674\n1869#3,2:678\n13472#4,2:666\n13472#4,2:676\n*S KotlinDebug\n*F\n+ 1 SqlFlowAnalyser.kt\ncom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor\n*L\n181#1:653\n181#1:652\n247#1:654,2\n256#1:656,2\n319#1:658,2\n426#1:660,2\n427#1:662,2\n432#1:664,2\n494#1:668,2\n498#1:670,2\n504#1:672,2\n511#1:674,2\n552#1:678,2\n443#1:666,2\n517#1:676,2\n*E\n"})
    private final class Visitor
    extends SqlVisitor {
        private final void acceptOrPushUnknown(SqlElement element) {
            SqlElement sqlElement = element;
            if (sqlElement != null) {
                sqlElement.accept(this);
            } else {
                SqlFlowAnalyser.this.pushUnknown();
            }
        }

        @Override
        public void visitSqlUnaryExpression(@NotNull SqlUnaryExpression o) {
            SqlExpression sqlExpression;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression sqlExpression2 = SqlImplUtil.skipParenthesizedExprDown(this.getOperand(o));
            if (sqlExpression2 != null) {
                SqlExpression sqlExpression3;
                SqlExpression it = sqlExpression3 = sqlExpression2;
                boolean bl = false;
                it.accept(this);
                sqlExpression = sqlExpression3;
            } else {
                sqlExpression = null;
            }
            SqlExpression operand = sqlExpression;
            IElementType op = PsiTreeUtilKt.getElementType((PsiElement)o.getOpSignElement());
            if (operand == null || op == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o);
                return;
            }
            DasType dasType = operand.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType type = dasType;
            if (SqlPsiUtilKt.isLogicalNot(op, SqlFlowAnalyser.this.dbms)) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNotInstruction(o));
            } else if (Intrinsics.areEqual((Object)op, (Object)((Object)SqlCommonTokens.SQL_OP_MINUS)) && (DasTypeUtilsKt.getCategory(type) == DasTypeCategory.INTEGER || SqlFlowAnalyser.this.dbms.isMysql() && DasTypeUtilsKt.getCategory(type) != DasTypeCategory.STRING)) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new PushValueInstruction((DfType)SqlDfTypesKt.intValue(0)));
                SqlFlowAnalyser.this.addInstruction((Instruction)new SwapInstruction());
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNumericBinaryInstruction(LongRangeBinOp.MINUS, o));
            } else {
                SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(o), 1));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        /*
         * WARNING - void declaration
         */
        private final SqlExpression getOperand(SqlUnaryExpression expression) {
            Object object;
            SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlExpression.class);
            if (sqlExpression != null) {
                void var2_2;
                SqlExpression $this$getOperand_u24lambda_u241 = sqlExpression;
                boolean bl = false;
                object = $this$getOperand_u24lambda_u241 instanceof SqlReferenceExpression ? (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)$this$getOperand_u24lambda_u241), SqlExpression.class) : var2_2;
            } else {
                object = null;
            }
            return object;
        }

        @Override
        public void visitSqlSelectStatement(@NotNull SqlSelectStatement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlResultSetExpression sqlResultSetExpression = o.getResultSetExpression();
            this.acceptOrPushUnknown(sqlResultSetExpression != null ? (SqlExpression)sqlResultSetExpression : (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlExpression.class));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlUpdateStatement(@NotNull SqlUpdateStatement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlDmlInstruction sqlDmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlDmlInstruction.class);
            if (sqlDmlInstruction != null) {
                SqlDmlInstruction it = sqlDmlInstruction;
                boolean bl = false;
                this.acceptSqlUpdateInstruction(it);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlDeleteStatement(@NotNull SqlDeleteStatement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlDmlInstruction sqlDmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlDmlInstruction.class);
            if (sqlDmlInstruction != null) {
                SqlDmlInstruction it = sqlDmlInstruction;
                boolean bl = false;
                this.acceptSqlDeleteInstruction(it);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlInsertStatement(@NotNull SqlInsertStatement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlInsertDmlInstruction sqlInsertDmlInstruction = o.getDmlInstruction();
            if (sqlInsertDmlInstruction != null) {
                this.accept(sqlInsertDmlInstruction);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        private final void accept(SqlInsertDmlInstruction $this$accept) {
            JBIterable<SqlExpression> jBIterable;
            SqlFlowAnalyser.this.startElement((PsiElement)$this$accept);
            SqlExpression sqlExpression = $this$accept.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept(this);
            }
            if ((jBIterable = $this$accept.getValuesExpression()) != null && (jBIterable = jBIterable.getExpressions()) != null) {
                Object object;
                Iterable $this$onEach$iv = (Iterable)jBIterable;
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2418$iv = object = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                    SqlExpression it = (SqlExpression)element$iv;
                    boolean bl2 = false;
                    it.accept(this);
                }
                JBIterable jBIterable2 = (JBIterable)object;
                object = SqlFlowAnalyser.this;
                JBIterable $this$accept_u24lambda_u245 = jBIterable2;
                boolean bl3 = false;
                ((SqlFlowAnalyser)((Object)object)).addInstruction((Instruction)new SqlInsertInstruction($this$accept, $this$accept_u24lambda_u245.size()));
            } else {
                SqlResultSetExpression sqlResultSetExpression = $this$accept.getResultSetExpression();
                if (sqlResultSetExpression != null) {
                    SqlResultSetExpression sqlResultSetExpression2;
                    SqlResultSetExpression it = sqlResultSetExpression2 = sqlResultSetExpression;
                    boolean bl = false;
                    it.accept(this);
                    SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                    SqlResultSetExpression $this$accept_u24lambda_u247 = sqlResultSetExpression2;
                    boolean bl4 = false;
                    sqlFlowAnalyser.addInstruction((Instruction)new SqlInsertInstruction($this$accept, 1));
                } else {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlInsertInstruction($this$accept, 0));
                }
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)$this$accept);
        }

        private final void acceptSqlUpdateInstruction(SqlDmlInstruction o) {
            SqlSetAssignment[] sqlSetAssignmentArray;
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression sqlExpression = o.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept(this);
            }
            SqlWhereClause sqlWhereClause = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlWhereClause.class);
            if (sqlWhereClause != null) {
                sqlWhereClause.accept(this);
            }
            SqlSetClause setClause = (SqlSetClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlSetClause.class);
            SqlSetAssignment[] sqlSetAssignmentArray2 = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)setClause), SqlSetAssignment.class);
            if (sqlSetAssignmentArray2 != null) {
                SqlSetAssignment[] sqlSetAssignmentArray3;
                for (SqlSetAssignment it : sqlSetAssignmentArray3 = sqlSetAssignmentArray2) {
                    boolean bl = false;
                    it.accept(this);
                }
                sqlSetAssignmentArray = sqlSetAssignmentArray3;
            } else {
                sqlSetAssignmentArray = null;
            }
            SqlSetAssignment[] setAssignments = sqlSetAssignmentArray;
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUpdateInstruction(o, setAssignments != null ? setAssignments.length : 0));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlSetAssignment(@NotNull SqlSetAssignment o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            o.getLValue().accept(this);
            SqlElement sqlElement = o.getRValue();
            if (sqlElement != null) {
                sqlElement.accept(this);
            }
            SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlClauseAnchor.Companion.getAnchor(o), o.getRValue() != null ? 2 : 1));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        private final void acceptSqlDeleteInstruction(SqlDmlInstruction o) {
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression sqlExpression = o.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept(this);
            }
            SqlWhereClause sqlWhereClause = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlWhereClause.class);
            if (sqlWhereClause != null) {
                sqlWhereClause.accept(this);
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlReferenceExpression.class);
            if (sqlReferenceExpression != null) {
                SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlReferenceExpression $this$acceptSqlDeleteInstruction_u24lambda_u249 = sqlReferenceExpression2;
                boolean bl = false;
                sqlFlowAnalyser.pop();
                sqlFlowAnalyser.push(SqlDfTypesKt.typedObject$default($this$acceptSqlDeleteInstruction_u24lambda_u249.getDasType(), sqlFlowAnalyser.getDialect(), null, 4, null), $this$acceptSqlDeleteInstruction_u24lambda_u249);
            }
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlDeleteInstruction(o));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlDmlInstruction(@Nullable SqlDmlInstruction o) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)o));
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION))) {
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o instanceof SqlInsertDmlInstruction ? (SqlInsertDmlInstruction)o : null;
                if (sqlInsertDmlInstruction != null) {
                    this.accept(sqlInsertDmlInstruction);
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION))) {
                SqlDmlInstruction sqlDmlInstruction = o;
                if (sqlDmlInstruction == null) {
                    return;
                }
                this.acceptSqlDeleteInstruction(sqlDmlInstruction);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION))) {
                SqlDmlInstruction sqlDmlInstruction = o;
                if (sqlDmlInstruction == null) {
                    return;
                }
                this.acceptSqlUpdateInstruction(sqlDmlInstruction);
            }
        }

        @Override
        public void visitSqlMergeStatement(@NotNull SqlMergeStatement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            super.visitSqlMergeStatement(o);
        }

        @Override
        public void visitSqlExplicitTableExpression(@NotNull SqlExplicitTableExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.acceptOrPushUnknown((SqlElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlExpression.class));
        }

        @Override
        public void visitSqlParenthesizedExpression(@NotNull SqlParenthesizedExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            List list = o.getExpressionList();
            SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
            List $this$visitSqlParenthesizedExpression_u24lambda_u2411 = list;
            boolean bl = false;
            switch ($this$visitSqlParenthesizedExpression_u24lambda_u2411.size()) {
                case 0: {
                    sqlFlowAnalyser.pushUnknown();
                    break;
                }
                case 1: {
                    Intrinsics.checkNotNull((Object)$this$visitSqlParenthesizedExpression_u24lambda_u2411);
                    ((SqlExpression)CollectionsKt.first((List)$this$visitSqlParenthesizedExpression_u24lambda_u2411)).accept(this);
                    break;
                }
                default: {
                    if (!(o.getDasType() instanceof SqlTableType)) {
                        sqlFlowAnalyser.pushUnknown();
                        return;
                    }
                    sqlFlowAnalyser.startElement((PsiElement)o);
                    Intrinsics.checkNotNull((Object)$this$visitSqlParenthesizedExpression_u24lambda_u2411);
                    Iterable $this$forEach$iv = $this$visitSqlParenthesizedExpression_u24lambda_u2411;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlExpression it = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        it.accept(this);
                    }
                    sqlFlowAnalyser.addInstruction((Instruction)new SqlParenthesizeInstruction(o, $this$visitSqlParenthesizedExpression_u24lambda_u2411.size()));
                    sqlFlowAnalyser.finishElement((PsiElement)o);
                }
            }
        }

        @Override
        public void visitSqlReferenceList(@NotNull SqlReferenceList o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            List<SqlReferenceExpression> list = o.getReferenceList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getReferenceList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlReferenceExpression it = (SqlReferenceExpression)element$iv;
                boolean bl = false;
                it.accept(this);
            }
        }

        @Override
        public void visitSqlWhereClause(@NotNull SqlWhereClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            if (sqlExpression != null) {
                SqlExpression sqlExpression2 = sqlExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression it = sqlExpression2;
                boolean bl = false;
                it.accept(this);
                sqlFlowAnalyser.addInstruction((Instruction)new SqlFilteringInstruction(o));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlCaseExpression(@NotNull SqlCaseExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            ControlFlow.DeferredOffset returnOffset = new ControlFlow.DeferredOffset();
            List<SqlClause> list = o.getBranches();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBranches(...)");
            List<SqlClause> branches = list;
            boolean foundElse = false;
            for (IndexedValue item : CollectionsKt.withIndex((Iterable)branches)) {
                SqlClause branch = (SqlClause)item.getValue();
                if (branch instanceof SqlWhenThenClause) {
                    SqlThenClause thenClause;
                    ControlFlow.DeferredOffset skipThenOffset = new ControlFlow.DeferredOffset();
                    SqlWhenClause whenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (whenClause != null) {
                        whenClause.accept(this);
                        SqlFlowAnalyser.this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)skipThenOffset, (DfType)SqlDfTypesKt.getFALSE(), (PsiElement)whenClause));
                    }
                    if ((thenClause = ((SqlWhenThenClause)branch).getThenClause()) != null) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new FinishElementInstruction(null));
                        thenClause.accept(this);
                        SqlFlowAnalyser.this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)returnOffset));
                    } else {
                        SqlFlowAnalyser.this.pushUnknown();
                    }
                    skipThenOffset.setOffset(SqlFlowAnalyser.this.getInstructionCount());
                    continue;
                }
                if (!(branch instanceof SqlElseClause)) continue;
                foundElse = true;
                SqlFlowAnalyser.this.addInstruction((Instruction)new FinishElementInstruction(null));
                ((SqlElseClause)branch).accept(this);
                SqlFlowAnalyser.this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)returnOffset));
            }
            if (!foundElse) {
                SqlFlowAnalyser.this.pushUnknown();
            }
            returnOffset.setOffset(SqlFlowAnalyser.this.getInstructionCount());
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlFromClause(@NotNull SqlFromClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            this.acceptOrPushUnknown(o.getFromExpression());
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
            SqlFunctionCallInstruction sqlFunctionCallInstruction;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            Object object = o.getParameterList();
            if (object != null && (object = object.getExpressionList()) != null) {
                Object $this$visitSqlFunctionCallExpression_u24lambda_u2415 = object;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)$this$visitSqlFunctionCallExpression_u24lambda_u2415;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlExpression it = (SqlExpression)element$iv;
                    boolean bl2 = false;
                    it.accept(this);
                }
                sqlFunctionCallInstruction = new SqlFunctionCallInstruction(o, $this$visitSqlFunctionCallExpression_u24lambda_u2415.size());
            } else {
                sqlFunctionCallInstruction = new SqlFunctionCallInstruction(o, 0);
            }
            SqlFunctionCallInstruction instruction = sqlFunctionCallInstruction;
            SqlFlowAnalyser.this.addInstruction((Instruction)instruction);
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlHavingClause(@NotNull SqlHavingClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            if (sqlExpression != null) {
                SqlExpression sqlExpression2 = sqlExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression $this$visitSqlHavingClause_u24lambda_u2416 = sqlExpression2;
                boolean bl = false;
                $this$visitSqlHavingClause_u24lambda_u2416.accept(this);
                sqlFlowAnalyser.addInstruction((Instruction)new SqlFilteringInstruction(o));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlLiteralExpression(@NotNull SqlLiteralExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlFlowAnalyser.this.push(SqlDfaPsiUtilKt.fromLiteral(o, SqlFlowAnalyser.this.getDialect()), o);
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            PsiElement opElement = o.getOpSignElement();
            IElementType op = o.getOpSign();
            if (opElement == null || op == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o);
                return;
            }
            JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)o).expandAndFilter(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$18(Visitor::visitSqlBinaryExpression$lambda$17, arg_0))).expandAndFilter(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$20(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$19(op, arg_0), arg_0))).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable traversed = jBIterable;
            SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)traversed.last();
            JBIterable jBIterable2 = traversed.map(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$21(visitSqlBinaryExpression.operands.1.INSTANCE, arg_0)).append((Object)(sqlBinaryExpression != null ? sqlBinaryExpression.getLOperand() : null)).filterNotNull();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filterNotNull(...)");
            List operands2 = CollectionsKt.reversed((Iterable)((Iterable)jBIterable2));
            if (operands2.size() <= 1) {
                SqlFlowAnalyser.this.pushUnknown();
            } else {
                this.generateBinOpChain(op, opElement, operands2, CollectionsKt.reversed((Iterable)((Iterable)traversed)));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        private final void generateBinOpChain(IElementType op, PsiElement opElement, List<? extends SqlExpression> operands2, List<? extends SqlBinaryExpression> expressionChain) {
            SqlExpression sqlExpression;
            SqlExpression it = sqlExpression = operands2.get(0);
            boolean bl = false;
            it.accept(this);
            SqlExpression lExpr = sqlExpression;
            DasType dasType = lExpr.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasTypeCategory lType = DasTypeUtilsKt.getCategoryOrUnknown(dasType);
            int n = operands2.size();
            for (int i2 = 1; i2 < n; ++i2) {
                SqlExpression sqlExpression2;
                SqlExpression it2 = sqlExpression2 = operands2.get(i2);
                boolean bl2 = false;
                it2.accept(this);
                SqlExpression rExpr = sqlExpression2;
                DasType dasType2 = rExpr.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                DasTypeCategory rType = DasTypeUtilsKt.getCategoryOrUnknown(dasType2);
                SqlBinaryExpression expression = expressionChain.get(i2 - 1);
                DasTypeCategory resType = SqlTypeConversionUtilKt.calcTypeForBinaryExpression(lType, rType, op, SqlFlowAnalyser.this.getDialect());
                this.generateBinOp(expression, op, opElement, resType);
                lType = resType;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAssignment(SqlBinaryExpression expression, IElementType op) {
            if (!SqlFlowAnalyser.this.getDialect().getDbms().isMicrosoft()) return false;
            if (!Intrinsics.areEqual((Object)op, (Object)((Object)SqlCommonTokens.SQL_OP_EQ))) return false;
            SqlExpression sqlExpression = expression.getLOperand();
            if (!(sqlExpression instanceof SqlReferenceExpression)) return false;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
            Object object = sqlReferenceExpression;
            if (sqlReferenceExpression == null) return false;
            String string = object.getName();
            object = string;
            if (string == null) return false;
            if (!StringsKt.startsWith$default((String)object, (String)"@", (boolean)false, (int)2, null)) return false;
            return true;
        }

        private final void generateBinOp(SqlBinaryExpression expression, IElementType op, PsiElement opElement, DasTypeCategory resType) {
            ExpressionPushingInstruction expressionPushingInstruction;
            if (resType == DasTypeCategory.STRING && SqlPsiUtilKt.isStringConcat(op, SqlFlowAnalyser.this.dbms)) {
                expressionPushingInstruction = new SqlStringConcatInstruction(expression);
            } else if (resType == DasTypeCategory.BOOLEAN) {
                SqlBinaryInstruction sqlBinaryInstruction;
                if (SqlPsiUtilKt.isLogicalAnd(op) || SqlPsiUtilKt.isBitwiseAnd(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanAndOrInstruction(expression, false);
                } else if (SqlPsiUtilKt.isLogicalOr(op) || SqlPsiUtilKt.isBitwiseOr(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanAndOrInstruction(expression, true);
                } else if (SqlPsiUtilKt.isLogicalXor(op, SqlFlowAnalyser.this.dbms) || SqlPsiUtilKt.isBitwiseXor(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanXorInstruction(expression);
                } else if (Intrinsics.areEqual((Object)op, (Object)((Object)SqlCommonKeywords.SQL_LIKE))) {
                    sqlBinaryInstruction = new SqlBooleanLikeInstruction(expression, expression.isNot());
                } else if (Intrinsics.areEqual((Object)op, (Object)((Object)SqlCommonKeywords.SQL_IN))) {
                    sqlBinaryInstruction = new SqlBooleanInInstruction(expression, expression.isNot());
                } else if (Intrinsics.areEqual((Object)op, (Object)((Object)SqlCommonKeywords.SQL_IS))) {
                    RelationType rel = SqlDfaPsiUtilKt.getRelationForIsExpression(expression, opElement);
                    sqlBinaryInstruction = new SqlBooleanRelationInstruction(expression, rel);
                } else if (this.isAssignment(expression, op)) {
                    sqlBinaryInstruction = SqlBooleanBinaryInstruction.Companion.unknown(expression);
                } else {
                    RelationType relationType = SqlDfaPsiUtilKt.getRelationByToken(op, SqlFlowAnalyser.this.dbms);
                    if (relationType != null) {
                        IElementType suffix;
                        RelationType $this$generateBinOp_u24lambda_u2425 = relationType;
                        boolean bl = false;
                        IElementType iElementType = suffix = PsiTreeUtilKt.getElementType((PsiElement)opElement) instanceof SqlCompositeElementType ? (opElement.getChildren().length == 2 ? PsiTreeUtilKt.getElementType((PsiElement)opElement.getLastChild()) : null) : PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)opElement, Visitor::generateBinOp$lambda$25$lambda$24));
                        sqlBinaryInstruction = Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_ALL)) ? (SqlBooleanBinaryInstruction)new SqlBooleanAllAnyInstruction(expression, $this$generateBinOp_u24lambda_u2425, true) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_ANY)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_SOME)) ? (SqlBooleanBinaryInstruction)new SqlBooleanAllAnyInstruction(expression, $this$generateBinOp_u24lambda_u2425, false) : (SqlBooleanBinaryInstruction)new SqlBooleanRelationInstruction(expression, $this$generateBinOp_u24lambda_u2425));
                    } else {
                        sqlBinaryInstruction = SqlBooleanBinaryInstruction.Companion.unknown(expression);
                    }
                }
                expressionPushingInstruction = sqlBinaryInstruction;
            } else {
                expressionPushingInstruction = resType == DasTypeCategory.INTEGER || resType == DasTypeCategory.REAL ? (ExpressionPushingInstruction)new SqlNumericBinaryInstruction(SqlPsiRangeSetUtilKt.binOpFromToken(op, SqlFlowAnalyser.this.dbms), expression) : (ExpressionPushingInstruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(expression), 2);
            }
            ExpressionPushingInstruction instruction = expressionPushingInstruction;
            SqlFlowAnalyser.this.addInstruction((Instruction)instruction);
        }

        @Override
        public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
            SqlClause it;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlTableExpression sqlTableExpression = o.getTableExpression();
            if (sqlTableExpression != null) {
                sqlTableExpression.accept(this);
            }
            SqlSelectClause sqlSelectClause = o.getSelectClause();
            if (sqlSelectClause != null) {
                sqlSelectClause.accept(this);
            }
            SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlOrderByClause.class);
            if (sqlOrderByClause != null) {
                sqlOrderByClause.accept(this);
            }
            JBIterable<SqlLimitClause> jBIterable = o.getLimitClauses();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getLimitClauses(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SqlLimitClause)element$iv;
                boolean bl = false;
                it.accept(this);
            }
            JBIterable<SqlOffsetClause> jBIterable2 = o.getOffsetClauses();
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getOffsetClauses(...)");
            $this$forEach$iv = (Iterable)jBIterable2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SqlOffsetClause)element$iv;
                boolean bl = false;
                it.accept(this);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlWithQueryExpression(@NotNull SqlWithQueryExpression o) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                JBIterable<SqlAsExpression> jBIterable = o.getWithClause().getQueryDefinitions();
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getQueryDefinitions(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlAsExpression it = (SqlAsExpression)element$iv;
                    boolean bl = false;
                    it.accept(this);
                }
                SqlExpression sqlExpression = o.getExpression();
                if (sqlExpression == null) break block1;
                sqlExpression.accept(this);
            }
        }

        @Override
        public void visitSqlIntersectExpression(@NotNull SqlIntersectExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.acceptNAryExpression(o);
        }

        @Override
        public void visitSqlGroupByClause(@NotNull SqlGroupByClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            if (sqlExpressionArray != null) {
                SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression[] $this$visitSqlGroupByClause_u24lambda_u2430 = sqlExpressionArray2;
                boolean bl = false;
                SqlExpression[] $this$forEach$iv = $this$visitSqlGroupByClause_u24lambda_u2430;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    SqlExpression element$iv;
                    SqlExpression it = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    it.accept(this);
                }
                sqlFlowAnalyser.addInstruction((Instruction)new SqlGroupByInstruction(o, $this$visitSqlGroupByClause_u24lambda_u2430.length));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlUnionExpression(@NotNull SqlUnionExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.acceptNAryExpression(o);
        }

        private final void acceptNAryExpression(SqlNAryExpression o) {
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            List<SqlExpression> list = o.getOperands();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOperands(...)");
            List<SqlExpression> operands2 = list;
            ((SqlExpression)CollectionsKt.first(operands2)).accept(this);
            int n = operands2.size();
            for (int i2 = 1; i2 < n; ++i2) {
                EvalUnknownInstruction evalUnknownInstruction;
                operands2.get(i2).accept(this);
                PsiElement op = o.getOpSignElement(i2 - 1);
                SqlNAryExpressionPartAnchor anchor = new SqlNAryExpressionPartAnchor(o, i2);
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)op);
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_UNION))) {
                    PsiElement psiElement = op;
                    Intrinsics.checkNotNull((Object)psiElement);
                    if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)psiElement, Visitor::acceptNAryExpression$lambda$31)), (Object)((Object)SqlCommonKeywords.SQL_ALL))) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor, SqlDfaUnionType.UNION_ALL));
                    } else {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor, SqlDfaUnionType.UNION_DISTINCT));
                    }
                    evalUnknownInstruction = Unit.INSTANCE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_EXCEPT))) {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor, SqlDfaUnionType.EXCEPT));
                    evalUnknownInstruction = Unit.INSTANCE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonKeywords.SQL_INTERSECT))) {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor, SqlDfaUnionType.INTERSECT));
                    evalUnknownInstruction = Unit.INSTANCE;
                    continue;
                }
                evalUnknownInstruction = new EvalUnknownInstruction((DfaAnchor)anchor, 2);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlExpression(@NotNull SqlExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlFlowAnalyser.this.pushUnknown();
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlReferenceAccessInstruction(o, SqlFlowAnalyser.this.getDialect()));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlWhenClause(@NotNull SqlWhenClause o) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                SqlExpression sqlExpression = o.getExpression();
                if (sqlExpression == null) break block0;
                sqlExpression.accept(this);
            }
        }

        @Override
        public void visitSqlThenClause(@NotNull SqlThenClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            JBIterable<SqlElement> jBIterable = o.getBody();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getBody(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlElement it = (SqlElement)element$iv;
                boolean bl = false;
                it.accept(this);
            }
        }

        @Override
        public void visitSqlElseClause(@NotNull SqlElseClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            JBIterable<SqlCompositeElement> jBIterable = o.getBody();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getBody(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlCompositeElement it = (SqlCompositeElement)element$iv;
                boolean bl = false;
                it.accept(this);
            }
        }

        @Override
        public void visitSqlSelectClause(@NotNull SqlSelectClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            List<SqlExpression> list = o.getExpressions();
            SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
            List<SqlExpression> $this$visitSqlSelectClause_u24lambda_u2435 = list;
            boolean bl = false;
            Intrinsics.checkNotNull($this$visitSqlSelectClause_u24lambda_u2435);
            Iterable $this$forEach$iv = $this$visitSqlSelectClause_u24lambda_u2435;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlExpression it = (SqlExpression)element$iv;
                boolean bl2 = false;
                it.accept(this);
            }
            sqlFlowAnalyser.addInstruction((Instruction)new SqlSelectInstruction(o, $this$visitSqlSelectClause_u24lambda_u2435.size()));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlExpressionList(@NotNull SqlExpressionList o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            List<SqlExpression> list = o.getExpressionList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlExpression it = (SqlExpression)element$iv;
                boolean bl = false;
                it.accept(this);
            }
        }

        @Override
        public void visitSqlOrderByClause(@NotNull SqlOrderByClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            if (sqlExpressionArray != null) {
                SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression[] $this$visitSqlOrderByClause_u24lambda_u2438 = sqlExpressionArray2;
                boolean bl = false;
                SqlExpression[] $this$forEach$iv = $this$visitSqlOrderByClause_u24lambda_u2438;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    SqlExpression element$iv;
                    SqlExpression it = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    it.accept(this);
                }
                sqlFlowAnalyser.addInstruction((Instruction)new SqlOrderByInstruction(o, $this$visitSqlOrderByClause_u24lambda_u2438.length));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlJoinExpression(@NotNull SqlJoinExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            if (this.isMssqlOuterApply(o)) {
                this.visitMssqlOuterApply(o);
                return;
            }
            PsiElement psiElement = this.getOpSignElementSafe(o);
            IElementType op = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
            SqlExpression sqlExpression = o.getLOperand();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
            SqlExpression lOperand = sqlExpression;
            SqlExpression rOperand = o.getROperand();
            SqlDfaJoinType joinType = SqlDfaJoinType.Companion.fromToken(op);
            if (joinType == null || rOperand == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o);
                return;
            }
            lOperand.accept(this);
            rOperand.accept(this);
            SqlDfaJoinType sqlDfaJoinType = joinType;
            switch (WhenMappings.$EnumSwitchMapping$0[sqlDfaJoinType.ordinal()]) {
                case 1: {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlCrossJoinInstruction(o));
                    break;
                }
                case 2: {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNaturalJoinInstruction(o));
                    break;
                }
                default: {
                    SqlClause conditionClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o), SqlClause.class);
                    if (conditionClause instanceof SqlJoinConditionClause) {
                        this.acceptOrPushUnknown(((SqlJoinConditionClause)conditionClause).getExpression());
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByConditionInstruction(o, joinType));
                        break;
                    }
                    if (conditionClause instanceof SqlUsingClause) {
                        int n;
                        SqlReferenceList sqlReferenceList = ((SqlUsingClause)conditionClause).getReferenceList();
                        if (sqlReferenceList != null) {
                            SqlReferenceList references = sqlReferenceList;
                            boolean bl = false;
                            List<SqlReferenceExpression> refList = references.getReferenceList();
                            Intrinsics.checkNotNull(refList);
                            Iterable $this$forEach$iv = refList;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                SqlReferenceExpression it = (SqlReferenceExpression)element$iv;
                                boolean bl2 = false;
                                it.accept(this);
                            }
                            n = refList.size();
                        } else {
                            n = 0;
                        }
                        int args2 = n;
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByUsingInstruction(o, joinType, args2));
                        break;
                    }
                    if (conditionClause == null && joinType == SqlDfaJoinType.INNER && SqlFlowAnalyser.this.dbms.isMysql()) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlCrossJoinInstruction(o));
                        break;
                    }
                    SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(o), 2));
                }
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        private final boolean isMssqlOuterApply(SqlJoinExpression o) {
            if (!SqlFlowAnalyser.this.getDialect().getDbms().in(Dbms.MSSQL_LIKE)) {
                return false;
            }
            PsiElement psiElement = this.getOpSignElementSafe(o);
            if (psiElement == null) {
                return false;
            }
            PsiElement opSign = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)opSign);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement sibling = psiElement2;
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)opSign), (Object)((Object)SqlCommonKeywords.SQL_OUTER)) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)sibling), (Object)((Object)SqlCommonKeywords.SQL_APPLY));
        }

        private final void visitMssqlOuterApply(SqlJoinExpression o) {
            SqlExpression sqlExpression = o.getLOperand();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
            SqlExpression lOperand = sqlExpression;
            SqlExpression rOperand = o.getROperand();
            if (rOperand == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o);
                return;
            }
            lOperand.accept(this);
            rOperand.accept(this);
            SqlFlowAnalyser.this.pushUnknown();
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByConditionInstruction(o, SqlDfaJoinType.LEFT));
        }

        private final PsiElement getOpSignElementSafe(SqlJoinExpression $this$getOpSignElementSafe) {
            for (ASTNode child = $this$getOpSignElementSafe.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType type;
                Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"getElementType(...)");
                if (!(type instanceof SqlKeywordTokenType) && type != SqlCommonTokens.SQL_COMMA) continue;
                return child.getPsi();
            }
            return null;
        }

        @Override
        public void visitSqlAsExpression(@NotNull SqlAsExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement(o);
            this.acceptOrPushUnknown(o.getExpression());
            if (o.getDasType() instanceof SqlTableType) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlAssignAliasInstruction(o));
            }
            SqlFlowAnalyser.this.finishElement(o);
        }

        @Override
        public void visitSqlTableExpression(@NotNull SqlTableExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (Intrinsics.areEqual((Object)o.getText(), (Object)"")) {
                return;
            }
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            SqlFromClause sqlFromClause = o.getFromClause();
            if (sqlFromClause != null) {
                sqlFromClause.accept(this);
            } else {
                SqlFlowAnalyser.this.createEmptyTable(o);
            }
            SqlWhereClause sqlWhereClause = o.getWhereClause();
            if (sqlWhereClause != null) {
                sqlWhereClause.accept(this);
            }
            SqlGroupByClause sqlGroupByClause = o.getGroupByClause();
            if (sqlGroupByClause != null) {
                sqlGroupByClause.accept(this);
            }
            SqlHavingClause sqlHavingClause = o.getHavingClause();
            if (sqlHavingClause != null) {
                sqlHavingClause.accept(this);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlBetweenExpression(@NotNull SqlBetweenExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            o.getSubject().accept(this);
            this.acceptOrPushUnknown(o.getLowerBound());
            this.acceptOrPushUnknown(o.getUpperBound());
            PsiElement psiElement = o.getOperation();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperation(...)");
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlBetweenInstruction(o, SqlPsiUtilKt.isNegateOperation(psiElement)));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlLimitClause(@NotNull SqlLimitClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            this.acceptOrPushUnknown(o.getRowCountExpression());
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlLimitInstruction(o));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        @Override
        public void visitSqlOffsetClause(@NotNull SqlOffsetClause o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o);
            this.acceptOrPushUnknown(o.getOffsetExpression());
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlOffsetInstruction(o));
            SqlFlowAnalyser.this.finishElement((PsiElement)o);
        }

        private static final boolean visitSqlBinaryExpression$lambda$17(PsiElement it) {
            return it instanceof SqlBinaryExpression;
        }

        private static final boolean visitSqlBinaryExpression$lambda$18(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean visitSqlBinaryExpression$lambda$19(IElementType $op, PsiElement it) {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlBinaryExpression");
            return Intrinsics.areEqual((Object)((SqlBinaryExpression)it).getOpSign(), (Object)$op);
        }

        private static final boolean visitSqlBinaryExpression$lambda$20(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final SqlExpression visitSqlBinaryExpression$lambda$21(Function1 $tmp0, Object p0) {
            return (SqlExpression)$tmp0.invoke(p0);
        }

        private static final boolean generateBinOp$lambda$25$lambda$24(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)TokenType.WHITE_SPACE);
        }

        private static final boolean acceptNAryExpression$lambda$31(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)TokenType.WHITE_SPACE);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SqlDfaJoinType.values().length];
                try {
                    nArray[SqlDfaJoinType.CROSS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SqlDfaJoinType.NATURAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

