/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.symbols.DasTableSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionWithOrdinalityBase;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallTableExpressionImpl
extends SqlExplicitTableExpressionWithOrdinalityBase
implements SqlDefinition {
    private volatile FakeTable myTable;

    public SqlFunctionCallTableExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myTable = null;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = super.getDbms();
        if (dbms == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public void clearCaches() {
        this.myTable = null;
        super.clearCaches();
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlTableType sqlType;
        SqlColumnAliasListImpl aliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        if (aliasList != null && (sqlType = aliasList.getDasType(this.getTable())) != null) {
            SqlTableType sqlTableType = sqlType;
            if (sqlTableType == null) {
                SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(2);
            }
            return sqlTableType;
        }
        DasType dasType = super.getDasType();
        if (dasType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(3);
        }
        return dasType;
    }

    @Override
    @NotNull
    protected SqlTableType getDasTypeWithoutOrdinality() {
        SqlTableType sqlTableType = this.getFunctionTableType();
        if (sqlTableType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    private SqlTableType getFunctionTableType() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        if (call == null) {
            TableBasedSqlTableTypeImpl emptyTableType = new TableBasedSqlTableTypeImpl(ContainerUtil.emptyList(), null);
            return SqlTableTypeBase.createType(this, emptyTableType, null, false, false, this.getTable(), null);
        }
        SqlReferenceExpression name2 = call.getNameElement();
        DasType dasType = DasTypeUtilsKt.unwrap(call.getDasType());
        SqlTableType tableType2 = SqlImplUtil.convertToTableType(dasType, this);
        String alias = name2 == null ? null : name2.getName();
        FakeTable table = this.getTable();
        if (tableType2 != null) {
            List aliases = Collections.emptyList();
            if (tableType2.getColumnCount() == 1 && StringUtil.isEmpty((String)tableType2.getColumnName(0))) {
                aliases = ContainerUtil.createMaybeSingletonList((Object)name2);
            }
            return tableType2.alias(alias, table, aliases);
        }
        return SqlTableTypeBase.createType(table.myColumn, dasType, alias, DbSqlUtilCore.isQuoted(name2), false, table, null);
    }

    @Nullable
    private SqlFunctionCallExpression getFunctionCall() {
        return (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlFunctionCallExpression.class);
    }

    @Override
    @NotNull
    public String getName() {
        SqlNameElement nameElement = this.getNameElement();
        String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
        if (string == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        SqlNameElement nameElement;
        if (name2 == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(6);
        }
        if ((nameElement = this.getNameElement()) != null) {
            nameElement.setName(name2);
        }
        return this;
    }

    @Override
    @Nullable
    public SqlNameElement getNameElement() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        return call == null ? null : call.getNameElement();
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(7);
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    @Override
    public boolean isNameQuoted() {
        return DbSqlUtilCore.isQuoted(this.getNameElement());
    }

    @Override
    @NotNull
    protected FakeTable getTable() {
        FakeTable fakeTable = this.myTable == null ? (this.myTable = new FakeTable()) : this.myTable;
        if (fakeTable == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(8);
        }
        return fakeTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeWithoutOrdinality";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    private class FakeTable
    extends FakeDefinition
    implements PsiTable,
    DasTableSymbol {
        private final FakeColumn myColumn;

        @Override
        @NotNull
        public DasTable getDasObject() {
            FakeTable fakeTable = this;
            if (fakeTable == null) {
                FakeTable.$$$reportNull$$$0(0);
            }
            return fakeTable;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        @Override
        public boolean isTemporary() {
            return false;
        }

        @Override
        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                FakeTable.$$$reportNull$$$0(1);
            }
            return set;
        }

        protected FakeTable() {
            super((PsiElement)SqlFunctionCallTableExpressionImpl.this);
            this.myColumn = new FakeColumn();
        }

        @NotNull
        public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.of((Object)this.myColumn).filter(DasUtil.byKind(kind));
            if (jBIterable == null) {
                FakeTable.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                FakeTable.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class FakeColumn
        extends FakeDefinition
        implements PsiColumn,
        DasColumnSymbol {
            protected FakeColumn() {
                super((PsiElement)FakeTable.this);
            }

            @Override
            @NotNull
            public DasColumn getDasObject() {
                FakeColumn fakeColumn = this;
                if (fakeColumn == null) {
                    FakeColumn.$$$reportNull$$$0(0);
                }
                return fakeColumn;
            }

            @Override
            public short getPosition() {
                return 0;
            }

            @Override
            @NotNull
            public String getName() {
                SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)SqlFunctionCallTableExpressionImpl.this.getParent(), SqlAsExpression.class);
                String name2 = asExpr == null ? null : asExpr.getName();
                String string = name2 == null ? super.getName() : name2;
                if (string == null) {
                    FakeColumn.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public DasTable getTable() {
                return FakeTable.this;
            }

            @Override
            @Nullable
            public DasObject getDasParent() {
                return this.getTable();
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    FakeColumn.$$$reportNull$$$0(2);
                }
                return objectKind;
            }

            @Override
            @NotNull
            public DasType getDasType() {
                SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
                DasType dasType = call == null ? DasTypeSystemBase.UNKNOWN : call.getDasType();
                if (dasType == null) {
                    FakeColumn.$$$reportNull$$$0(3);
                }
                return dasType;
            }

            @Override
            public boolean isNotNull() {
                return false;
            }

            @Override
            @Nullable
            public String getDefault() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    protected abstract class FakeDefinition
    extends SqlExplicitTableExpressionWithOrdinalityBase.FakeDefinition {
        protected FakeDefinition(PsiElement parent) {
            super(parent);
        }

        @Override
        @Nullable
        public SqlNameElement getNameElement() {
            SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
            return call == null ? null : call.getNameElement();
        }
    }
}

