/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeFactory;

public class NodeMap {
    Map nodeMap = new TreeMap();
    NodeFactory nodeFact;

    public NodeMap(NodeFactory nodeFact) {
        this.nodeFact = nodeFact;
    }

    public Node addNode(Coordinate coord) {
        Node node = (Node)this.nodeMap.get(coord);
        if (node == null) {
            node = this.nodeFact.createNode(coord);
            this.nodeMap.put(coord, node);
        }
        return node;
    }

    public Node addNode(Node n) {
        Node node = (Node)this.nodeMap.get(n.getCoordinate());
        if (node == null) {
            this.nodeMap.put(n.getCoordinate(), n);
            return n;
        }
        node.mergeLabel(n);
        return node;
    }

    public void add(EdgeEnd e) {
        Coordinate p2 = e.getCoordinate();
        Node n = this.addNode(p2);
        n.add(e);
    }

    public Node find(Coordinate coord) {
        return (Node)this.nodeMap.get(coord);
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public Collection values() {
        return this.nodeMap.values();
    }

    public Collection getBoundaryNodes(int geomIndex) {
        ArrayList<Node> bdyNodes = new ArrayList<Node>();
        Iterator i2 = this.iterator();
        while (i2.hasNext()) {
            Node node = (Node)i2.next();
            if (node.getLabel().getLocation(geomIndex) != 1) continue;
            bdyNodes.add(node);
        }
        return bdyNodes;
    }

    public void print(PrintStream out) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.print(out);
        }
    }
}

