/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.parser;

import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.converters.curl.parser.CurlDataOption;
import com.intellij.httpClient.converters.curl.parser.CurlDataOptionFactory;
import com.intellij.httpClient.converters.curl.parser.CurlFormData;
import com.intellij.httpClient.converters.curl.parser.HttpRequestCurlTokenizer;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.auth.HttpRequestAuthScope;
import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlParser {
    private static final String BOUNDARY = "WebAppBoundary";
    private static final String MULTIPART_FORM_HEADER_VALUE = "multipart/form-data";
    private static final String URLENCODED_HEADER_VALUE = "application/x-www-form-urlencoded";
    private String myContentType;
    private String myAuthSchemes;
    private boolean myHasRequestBody;
    @Nullable
    private String myPotentialUrl;
    @NotNull
    private final String myCurlString;

    public CurlParser(@NotNull String inputString) {
        if (inputString == null) {
            CurlParser.$$$reportNull$$$0(0);
        }
        this.myPotentialUrl = null;
        this.myCurlString = inputString;
    }

    @NotNull
    public RestClientRequest parseToRestClientRequest() throws CurlParseException {
        if (!Utils.isCurlString(this.myCurlString)) {
            throw CurlParseException.newNotCurlException();
        }
        RestClientRequest restClientRequest = new RestClientRequest();
        List<String> tokens = HttpRequestCurlTokenizer.splitInCurlTokens(this.myCurlString);
        int i = 1;
        TokenInfo previousTokenInfo = TokenInfo.TOKEN_WITHOUT_OPTION;
        while (i < tokens.size()) {
            String currentToken = tokens.get(i);
            if (currentToken.equals("\\")) {
                ++i;
                continue;
            }
            String nextToken = null;
            if (i + 1 < tokens.size()) {
                nextToken = tokens.get(i + 1);
            }
            i += (previousTokenInfo = this.chooseCategory(restClientRequest, currentToken, nextToken, previousTokenInfo)) == TokenInfo.OPTION_WITH_ARGUMENT ? 2 : 1;
        }
        this.checkURL(restClientRequest);
        this.setHttpMethodToRequest(restClientRequest);
        if (this.myContentType != null) {
            this.addContentTypeHeaderToRequest(restClientRequest);
        }
        RestClientRequest restClientRequest2 = restClientRequest;
        if (restClientRequest2 == null) {
            CurlParser.$$$reportNull$$$0(1);
        }
        return restClientRequest2;
    }

    private TokenInfo chooseCategory(@NotNull RestClientRequest request, @NotNull String currentToken, @Nullable String nextToken, TokenInfo previousTokenInfo) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(2);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(3);
        }
        TokenInfo shift = TokenInfo.OPTION;
        if (Utils.isLongOption(currentToken)) {
            shift = this.addLongOption(request, currentToken.substring(2), nextToken);
        } else if (Utils.isShortOption(currentToken)) {
            shift = this.addShortOption(request, currentToken.substring(1), nextToken);
        } else if (previousTokenInfo == TokenInfo.UNKNOWN_OPTION) {
            this.addUrlIfNotExist(request, currentToken);
        } else {
            CurlParser.addURL(request, currentToken);
        }
        return shift;
    }

    private TokenInfo addShortOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        boolean withoutSpace;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(4);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(5);
        }
        if (Utils.isAlwaysSetShortOption(option)) {
            return TokenInfo.OPTION;
        }
        if (!Utils.isKnownShortOption(option)) {
            return TokenInfo.UNKNOWN_OPTION;
        }
        if (option.length() > 1) {
            withoutSpace = true;
            nextToken = option.substring(1);
        } else {
            withoutSpace = false;
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        switch (option.charAt(0)) {
            case 'X': {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case 'H': {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case 'd': {
                this.addDataToRequest("data", request, nextToken);
                break;
            }
            case 'u': {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case 'F': {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return withoutSpace ? TokenInfo.OPTION : TokenInfo.OPTION_WITH_ARGUMENT;
    }

    private TokenInfo addLongOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(6);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(7);
        }
        if (Utils.isAlwaysSetLongOption(option)) {
            return TokenInfo.OPTION;
        }
        if (this.isAuthSchemeOption(request, option)) {
            return TokenInfo.OPTION;
        }
        if (!Utils.isKnownLongOption(option)) {
            return TokenInfo.UNKNOWN_OPTION;
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        if (option.startsWith("data")) {
            this.addDataToRequest(option, request, nextToken);
            return TokenInfo.OPTION_WITH_ARGUMENT;
        }
        switch (option) {
            case "url": {
                CurlParser.addURL(request, nextToken);
                break;
            }
            case "request": {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case "header": {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case "user": {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case "form": {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return TokenInfo.OPTION_WITH_ARGUMENT;
    }

    private void addHeaderToRequest(@NotNull RestClientRequest request, @NotNull String header) {
        RestClientRequest.KeyValuePair keyValueHeaderPair;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(8);
        }
        if (header == null) {
            CurlParser.$$$reportNull$$$0(9);
        }
        if (StringUtil.toLowerCase((String)(keyValueHeaderPair = CurlParser.getKeyValueForHeader(header)).getKey()).equals("content-type")) {
            this.myContentType = this.myContentType != null ? CurlParser.updateContentTypeIfNeeded(request, keyValueHeaderPair.getValue(), this.myContentType) : keyValueHeaderPair.getValue();
        } else {
            request.headers.add(CurlParser.getKeyValueForHeader(header));
        }
    }

    @NotNull
    private static String updateContentTypeIfNeeded(@NotNull RestClientRequest request, @NotNull String headerValue, @NotNull String contentType) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(10);
        }
        if (headerValue == null) {
            CurlParser.$$$reportNull$$$0(11);
        }
        if (contentType == null) {
            CurlParser.$$$reportNull$$$0(12);
        }
        Object updatedContentType = contentType;
        if (request.multipartBoundary != null) {
            if (contentType.equals(MULTIPART_FORM_HEADER_VALUE)) {
                updatedContentType = headerValue;
            }
        } else {
            updatedContentType = contentType.equals(URLENCODED_HEADER_VALUE) ? headerValue : contentType + ", " + headerValue;
        }
        String string = updatedContentType;
        if (string == null) {
            CurlParser.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void addHttpMethodToRequest(@NotNull RestClientRequest request, @NotNull String method) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(14);
        }
        if (method == null) {
            CurlParser.$$$reportNull$$$0(15);
        }
        request.httpMethod = method;
    }

    private static void addMethodIfItIsNotSet(@NotNull RestClientRequest request, @NotNull String method) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(16);
        }
        if (method == null) {
            CurlParser.$$$reportNull$$$0(17);
        }
        if (request.httpMethod == null) {
            request.httpMethod = method;
        }
    }

    private void setHttpMethodToRequest(RestClientRequest restClientRequest) {
        if ("TRACE".equals(restClientRequest.httpMethod) && this.myHasRequestBody) {
            throw CurlParseException.newMethodDoNotSupportBodyException(restClientRequest.httpMethod);
        }
        CurlParser.addMethodIfItIsNotSet(restClientRequest, "GET");
    }

    private void addDataToRequest(@NotNull String optionName, @NotNull RestClientRequest request, @NotNull String data) {
        if (optionName == null) {
            CurlParser.$$$reportNull$$$0(18);
        }
        if (request == null) {
            CurlParser.$$$reportNull$$$0(19);
        }
        if (data == null) {
            CurlParser.$$$reportNull$$$0(20);
        }
        CurlParser.addMethodIfItIsNotSet(request, "POST");
        CurlDataOption curlDataOption = CurlDataOptionFactory.getCurlDataOption(optionName, data);
        if (curlDataOption != null) {
            curlDataOption.apply(request);
        }
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: application/x-www-form-urlencoded");
        }
        this.myHasRequestBody = true;
    }

    private void addAuthorizationDataToRequest(@NotNull RestClientRequest request, @NotNull String authData) {
        String username;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(21);
        }
        if (authData == null) {
            CurlParser.$$$reportNull$$$0(22);
        }
        HttpRequestAuthScope authScope = new HttpRequestAuthScope(this.myAuthSchemes == null ? "Basic" : this.myAuthSchemes);
        String password = "";
        int colonPosition = authData.indexOf(58);
        if (colonPosition < 0) {
            username = authData;
        } else {
            username = authData.substring(0, colonPosition);
            password = authData.substring(colonPosition + 1);
        }
        request.authData = new HttpClientAuthData(authScope, new HttpRequestAuthCredentials.UsernamePassword(username, password));
    }

    private boolean isAuthSchemeOption(@NotNull RestClientRequest request, @NotNull String option) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(23);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(24);
        }
        switch (option) {
            case "basic": {
                this.myAuthSchemes = "Basic";
                break;
            }
            case "digest": {
                this.myAuthSchemes = "Digest";
                break;
            }
            case "ntlm": {
                this.myAuthSchemes = "NTLM";
                break;
            }
            case "negotiate": {
                this.myAuthSchemes = "Negotiate";
                break;
            }
            default: {
                return false;
            }
        }
        if (request.authData != null) {
            HttpRequestAuthScope authScope = new HttpRequestAuthScope(this.myAuthSchemes);
            request.authData = new HttpClientAuthData(authScope, request.authData.getAuthCredentials());
        }
        return true;
    }

    private void addFormDataToRequest(@NotNull RestClientRequest request, @NotNull String formData) {
        RestClientFormBodyPart restClientFormBodyPart;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(25);
        }
        if (formData == null) {
            CurlParser.$$$reportNull$$$0(26);
        }
        CurlFormData curlFormData = new CurlFormData(formData);
        String fieldName = curlFormData.getName();
        if (curlFormData.hasFileContent()) {
            Path filePath = curlFormData.getFile();
            if (filePath == null) {
                throw CurlParseException.newInvalidPathException(formData);
            }
            String filename = filePath.getFileName().toString();
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, filename, filePath.toFile(), curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"; filename=\"" + filename + "\"");
        } else {
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, curlFormData.getContent(), curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"");
        }
        curlFormData.getHeaders().forEach(additionalHeader -> restClientFormBodyPart.addHeader(additionalHeader.getKey(), additionalHeader.getValue()));
        request.formBodyPart.add(restClientFormBodyPart);
        CurlParser.addMethodIfItIsNotSet(request, "POST");
        request.isFileUpload = true;
        request.multipartBoundary = BOUNDARY;
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: multipart/form-data");
        }
    }

    private static void addURL(@NotNull RestClientRequest request, @NotNull String currentToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(27);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(28);
        }
        try {
            new URI(currentToken);
            CurlParser.setUrl(request, currentToken);
        }
        catch (URISyntaxException e) {
            throw CurlParseException.newInvalidUrlException(currentToken);
        }
    }

    private void addUrlIfNotExist(@NotNull RestClientRequest request, @NotNull String currentToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(29);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(30);
        }
        try {
            this.myPotentialUrl = currentToken;
            new URI(currentToken);
            if (request.urlBase == null) {
                CurlParser.setUrl(request, currentToken);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private static void setUrl(@NotNull RestClientRequest request, @NotNull String url) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(31);
        }
        if (url == null) {
            CurlParser.$$$reportNull$$$0(32);
        }
        request.urlBase = url;
        request.urlPath = "";
    }

    private void checkURL(@NotNull RestClientRequest request) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(33);
        }
        if (request.urlBase != null) {
            return;
        }
        if (this.myPotentialUrl != null) {
            throw CurlParseException.newInvalidUrlException(this.myPotentialUrl);
        }
        throw CurlParseException.newNoUrlException();
    }

    @NotNull
    private static RestClientRequest.KeyValuePair getKeyValueForHeader(@NotNull String header) {
        int colonPosition;
        if (header == null) {
            CurlParser.$$$reportNull$$$0(34);
        }
        if ((colonPosition = header.indexOf(58)) < 0) {
            return new RestClientRequest.KeyValuePair(header.trim().replaceAll(";$", ""), "");
        }
        String name = header.substring(0, colonPosition).trim();
        if (name.isEmpty()) {
            throw CurlParseException.newInvalidHeaderException(header);
        }
        String value2 = header.substring(colonPosition + 1);
        return new RestClientRequest.KeyValuePair(name, value2.trim());
    }

    private void addContentTypeHeaderToRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(35);
        }
        Object header = "Content-Type: ";
        header = request.multipartBoundary != null ? (String)header + this.myContentType + "; boundary=WebAppBoundary" : (String)header + this.myContentType;
        request.headers.add(CurlParser.getKeyValueForHeader((String)header));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/parser/CurlParser";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentToken";
                break;
            }
            case 5: 
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 9: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authData";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/parser/CurlParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToRestClientRequest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContentTypeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 13: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseCategory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addShortOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLongOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderToRequest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTypeIfNeeded";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addHttpMethodToRequest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMethodIfItIsNotSet";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDataToRequest";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAuthorizationDataToRequest";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAuthSchemeOption";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addFormDataToRequest";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addUrlIfNotExist";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkURL";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueForHeader";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addContentTypeHeaderToRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 13 -> new IllegalStateException(string);
        };
    }

    static enum TokenInfo {
        OPTION,
        OPTION_WITH_ARGUMENT,
        UNKNOWN_OPTION,
        TOKEN_WITHOUT_OPTION;

    }
}

