/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.httpClient.http.request.run.console.HttpClientOutputPrinter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpClientTestUtil {
    private static final List<String> FROM = List.of("|", "'", "\n", "\r", "]", "[");
    private static final List<String> TO = List.of("||", "|'", "|n", "|r", "|]", "|[");
    private static final String DEFAULT_NAME = "undefined";

    public static void printSuiteStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, int size) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(1);
        }
        HttpClientTestUtil.printSuiteStart(printer2, name, size, null);
    }

    public static void printSuiteStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, int size, @Nullable String locationHint) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(3);
        }
        printer2.print(HttpClientTestUtil.makeMessage("testCount", Pair.create((Object)"count", (Object)Integer.toString(size))));
        ServiceMessageBuilder builder = ServiceMessageBuilder.testSuiteStarted((String)StringUtil.notNullize((String)name, (String)DEFAULT_NAME));
        if (locationHint != null) {
            builder.addAttribute("locationHint", locationHint);
        }
        printer2.print(builder.toString() + "\n");
    }

    public static void printSuiteEnd(@NotNull HttpClientOutputPrinter printer2, @NotNull String name) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(5);
        }
        printer2.print(HttpClientTestUtil.makeMessage("testSuiteFinished", Pair.create((Object)"name", (Object)StringUtil.notNullize((String)name, (String)DEFAULT_NAME))));
    }

    public static void printTestStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String name) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(7);
        }
        HttpClientTestUtil.printTestStart(printer2, name, null);
    }

    public static void printTestStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, @Nullable String locationHint) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(9);
        }
        ServiceMessageBuilder builder = ServiceMessageBuilder.testStarted((String)name);
        if (locationHint != null) {
            builder.addAttribute("locationHint", locationHint);
        }
        printer2.print(builder.toString() + "\n");
    }

    public static void printTestEnd(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, long duration) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(11);
        }
        printer2.print(HttpClientTestUtil.makeMessage("testFinished", Pair.create((Object)"name", (Object)name), Pair.create((Object)"duration", (Object)Long.toString(duration))));
    }

    public static void printTestFailed(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, @Nullable String message) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(13);
        }
        printer2.print(HttpClientTestUtil.makeMessage("testFailed", Pair.create((Object)"name", (Object)name), StringUtil.isNotEmpty((String)message) ? Pair.create((Object)"message", (Object)message) : null));
    }

    public static void printTestIgnored(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, @Nullable String message) {
        if (printer2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            HttpClientTestUtil.$$$reportNull$$$0(15);
        }
        printer2.print(HttpClientTestUtil.makeMessage("testIgnored", Pair.create((Object)"name", (Object)name), StringUtil.isNotEmpty((String)message) ? Pair.create((Object)"message", (Object)message) : null));
    }

    @NotNull
    private static String makeMessage(@NotNull String type, Pair<String, String> ... parameters) {
        if (type == null) {
            HttpClientTestUtil.$$$reportNull$$$0(16);
        }
        if (parameters == null) {
            HttpClientTestUtil.$$$reportNull$$$0(17);
        }
        StringBuilder stringBuilder = new StringBuilder("##teamcity[");
        stringBuilder.append(type);
        for (Pair<String, String> entry : parameters) {
            if (entry == null) continue;
            stringBuilder.append(String.format(" %s='%s'", entry.first, HttpClientTestUtil.escape((String)entry.second)));
        }
        stringBuilder.append("]\n");
        String string = stringBuilder.toString();
        if (string == null) {
            HttpClientTestUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String escape(@NotNull String text2) {
        if (text2 == null) {
            HttpClientTestUtil.$$$reportNull$$$0(19);
        }
        String string = StringUtil.replace((String)text2, FROM, TO);
        if (string == null) {
            HttpClientTestUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/test/HttpClientTestUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/test/HttpClientTestUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMessage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "printSuiteStart";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printSuiteEnd";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printTestStart";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printTestEnd";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printTestFailed";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printTestIgnored";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeMessage";
                break;
            }
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 20 -> new IllegalStateException(string);
        };
    }
}

