/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.SybaseIntermediateSession;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.jetbrains.annotations.NotNull;

public class SybaseIntermediateFacade
extends JdbcIntermediateFacade {
    private boolean isNativeDriver;

    public SybaseIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull JdbcHelperImpl helper) {
        if (dataSource == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(dataSource, exceptionRecognizer, helper);
    }

    @Override
    protected void handleConnection(Connection connection) {
        super.handleConnection(connection);
        try {
            DatabaseMetaData md = connection.getMetaData();
            String driverName = md.getDriverName();
            this.isNativeDriver = driverName != null && driverName.startsWith("jConnect");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    protected SybaseIntermediateSession instantiateSession(@NotNull Connection connection) {
        if (connection == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(3);
        }
        return new SybaseIntermediateSession(this, this.myExceptionRecognizer, connection);
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        return this.getConnectionInfoSmartly("select db_name(), user_name(), suser_name()");
    }

    @Override
    public boolean useLabels() {
        return this.isNativeDriver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/SybaseIntermediateFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiateSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

