/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlScript {
    @NotNull
    private final SqlStatement[] myStatements;
    private final int myCount;

    public SqlScript(String ... statements) {
        if (statements == null) {
            SqlScript.$$$reportNull$$$0(0);
        }
        this(SqlScript.makeStatementsFromStrings(statements));
    }

    @NotNull
    private static SqlStatement[] makeStatementsFromStrings(@NotNull String[] statements) {
        if (statements == null) {
            SqlScript.$$$reportNull$$$0(1);
        }
        int n = statements.length;
        SqlStatement[] r = new SqlStatement[n];
        for (int i = 0; i < n; ++i) {
            r[i] = new SqlCommand(statements[i]);
        }
        if (r == null) {
            SqlScript.$$$reportNull$$$0(2);
        }
        return r;
    }

    public SqlScript(SqlStatement ... statements) {
        if (statements == null) {
            SqlScript.$$$reportNull$$$0(3);
        }
        this(statements, true);
    }

    public SqlScript(SqlScript ... scripts) {
        if (scripts == null) {
            SqlScript.$$$reportNull$$$0(4);
        }
        this(SqlScript.joinStatements(scripts));
    }

    private static List<SqlStatement> joinStatements(SqlScript[] scripts) {
        ArrayList<SqlStatement> b = new ArrayList<SqlStatement>();
        for (SqlScript script : scripts) {
            b.addAll(script.getStatements());
        }
        return b;
    }

    public SqlScript(@NotNull Collection<? extends SqlStatement> statements) {
        if (statements == null) {
            SqlScript.$$$reportNull$$$0(5);
        }
        this(statements.toArray(new SqlStatement[statements.size()]), false);
    }

    private SqlScript(@NotNull SqlStatement[] statements, boolean copy) {
        if (statements == null) {
            SqlScript.$$$reportNull$$$0(6);
        }
        int n = statements.length;
        if (copy) {
            this.myStatements = new SqlStatement[n];
            System.arraycopy(statements, 0, this.myStatements, 0, n);
        } else {
            this.myStatements = statements;
        }
        this.myCount = n;
    }

    @NotNull
    public List<? extends SqlStatement> getStatements() {
        List<SqlStatement> list = Collections.unmodifiableList(Arrays.asList(this.myStatements));
        if (list == null) {
            SqlScript.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean hasStatements() {
        return this.myCount > 0;
    }

    public int count() {
        return this.myCount;
    }

    @NotNull
    public String toString() {
        switch (this.myCount) {
            case 0: {
                return "";
            }
            case 1: {
                String string = this.myStatements[0].getSourceText();
                if (string == null) {
                    SqlScript.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        StringBuilder b = new StringBuilder();
        String delimiterString = this.getScriptDelimiterString();
        b.append(this.myStatements[0].getSourceText());
        for (int i = 1; i < this.myCount; ++i) {
            if (b.charAt(b.length() - 1) != '\n') {
                b.append('\n');
            }
            b.append(delimiterString).append('\n');
            b.append(this.myStatements[i].getSourceText());
        }
        String string = b.toString();
        if (string == null) {
            SqlScript.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String getScriptDelimiterString() {
        return ";";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/SqlScript";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/SqlScript";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStatementsFromStrings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "makeStatementsFromStrings";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

