/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.CassandraExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.CassandraIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.cassandra.RemoteCassConnectionImpl;
import com.intellij.util.ArrayUtilRt;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CassJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> TYPES_WITHOUT_CODEC = new HashSet<String>();
    private final boolean myIsIngDriver;

    public CassJdbcHelper(@Nullable String version, @Nullable Connection connection, boolean isIngDriver, @Nullable ClassLoader jdbcClassLoader) {
        super("CASSANDRA", version, connection, jdbcClassLoader);
        this.myIsIngDriver = isIngDriver;
    }

    public CassJdbcHelper() {
        this(null, null, false, null);
    }

    private CassJdbcHelper(@NotNull CassJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            CassJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            CassJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
        this.myIsIngDriver = helper.myIsIngDriver;
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CassJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new CassJdbcHelper(version, connection, CassJdbcHelper.isIngDriver(connection), jdbcClassLoader);
    }

    private static boolean isIngDriver(@Nullable Connection connection) {
        return connection != null && connection.getClass().getName().equals("com.ing.data.cassandra.jdbc.CassandraConnection");
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            CassJdbcHelper.$$$reportNull$$$0(2);
        }
        return new CassandraIntermediateFacade(ds, CassandraExceptionRecognizer.INSTANCE, this);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CassJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CassJdbcHelper.$$$reportNull$$$0(4);
        }
        statement.setTime(idx, time);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Cassandra")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CassJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select release_version from system.local");
        JdbcNativeUtil.logInfo("release_version: " + versionStr);
        return new CassJdbcHelper(CassJdbcHelper.extractVersion(versionStr), delegate, CassJdbcHelper.isIngDriver(delegate), jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.NONE;
    }

    @Override
    public boolean getAutoCommit(Connection delegate) {
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public RemoteConnection wrap(Connection connection) {
        return new RemoteCassConnectionImpl(connection, this, this.myIsIngDriver);
    }

    @Override
    public int fixUpdateCount(int update) {
        if (update == 0) {
            return -2;
        }
        return update;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            CassJdbcHelper.$$$reportNull$$$0(5);
        }
        return new CassJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        String stringValue;
        if (exporter == null) {
            CassJdbcHelper.$$$reportNull$$$0(6);
        }
        if (o == null) {
            return null;
        }
        if (o.getClass().getName().equals("com.datastax.driver.core.UDTValue")) {
            return new CassUdtValueWrapper(o.toString());
        }
        if (o.getClass().getName().equals("com.datastax.oss.driver.internal.core.data.DefaultUdtValue")) {
            String stringValue2 = this.udtValueToString(o);
            if (stringValue2 != null) {
                return new CassUdtValueWrapper(stringValue2);
            }
        } else if (o.getClass().getName().equals("com.datastax.oss.driver.internal.core.data.DefaultTupleValue") && (stringValue = this.tupleValueToString(o)) != null) {
            return new CassTupleValueWrapper(stringValue);
        }
        return super.wrapIfNeeded(exporter, o, null);
    }

    @Nullable
    private String udtValueToString(Object value) {
        return (String)ReflectionHelper.tryInvokeStaticMethod(this.getJdbcClassLoader(), "com.intellij.database.remote.jdbc.CassShim", "udtValueToString", new Class[]{Object.class}, new Object[]{value});
    }

    @Nullable
    private String tupleValueToString(Object value) {
        return (String)ReflectionHelper.tryInvokeStaticMethod(this.getJdbcClassLoader(), "com.intellij.database.remote.jdbc.CassShim", "tupleValueToString", new Class[]{Object.class}, new Object[]{value});
    }

    public static String toValidLiteral(Object object) {
        if (object instanceof Set) {
            StringBuilder sb = new StringBuilder("{");
            boolean first = true;
            for (Object value : (Set)object) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(value));
            }
            return sb.append("}").toString();
        }
        if (object instanceof Map) {
            StringBuilder sb = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry e : ((Map)object).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(e.getKey())).append(": ").append(CassJdbcHelper.toValidLiteral(e.getValue()));
            }
            return sb.append("}").toString();
        }
        if (object instanceof List) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Object value : (List)object) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(value));
            }
            return sb.append("]").toString();
        }
        if (object instanceof String) {
            return CassJdbcHelper.quote((String)object);
        }
        return object.toString();
    }

    private static String quote(String string) {
        return "'" + string.replaceAll("'", "''") + "'";
    }

    public static boolean hasCodec(@NotNull String typeName) {
        if (typeName == null) {
            CassJdbcHelper.$$$reportNull$$$0(7);
        }
        return !TYPES_WITHOUT_CODEC.contains(typeName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CassJdbcHelper.$$$reportNull$$$0(8);
        }
        return CassJdbcHelper.classNameContains(driver, "Cassandra");
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_CA};
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            CassJdbcHelper.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            CassJdbcHelper.$$$reportNull$$$0(10);
        }
        if (sslMode == null) {
            CassJdbcHelper.$$$reportNull$$$0(11);
        }
        properties.setProperty("sslenabled", "true");
        CassJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", sslMode == JdbcSettings.SslMode.REQUIRE ? "false" : "true");
    }

    @Override
    public JdbcHelperImpl.ExceptionProcessor createExceptionProcessor() {
        return new JdbcHelperImpl.ExceptionProcessor(){

            @Override
            @Nullable
            protected Throwable wrapExceptionStep(@NotNull Throwable ex) {
                Throwable res;
                if (ex == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((res = super.wrapExceptionStep(ex)) != null) {
                    for (Throwable sup : this.extractSuppressed(ex)) {
                        Throwable ws = this.wrapException(sup);
                        if (ws == null) continue;
                        res.addSuppressed(ws);
                    }
                }
                return res;
            }

            @NotNull
            private Iterable<Throwable> extractSuppressed(@NotNull Throwable ex) {
                Map errors;
                if (ex == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ex.getClass().getName().equals("com.datastax.driver.core.exceptions.NoHostAvailableException") && (errors = (Map)ReflectionHelper.tryInvokeMethod(ex, "getErrors", ArrayUtilRt.EMPTY_CLASS_ARRAY, ArrayUtilRt.EMPTY_OBJECT_ARRAY)) != null) {
                    Collection<Throwable> collection = errors.values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return collection;
                }
                List<Throwable> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ex";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/CassJdbcHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CassJdbcHelper$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extractSuppressed";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "wrapExceptionStep";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "extractSuppressed";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static {
        TYPES_WITHOUT_CODEC.add("set");
        TYPES_WITHOUT_CODEC.add("map");
        TYPES_WITHOUT_CODEC.add("list");
        TYPES_WITHOUT_CODEC.add("tuple");
        TYPES_WITHOUT_CODEC.add("udt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CassJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setTime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCodec";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CassUdtValueWrapper
    implements Serializable {
        final String myValue;

        CassUdtValueWrapper(String value) {
            this.myValue = value;
        }

        public String toString() {
            return this.myValue;
        }
    }

    private static class CassTupleValueWrapper
    implements Serializable {
        final String myValue;

        CassTupleValueWrapper(String value) {
            this.myValue = value;
        }

        public String toString() {
            return this.myValue;
        }
    }
}

