/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.remote.NodeJSCreateRemoteSdkForm;
import com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManager;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateRemoteNodeJSInterpreterDialog
extends DialogWrapper
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance(CreateRemoteNodeJSInterpreterDialog.class);
    private final Project myProject;
    private NodeJSCreateRemoteSdkForm myForm;
    private final List<String> myExistingSdkHomePaths;
    private NodeJSRemoteSdkAdditionalData myData;
    private SemVer myVersion;

    public CreateRemoteNodeJSInterpreterDialog(@NotNull Project project) {
        if (project == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myProject = project;
        this.myExistingSdkHomePaths = new ArrayList<String>();
        this.setTitle(NodeJSBundle.message((String)"dialog.title.configure.node.js.remote.interpreter", (Object[])new Object[0]));
        this.init();
    }

    public void setExistingSdks(@NotNull List<NodeJsRemoteInterpreter> existingInterpreters) {
        if (existingInterpreters == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(1);
        }
        this.myExistingSdkHomePaths.addAll(ContainerUtil.map(existingInterpreters, NodeJsRemoteInterpreter::getRemoteUrl));
    }

    public boolean reset(@NotNull NodeJSRemoteSdkAdditionalData data) {
        NodeJSCreateRemoteSdkForm form;
        if (data == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(2);
        }
        if (!(form = this.getForm()).isConnectionTypeSupported(data.getRemoteConnectionType())) {
            return false;
        }
        form.init(data);
        return true;
    }

    protected void doOKAction() {
        String validationError = this.myForm.getValidationError();
        if (!StringUtil.isEmptyOrSpaces((String)validationError)) {
            CreateRemoteNodeJSInterpreterDialog.validationFailed(validationError);
            return;
        }
        String message = null;
        boolean useRemoteCredentials = SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)this.getForm().createSdkDataInner());
        if (useRemoteCredentials) {
            message = this.validateUsingRemoteSdkCredentials(this.myProject, this.getForm());
        } else {
            this.getForm().updateHelpersPath(".webstorm_nodejs_helpers");
        }
        if (message != null) {
            CreateRemoteNodeJSInterpreterDialog.validationFailed(message);
            return;
        }
        try {
            this.myData = (NodeJSRemoteSdkAdditionalData)this.getForm().createSdkData();
        }
        catch (RemoteSdkException e) {
            CreateRemoteNodeJSInterpreterDialog.validationFailed(e.getMessage());
            LOG.debug("Error creating SDK data", (Throwable)e);
            return;
        }
        if (useRemoteCredentials) {
            if (this.myVersion == null) {
                CreateRemoteNodeJSInterpreterDialog.validationFailed(NodeJSBundle.message((String)"remote.interpreter.version.detection.cancelled.dialog.message", (Object[])new Object[0]));
                return;
            }
            this.myData.setVersionString(this.myVersion.getRawVersion());
        }
        for (String existing : this.myExistingSdkHomePaths) {
            if (!StringUtil.equals((CharSequence)existing, (CharSequence)this.myData.getSdkId())) continue;
            CreateRemoteNodeJSInterpreterDialog.validationFailed(NodeJSBundle.message((String)"remote.interpreter.same.interpreter.already.exists.dialog.message", (Object[])new Object[]{existing}));
            this.myData = null;
            return;
        }
        super.doOKAction();
    }

    @Nls
    private String validateUsingRemoteSdkCredentials(@NotNull Project project, @NotNull NodeJSCreateRemoteSdkForm form) {
        if (project == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(3);
        }
        if (form == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(4);
        }
        try {
            NodeJSRemoteSdkAdditionalData sdkData = (NodeJSRemoteSdkAdditionalData)form.createSdkData();
            RemoteCredentials credentials = sdkData.getRemoteCredentials(project, true);
            String title = NodeJSBundle.message((String)"node.remote.connecting.to.remote.host.title", (Object[])new Object[]{credentials.getHost()});
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteCredentials)credentials, (RemoteSdkProperties)sdkData, (String)title, sdkProperties -> form.updateModifiedValues(sdkProperties))) {
                return NodeJSBundle.message((String)"remote.interpreter.cannot.connect.to.remote.host.title.message", (Object[])new Object[0]);
            }
            AtomicReference<String> error = new AtomicReference<String>();
            if (!this.detectVersionInBackground(project, credentials, (RemoteSdkProperties)sdkData, error)) {
                return NodeJSBundle.message((String)"remote.interpreter.version.detection.cancelled.dialog.message", (Object[])new Object[0]);
            }
            String message = error.get();
            if (message != null) {
                return message;
            }
        }
        catch (ProcessCanceledException | RemoteCancelledException e) {
            return NodeJSBundle.message((String)"remote.interpreter.connection.cancelled", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            @NlsSafe String message = ExceptionUtil.getMessage((Throwable)e);
            return message;
        }
        return null;
    }

    private boolean detectVersionInBackground(Project project, RemoteCredentials credentials, RemoteSdkProperties sdkProperties, AtomicReference<@Nls String> error) {
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            try {
                this.myVersion = manager.getNodeVersion(project, credentials, sdkProperties);
            }
            catch (RemoteSdkException | InterruptedException e) {
                LOG.info(e);
                @NlsSafe String message = ExceptionUtil.getMessage((Throwable)e);
                error.set(message);
            }
        }, NodeJSBundle.message((String)"progress.title.detect.interpreter.version", (Object[])new Object[0]), true, this.myProject);
    }

    public NodeJSRemoteSdkAdditionalData getData() {
        return this.myData;
    }

    private static void validationFailed(@NlsContexts.DialogMessage String validation) {
        if (StringUtil.isEmpty((String)validation)) {
            validation = NodeJSBundle.message((String)"remote.interpreter.communication.error.dialog.message", (Object[])new Object[0]);
        }
        Messages.showErrorDialog((String)validation, (String)NodeJSBundle.message((String)"dialog.title.can.t.create.node.js.remote.interpreter", (Object[])new Object[0]));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)((Object)this.getForm()), "Center");
        return result;
    }

    @NotNull
    private NodeJSCreateRemoteSdkForm getForm() {
        if (this.myForm == null) {
            this.myForm = new NodeJSCreateRemoteSdkForm(this.myProject, this);
        }
        NodeJSCreateRemoteSdkForm nodeJSCreateRemoteSdkForm = this.myForm;
        if (nodeJSCreateRemoteSdkForm == null) {
            CreateRemoteNodeJSInterpreterDialog.$$$reportNull$$$0(5);
        }
        return nodeJSCreateRemoteSdkForm;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getForm().getPreferredFocusedComponent();
    }

    public void updateSize() {
        this.pack();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getForm().validateRemoteInterpreter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingInterpreters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/CreateRemoteNodeJSInterpreterDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/CreateRemoteNodeJSInterpreterDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExistingSdks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateUsingRemoteSdkCredentials";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

