/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbImplUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/autoconfig/DataSourceIdentifier;", "", "host", "", "port", "file", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "getFile", "getPath", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.database.impl"})
final class DataSourceIdentifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String host;
    @Nullable
    private final String port;
    @Nullable
    private final String file;
    @Nullable
    private final String path;

    public DataSourceIdentifier(@Nullable String host, @Nullable String port, @Nullable String file, @Nullable String path) {
        this.host = host;
        this.port = port;
        this.file = file;
        this.path = path;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final String getPort() {
        return this.port;
    }

    @Nullable
    public final String getFile() {
        return this.file;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String component1() {
        return this.host;
    }

    @Nullable
    public final String component2() {
        return this.port;
    }

    @Nullable
    public final String component3() {
        return this.file;
    }

    @Nullable
    public final String component4() {
        return this.path;
    }

    @NotNull
    public final DataSourceIdentifier copy(@Nullable String host, @Nullable String port, @Nullable String file, @Nullable String path) {
        return new DataSourceIdentifier(host, port, file, path);
    }

    public static /* synthetic */ DataSourceIdentifier copy$default(DataSourceIdentifier dataSourceIdentifier, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = dataSourceIdentifier.host;
        }
        if ((n & 2) != 0) {
            string2 = dataSourceIdentifier.port;
        }
        if ((n & 4) != 0) {
            string3 = dataSourceIdentifier.file;
        }
        if ((n & 8) != 0) {
            string4 = dataSourceIdentifier.path;
        }
        return dataSourceIdentifier.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "DataSourceIdentifier(host=" + this.host + ", port=" + this.port + ", file=" + this.file + ", path=" + this.path + ")";
    }

    public int hashCode() {
        int result = this.host == null ? 0 : this.host.hashCode();
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.file == null ? 0 : this.file.hashCode());
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataSourceIdentifier)) {
            return false;
        }
        DataSourceIdentifier dataSourceIdentifier = (DataSourceIdentifier)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)dataSourceIdentifier.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)dataSourceIdentifier.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)dataSourceIdentifier.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)dataSourceIdentifier.path);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/autoconfig/DataSourceIdentifier$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/database/autoconfig/DataSourceIdentifier;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DataSourceIdentifier of(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            String string = dataSource.getUrl();
            if (string == null) {
                return null;
            }
            String url = string;
            DatabaseDriver databaseDriver = DbImplUtilCore.guessDatabaseDriver((RawConnectionConfig)((RawConnectionConfig)dataSource));
            if (databaseDriver == null) {
                return null;
            }
            DatabaseDriver driver = databaseDriver;
            List list = driver.getJDBCUrlParsers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJDBCUrlParsers(...)");
            List parsers = list;
            StatelessJdbcUrlParser parser2 = JdbcUrlParserUtil.select((Collection)parsers, (String)url);
            JdbcUrlParser jdbcUrlParser = JdbcUrlParserUtil.parsed((StatelessJdbcUrlParser)parser2, (String)url);
            if (jdbcUrlParser == null) {
                return null;
            }
            JdbcUrlParser parsed = jdbcUrlParser;
            return new DataSourceIdentifier(parsed.getParameter("host"), parsed.getParameter("port"), parsed.getParameter("file"), parsed.getParameter("path"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

