/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.ReboundNotPossibleException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionManagerKt;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SimpleDatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncTaskKt;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.ProcessKt;
import com.intellij.util.messages.Topic;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0006'()*+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u00060\fR\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J@\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162 \u0010\u0017\u001a\u001c\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0019\u0012\u000e\b\u0001\u0012\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b0\u0018J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010%\u001a\u0004\u0018\u00010&R\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs$annotations", "()V", "myConnections", "", "Lcom/intellij/database/dataSource/DatabaseConnection;", "build", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "useDriver", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "user", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/remote/jdbc/RemoteDriver;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "releaseConnection", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "connection", "activeConnections", "", "getActiveConnections", "()Ljava/util/List;", "terminateConnections", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "Listener", "Operation", "ConnectInterceptor", "Builder", "Executor", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,422:1\n774#2:423\n865#2,2:424\n*S KotlinDebug\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager\n*L\n345#1:423\n345#1:424,2\n*E\n"})
public final class DatabaseConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Set<DatabaseConnection> myConnections;
    @NotNull
    private static final Topic<Listener> TOPIC;

    public DatabaseConnectionManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentIdentitySet(...)");
        this.myConnections = set;
    }

    @Deprecated(message="Provide your own")
    private static /* synthetic */ void getCs$annotations() {
    }

    @NotNull
    public final Builder build(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return new Builder(project, connectionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void useDriver(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentialsStore, @NotNull ThrowableConsumer<? super RemoteDriver, ? extends Exception> user) throws Exception {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)credentialsStore, (String)"credentialsStore");
        Intrinsics.checkNotNullParameter(user, (String)"user");
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        ConsoleRunConfiguration consoleRunConfiguration = driverManager.getDefaultRunConfiguration(dataSource, credentialsStore);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration), (String)"getDefaultRunConfiguration(...)");
        ConsoleRunConfiguration configuration = consoleRunConfiguration;
        RemoteDriver driver = driverManager.getDriver(dataSource, configuration);
        try {
            user.consume((Object)driver);
        }
        finally {
            Intrinsics.checkNotNull((Object)((Object)driverManager));
            DatabaseConnectionManager.Companion.releaseDriver(driverManager, dataSource, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseConnection(JdbcDriverManager driverManager, DatabaseConnection connection2) {
        this.myConnections.remove(connection2);
        try {
            DatabaseConnectionManager.Companion.releaseConnectionInner(driverManager, connection2);
        }
        finally {
            DatabaseConnectionManager.Companion.connectionChanged(connection2, false);
        }
    }

    @NotNull
    public final List<DatabaseConnection> getActiveConnections() {
        return new ArrayList(this.myConnections);
    }

    /*
     * WARNING - void declaration
     */
    public final void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Iterable $this$filter$iv = this.myConnections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseConnection it = (DatabaseConnection)element$iv$iv;
            boolean bl = false;
            if (!(it.getConnectionPoint().getDataSource() == dataSource && (configuration == null || it.getConfiguration() == configuration))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toTerminate = (List)destination$iv$iv;
        for (DatabaseConnection connection2 : toTerminate) {
            Intrinsics.checkNotNull((Object)connection2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.SimpleDatabaseConnection");
            ((SimpleDatabaseConnection)connection2).cancelAll();
        }
    }

    @NotNull
    public static final Topic<Listener> getTOPIC() {
        return Companion.getTOPIC();
    }

    @JvmStatic
    @NotNull
    public static final DatabaseConnectionManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @TestOnly
    public static final void setInterceptor(@NotNull Disposable disposable, @Nullable ConnectInterceptor interceptor) {
        Companion.setInterceptor(disposable, interceptor);
    }

    @JvmStatic
    @NotNull
    public static final ErrorInfo getConnectionErrorInfo(@NotNull Throwable e, @NotNull LocalDataSource dataSource) {
        return Companion.getConnectionErrorInfo(e, dataSource);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final Object establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword, @NotNull Continuation<? super DatabaseConnection> $completion) {
        return Companion.establishConnection(connectionPoint, runConfiguration, requestor, project, askPassword, $completion);
    }

    public static final /* synthetic */ Set access$getMyConnections$p(DatabaseConnectionManager $this) {
        return $this.myConnections;
    }

    static {
        Topic topic = Topic.create((String)"DatabaseConnectionManager.Listener", Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001b\u001a\u00060\u0000R\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010\u001f\u001a\u00060\u0000R\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0014\u0010 \u001a\u00060\u0000R\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u0014J\u0014\u0010$\u001a\u00060\u0000R\u00020\u001c2\b\u0010%\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010&\u001a\u00060\u0000R\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0015J0\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H)0-2\u0006\u0010.\u001a\u00020/J@\u0010'\u001a\u0002H)\"\u0004\b\u0000\u0010)2\u0006\u0010.\u001a\u00020/2\"\u0010,\u001a\u001e\b\u0001\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)02\u0012\u0006\u0012\u0004\u0018\u00010\u000100H\u0086@\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\n\u0012\u0004\u0012\u000201\u0018\u000105H\u0007J\u000e\u00106\u001a\n\u0012\u0004\u0012\u000201\u0018\u000105J\u0016\u00107\u001a\n\u0012\u0004\u0012\u000201\u0018\u000105H\u0086@\u00a2\u0006\u0002\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00069"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionManager;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "setConnectionPoint", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "value", "", "askPassword", "getAskPassword", "()Z", "myRunConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "requestor", "getRequestor", "()Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "myCredentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "setDestination", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "path", "Lcom/intellij/database/util/ObjectPath;", "setAskPassword", "setRunConfiguration", "runConfiguration", "getRunConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "setCredentialsStore", "credentialsStore", "setRequestor", "async", "Lcom/intellij/database/util/AsyncTask;", "T", "context", "Lkotlin/coroutines/CoroutineContext;", "user", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Operation;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "Lkotlin/Function2;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lkotlin/coroutines/Continuation;", "(Lcom/intellij/database/util/ErrorHandler;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBlockingNonCancellable", "Lcom/intellij/database/util/GuardedRef;", "createBlocking", "create", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    public final class Builder {
        @NotNull
        private final Project project;
        @NotNull
        private DatabaseConnectionPoint connectionPoint;
        private boolean askPassword;
        @Nullable
        private ConsoleRunConfiguration myRunConfiguration;
        @Nullable
        private ConnectionRequestor requestor;
        @Nullable
        private DatabaseCredentials myCredentialsStore;

        public Builder(@NotNull Project project, DatabaseConnectionPoint connectionPoint) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            this.project = project;
            this.connectionPoint = connectionPoint;
            this.askPassword = true;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final DatabaseConnectionPoint getConnectionPoint() {
            return this.connectionPoint;
        }

        public final void setConnectionPoint(@NotNull DatabaseConnectionPoint databaseConnectionPoint) {
            Intrinsics.checkNotNullParameter((Object)databaseConnectionPoint, (String)"<set-?>");
            this.connectionPoint = databaseConnectionPoint;
        }

        public final boolean getAskPassword() {
            return this.askPassword;
        }

        @Nullable
        public final ConnectionRequestor getRequestor() {
            return this.requestor;
        }

        @NotNull
        public final Builder setDestination(@Nullable ObjectPath path) {
            if (path != null) {
                DatabaseConnectionPoint rebound = JdbcUrlParserUtil.connectedTo((DatabaseConnectionPoint)this.connectionPoint, (ObjectPath)path);
                if (rebound == null) {
                    throw new ReboundNotPossibleException(path);
                }
                this.connectionPoint = rebound;
            }
            return this;
        }

        @NotNull
        public final Builder setAskPassword(boolean askPassword) {
            this.askPassword = askPassword;
            return this;
        }

        @NotNull
        public final Builder setRunConfiguration(@Nullable ConsoleRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
            return this;
        }

        @NotNull
        public final ConsoleRunConfiguration getRunConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration;
            if (this.myRunConfiguration == null) {
                ConsoleRunConfiguration consoleRunConfiguration2 = JdbcDriverManager.getDriverManager(this.project).getDefaultRunConfiguration(this.connectionPoint.getDataSource(), this.myCredentialsStore);
                consoleRunConfiguration = consoleRunConfiguration2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration2), (String)"getDefaultRunConfiguration(...)");
            } else {
                ConsoleRunConfiguration consoleRunConfiguration3 = this.myRunConfiguration;
                consoleRunConfiguration = consoleRunConfiguration3;
                Intrinsics.checkNotNull((Object)((Object)consoleRunConfiguration3));
            }
            return consoleRunConfiguration;
        }

        @NotNull
        public final Builder setCredentialsStore(@Nullable DatabaseCredentials credentialsStore) {
            this.myCredentialsStore = credentialsStore;
            return this;
        }

        @NotNull
        public final Builder setRequestor(@NotNull ConnectionRequestor requestor) {
            Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
            this.requestor = requestor;
            return this;
        }

        @NotNull
        public final <T> AsyncTask<T> async(@NotNull CoroutineContext context, @NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            return AsyncTask.Companion.currentFrame().asAsyncTask(context.plus((CoroutineContext)new CoroutineName("DatabaseConnectionManager.async")), new Function2<CoroutineScope, Continuation<? super T>, Object>(this, errorHandler, user, null){
                int label;
                final /* synthetic */ Builder this$0;
                final /* synthetic */ ErrorHandler $errorHandler;
                final /* synthetic */ Operation<T> $user;
                {
                    this.this$0 = $receiver;
                    this.$errorHandler = $errorHandler;
                    this.$user = $user;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.async(this.$errorHandler, (Function2)new Function2<DatabaseConnection, Continuation<? super T>, Object>(this.$user, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ Operation<T> $user;
                                {
                                    this.$user = $user;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    DatabaseConnection databaseConnection = (DatabaseConnection)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            return this.$user.perform((DatabaseConnection)it);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(DatabaseConnection p1, Continuation<? super T> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        @Nullable
        public final <T> Object async(@NotNull ErrorHandler errorHandler, @NotNull Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> user, @NotNull Continuation<? super T> $completion) {
            return new Executor(this).async(user, errorHandler, $completion);
        }

        @TestOnly
        @Nullable
        public final GuardedRef<DatabaseConnection> createBlockingNonCancellable() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AsyncTask.Companion.currentFrame().indicatorReporting((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ Builder this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final GuardedRef<DatabaseConnection> createBlocking() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AsyncTask.Companion.currentFrame().indicatorReporting((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ Builder this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final Object create(@NotNull Continuation<? super GuardedRef<DatabaseConnection>> $completion) throws SQLException {
            return new Executor(this).create($completion);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0087@\u00a2\u0006\u0002\u00100R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u00061"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Listener;", "getTOPIC$annotations", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "getInstance", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "setInterceptor", "", "disposable", "Lcom/intellij/openapi/Disposable;", "interceptor", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$ConnectInterceptor;", "getSpecialErrorInfo", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "t", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "releaseConnectionInner", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "releaseDriver", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConnectionErrorInfo", "e", "connectionChanged", "r", "added", "", "getTimeZone", "", "establishConnection", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "askPassword", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,422:1\n30#2,2:423\n1#3:425\n*S KotlinDebug\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager$Companion\n*L\n360#1:423,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        @JvmStatic
        public static /* synthetic */ void getTOPIC$annotations() {
        }

        @JvmStatic
        @NotNull
        public final DatabaseConnectionManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DatabaseConnectionManager> serviceClass$iv = DatabaseConnectionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseConnectionManager)object;
        }

        @JvmStatic
        @TestOnly
        public final void setInterceptor(@NotNull Disposable disposable, @Nullable ConnectInterceptor interceptor) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            ConnectInterceptor prev2 = DatabaseConnectionManagerKt.access$getOurInterceptor$p();
            boolean bl2 = bl = prev2 == null || interceptor == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Already have interceptor";
                throw new AssertionError((Object)string);
            }
            DatabaseConnectionManagerKt.access$setOurInterceptor$p(interceptor);
            Disposer.register((Disposable)disposable, () -> Companion.setInterceptor$lambda$1(prev2));
        }

        @NotNull
        public final ErrorInfo getSpecialErrorInfo(@NotNull Throwable t, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DatabaseErrorHandler handler2 = (DatabaseErrorHandler)DatabaseErrorHandler.EP.forDbms(dataSource.getDbms());
            ErrorInfo errorInfo = handler2.getErrorInfo(dataSource, t);
            Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"getErrorInfo(...)");
            return errorInfo;
        }

        private final void releaseConnectionInner(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNull((Object)connection2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.SimpleDatabaseConnection");
            RemoteConnection remoteConnection = ((SimpleDatabaseConnection)connection2).release();
            JdbcNativeUtil.performSafe(() -> Companion.releaseConnectionInner$lambda$2(remoteConnection));
            LocalDataSource localDataSource = ((SimpleDatabaseConnection)connection2).getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            this.releaseDriver(driverManager, localDataSource, ((SimpleDatabaseConnection)connection2).getConfiguration());
        }

        private final void releaseDriver(JdbcDriverManager driverManager, LocalDataSource dataSource, ConsoleRunConfiguration runConfiguration) {
            if (dataSource.isTemporary()) {
                driverManager.releaseDriver(dataSource, runConfiguration);
            }
        }

        @JvmStatic
        @NotNull
        public final ErrorInfo getConnectionErrorInfo(@NotNull Throwable e, @NotNull LocalDataSource dataSource) {
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (AsyncUtil.isCancellation((Throwable)e)) {
                AsyncUtil.rethrow((Throwable)e);
            }
            if (e instanceof CompletionException) {
                Throwable throwable2 = e.getCause();
                throwable = throwable2;
                Intrinsics.checkNotNull((Object)throwable2);
            } else {
                throwable = e;
            }
            Throwable ex = throwable;
            return this.getSpecialErrorInfo(ex, dataSource);
        }

        private final void connectionChanged(DatabaseConnection r, boolean added) {
            Application app = ApplicationManager.getApplication();
            app.invokeLater(() -> Companion.connectionChanged$lambda$3(app, r, added), ModalityState.any());
        }

        private final String getTimeZone(LocalDataSource dataSource) {
            String timeZone = dataSource.getTimeZone();
            CharSequence charSequence = timeZone;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : timeZone;
        }

        @JvmStatic
        @TestOnly
        @Nullable
        public final Object establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword, @NotNull Continuation<? super DatabaseConnection> $completion) {
            return DatabaseConnectionEstablisher.Companion.establishConnection(connectionPoint, runConfiguration, requestor, Companion::establishConnection$lambda$4, project, askPassword, $completion);
        }

        private static final void setInterceptor$lambda$1(ConnectInterceptor $prev) {
            DatabaseConnectionManagerKt.access$setOurInterceptor$p($prev);
        }

        private static final void releaseConnectionInner$lambda$2(RemoteConnection $remoteConnection) {
            $remoteConnection.close();
        }

        private static final void connectionChanged$lambda$3(Application $app, DatabaseConnection $r, boolean $added) {
            ((Listener)$app.getMessageBus().syncPublisher(Companion.getTOPIC())).connectionChanged($r, $added);
        }

        private static final void establishConnection$lambda$4(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)((Object)driverManager), (String)"driverManager");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Companion.releaseConnectionInner(driverManager, connection2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u00a6@\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$ConnectInterceptor;", "", "establishConnection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "askPassword", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    public static interface ConnectInterceptor {
        @Nullable
        public Object establishConnection(@NotNull DatabaseConnectionPoint var1, @NotNull ConsoleRunConfiguration var2, @NotNull ConnectionRequestor var3, @NotNull Project var4, boolean var5, @NotNull Continuation<? super DatabaseConnection> var6);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J@\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\"\u0010\u0013\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001bJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0015H\u0002JJ\u0010#\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\b\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\"\u0010%\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010(\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Executor;", "", "b", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionManager;Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;)V", "myProject", "Lcom/intellij/openapi/project/Project;", "myRunConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "myConnectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "myRequestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "myAskPassword", "", "async", "T", "user", "Lkotlin/Function2;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lkotlin/coroutines/Continuation;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "(Lkotlin/jvm/functions/Function2;Lcom/intellij/database/util/ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "create", "Lcom/intellij/database/util/GuardedRef;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBlocking", "release", "", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "ref", "perform", "connection", "op", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/util/ErrorHandler;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "supplyAsync", "establishConnectionAndPrepare", "prepareDatabaseConnection", "changeSessionTimeZone", "runInitializationScript", "establishConnection", "intellij.database.connectivity"})
    private final class Executor {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ConsoleRunConfiguration myRunConfiguration;
        @NotNull
        private final DatabaseConnectionPoint myConnectionPoint;
        @Nullable
        private final ConnectionRequestor myRequestor;
        private final boolean myAskPassword;

        public Executor(Builder b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.myProject = b.getProject();
            this.myRunConfiguration = b.getRunConfiguration();
            this.myConnectionPoint = b.getConnectionPoint();
            this.myRequestor = b.getRequestor();
            this.myAskPassword = b.getAskPassword();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final <T> Object async(@NotNull Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> user, @NotNull ErrorHandler errorHandler, @NotNull Continuation<? super T> $completion) {
            if (!($completion instanceof async.1)) ** GOTO lbl-1000
            var9_4 = $completion;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.async(null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    driverManager = JdbcDriverManager.getDriverManager(this.myProject);
                    $continuation.L$0 = user;
                    $continuation.L$1 = errorHandler;
                    $continuation.L$2 = driverManager;
                    $continuation.label = 1;
                    v0 = this.supplyAsync((Continuation<? super DatabaseConnection>)$continuation);
                    ** if (v0 != var10_6) goto lbl22
lbl21:
                    // 1 sources

                    return var10_6;
lbl22:
                    // 1 sources

                    ** GOTO lbl31
                }
                case 1: {
                    driverManager = (JdbcDriverManager)$continuation.L$2;
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    user = (Function2)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 2 sources

                        var6_10 = (DatabaseConnection)v0;
                    }
                    catch (Throwable th) {
                        if (!AsyncUtil.isCancellation((Throwable)th)) {
                            v1 = this.myConnectionPoint.getDataSource();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDataSource(...)");
                            errorHandler.add(DatabaseConnectionManager.Companion.getConnectionErrorInfo(th, v1), false);
                        }
                        Intrinsics.checkNotNull((Object)driverManager);
                        this.release(driverManager, null);
                        throw new CancellationException();
                    }
                    connection = var6_10;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)user);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)errorHandler);
                    $continuation.L$2 = driverManager;
                    $continuation.L$3 = connection;
                    $continuation.label = 2;
                    v2 = this.perform((DatabaseConnection)connection, errorHandler, (Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object>)user, (Continuation<? super T>)$continuation);
                    ** if (v2 != var10_6) goto lbl52
lbl51:
                    // 1 sources

                    return var10_6;
lbl52:
                    // 1 sources

                    ** GOTO lbl62
                }
                case 2: {
                    connection = (DatabaseConnection)$continuation.L$3;
                    driverManager = (JdbcDriverManager)$continuation.L$2;
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    user = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl62:
                    // 2 sources

                    var6_10 = v2;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)user);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)errorHandler);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)driverManager);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)connection);
                    $continuation.L$4 = var6_10;
                    $continuation.label = 3;
                    v3 = ProcessKt.computeDetached$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, driverManager, (DatabaseConnection)connection, null){
                        int label;
                        final /* synthetic */ Executor this$0;
                        final /* synthetic */ JdbcDriverManager $driverManager;
                        final /* synthetic */ DatabaseConnection $connection;
                        {
                            this.this$0 = $receiver;
                            this.$driverManager = $driverManager;
                            this.$connection = $connection;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    JdbcDriverManager jdbcDriverManager = this.$driverManager;
                                    Intrinsics.checkNotNull((Object)((Object)jdbcDriverManager));
                                    Executor.access$release(this.this$0, jdbcDriverManager, this.$connection);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), $continuation, (int)1, null);
                    if (v3 == var10_6) {
                        return var10_6;
                    }
                    break;
                }
                case 3: {
                    var6_10 = $continuation.L$4;
                    connection = (DatabaseConnection)$continuation.L$3;
                    driverManager = (JdbcDriverManager)$continuation.L$2;
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    user = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    break;
                }
            }
            catch (Throwable var7_12) {
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)errorHandler);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)driverManager);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)connection);
                $continuation.L$4 = var7_12;
                $continuation.label = 4;
                v4 = ProcessKt.computeDetached$default(null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), $continuation, (int)1, null);
                if (v4 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl101
            }
            {
                case 4: {
                    var7_13 = (Throwable)$continuation.L$4;
                    connection = (DatabaseConnection)$continuation.L$3;
                    driverManager = (JdbcDriverManager)$continuation.L$2;
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    user = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl101:
                    // 2 sources

                    throw var7_13;
                }
            }
            return var6_10;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object create(@NotNull Continuation<? super GuardedRef<DatabaseConnection>> $completion) {
            if (!($completion instanceof create.1)) ** GOTO lbl-1000
            var7_2 = $completion;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    driverManager = JdbcDriverManager.getDriverManager(this.myProject);
                    $continuation.L$0 = driverManager;
                    $continuation.label = 1;
                    v0 = this.supplyAsync((Continuation<? super DatabaseConnection>)$continuation);
                    ** if (v0 != var8_4) goto lbl20
lbl19:
                    // 1 sources

                    return var8_4;
lbl20:
                    // 1 sources

                    ** GOTO lbl27
                }
                case 1: {
                    driverManager = (JdbcDriverManager)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        if ((connection = (DatabaseConnection)v0) == null) {
                            Intrinsics.checkNotNull((Object)driverManager);
                            this.release(driverManager, null);
                            return null;
                        }
                        return new GuardedRef<DatabaseConnection>(connection, this, driverManager){
                            final /* synthetic */ Executor this$0;
                            final /* synthetic */ JdbcDriverManager $driverManager;
                            {
                                this.this$0 = $receiver;
                                this.$driverManager = $driverManager;
                                super((Object)$connection);
                            }

                            protected void close(DatabaseConnection ref2) {
                                Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                                JdbcDriverManager jdbcDriverManager = this.$driverManager;
                                Intrinsics.checkNotNull((Object)((Object)jdbcDriverManager));
                                Executor.access$release(this.this$0, jdbcDriverManager, ref2);
                            }
                        };
                    }
                    catch (Throwable e) {
                        Intrinsics.checkNotNull((Object)driverManager);
                        this.release(driverManager, null);
                        t = AsyncUtil.unwrap((Throwable)e);
                        if (t instanceof SQLException) {
                            throw t;
                        }
                        ExceptionUtil.rethrow((Throwable)t);
                        return null;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final GuardedRef<DatabaseConnection> createBlocking() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Executor this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void release(JdbcDriverManager driverManager, DatabaseConnection ref2) {
            if (ref2 != null) {
                DatabaseConnectionManager.this.releaseConnection(driverManager, ref2);
            } else {
                LocalDataSource localDataSource = this.myConnectionPoint.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                Companion.releaseDriver(driverManager, localDataSource, this.myRunConfiguration);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final <T> Object perform(DatabaseConnection connection, ErrorHandler errorHandler, Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> op, Continuation<? super T> $completion) {
            if (!($completion instanceof perform.1)) ** GOTO lbl-1000
            var9_5 = $completion;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Executor.access$perform(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (connection == null) {
                        errorHandler.addError(DatabaseBundle.message((String)"message.wrong.driver.specified", (Object[])new Object[0]), null);
                        throw new CancellationException();
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connection);
                    $continuation.L$1 = errorHandler;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)op);
                    $continuation.label = 1;
                    v0 = op.invoke((Object)connection, $continuation);
                    ** if (v0 != var10_7) goto lbl25
lbl24:
                    // 1 sources

                    return var10_7;
lbl25:
                    // 1 sources

                    ** GOTO lbl34
                }
                case 1: {
                    op = (Function2)$continuation.L$2;
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    connection = (DatabaseConnection)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 2 sources

                        return v0;
                    }
                    catch (CancellationException c) {
                        throw c;
                    }
                    catch (Exception e) {
                        if (!AsyncUtil.isCancellation((Throwable)e)) {
                            v1 = e;
                            v2 = this.myConnectionPoint.getDataSource();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDataSource(...)");
                            errorHandler.add(DatabaseConnectionManager.Companion.getSpecialErrorInfo(v1, v2));
                        }
                        v3 = e;
                        var7_11 = var6_10 = new CancellationException(v3 != null ? String.valueOf(v3) : null);
                        var7_11.initCause(e);
                        throw var6_10;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object supplyAsync(Continuation<? super DatabaseConnection> $completion) {
            String string = DatabaseBundle.message((String)"progress.text.connecting.to.database", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AsyncTaskKt.traceableFrame((String)string, (Function1)((Function1)new Function1<Continuation<? super DatabaseConnection>, Object>(this, DatabaseConnectionManager.this, null){
                int label;
                final /* synthetic */ Executor this$0;
                final /* synthetic */ DatabaseConnectionManager this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = Executor.access$establishConnectionAndPrepare(this.this$0, (Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (DatabaseConnection)v0;
                            if (v1 != null) {
                                var2_3 = v1;
                                var3_4 = this.this$1;
                                it = var2_3;
                                $i$a$-also-DatabaseConnectionManager$Executor$supplyAsync$2$1 = false;
                                DatabaseConnectionManager.access$getMyConnections$p(var3_4).add(it);
                                com.intellij.database.dataSource.DatabaseConnectionManager$Companion.access$connectionChanged(DatabaseConnectionManager.Companion, it, true);
                                v2 = var2_3;
                            } else {
                                v2 = null;
                            }
                            return v2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super DatabaseConnection> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final Object establishConnectionAndPrepare(Continuation<? super DatabaseConnection> $completion) {
            String string = DatabaseBundle.message((String)"progress.title.prepare.connection", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AsyncTaskKt.traceableFrame((String)string, (Function1)((Function1)new Function1<Continuation<? super DatabaseConnection>, Object>(this, null){
                int label;
                final /* synthetic */ Executor this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = Executor.access$establishConnection(this.this$0, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((connection = (DatabaseConnection)v0) != null) {
                                try {
                                    Executor.access$prepareDatabaseConnection(this.this$0, connection);
                                }
                                catch (Throwable th) {
                                    v1 = JdbcDriverManager.getDriverManager(Executor.access$getMyProject$p(this.this$0));
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDriverManager(...)");
                                    com.intellij.database.dataSource.DatabaseConnectionManager$Companion.access$releaseConnectionInner(DatabaseConnectionManager.Companion, v1, connection);
                                    throw new RuntimeException("Failed to prepare connection", th);
                                }
                            }
                            return connection;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super DatabaseConnection> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final void prepareDatabaseConnection(DatabaseConnection connection2) throws SQLException {
            DataSourceInfo.refreshDatabaseInfo((LocalDataSource)this.myConnectionPoint.getDataSource(), (DatabaseConnectionCore)connection2);
            this.changeSessionTimeZone(connection2);
            this.runInitializationScript(connection2);
        }

        private final void changeSessionTimeZone(DatabaseConnection connection2) {
            LocalDataSource localDataSource = this.myConnectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(dataSource.getDbms())).getTimeZoneManager();
            Intrinsics.checkNotNullExpressionValue((Object)timeZoneManager, (String)"getTimeZoneManager(...)");
            ExecutionEnvironmentHelper.TimeZoneManager helper = timeZoneManager;
            String tz = Companion.getTimeZone(dataSource);
            if (helper.canChange() && tz != null) {
                helper.changeTimeZone((DatabaseConnectionCore)connection2, tz);
            }
        }

        private final void runInitializationScript(DatabaseConnection connection2) throws SQLException {
            String initScript;
            String string = this.myConnectionPoint.getInitScript();
            if (string != null) {
                String string2;
                String it = string;
                boolean bl = false;
                try {
                    string2 = MacroManager.getInstance().expandSilentMacros(it, true, SimpleDataContext.getProjectContext((Project)this.myProject));
                }
                catch (Macro.ExecutionCancelledException e) {
                    string2 = it;
                }
                v1 = string2;
            } else {
                v1 = initScript = null;
            }
            if (StringUtil.isNotEmpty(initScript)) {
                String string3 = initScript;
                Intrinsics.checkNotNull((Object)string3);
                List list = DbSqlUtilCore.getQueries((String)string3, (Project)this.myProject, (Language)DbSqlUtilCore.getLanguage((LocalDataSource)this.myConnectionPoint.getDataSource()));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQueries(...)");
                List queries = list;
                BarrenStatement barren = SmartStatements.Companion.poweredBy(connection2).simple().barren();
                for (String query : queries) {
                    Intrinsics.checkNotNull((Object)query);
                    barren.execute((Object)query);
                }
            }
        }

        private final Object establishConnection(Continuation<? super DatabaseConnection> $completion) {
            ConnectionRequestor requestor;
            ConnectionRequestor connectionRequestor = this.myRequestor;
            if (connectionRequestor == null) {
                connectionRequestor = requestor = (ConnectionRequestor)new ConnectionRequestor.Anonymous();
            }
            if (DatabaseConnectionManagerKt.access$getOurInterceptor$p() != null) {
                ConnectInterceptor connectInterceptor = DatabaseConnectionManagerKt.access$getOurInterceptor$p();
                Intrinsics.checkNotNull((Object)connectInterceptor);
                return connectInterceptor.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, this.myProject, this.myAskPassword, $completion);
            }
            return DatabaseConnectionEstablisher.Companion.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, Executor::establishConnection$lambda$1, this.myProject, this.myAskPassword, $completion);
        }

        private static final void establishConnection$lambda$1(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)((Object)driverManager), (String)"driverManager");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Companion.releaseConnectionInner(driverManager, connection2);
        }

        public static final /* synthetic */ void access$release(Executor $this, JdbcDriverManager driverManager, DatabaseConnection ref2) {
            $this.release(driverManager, ref2);
        }

        public static final /* synthetic */ Object access$perform(Executor $this, DatabaseConnection connection2, ErrorHandler errorHandler, Function2 op, Continuation $completion) {
            return $this.perform(connection2, errorHandler, op, $completion);
        }

        public static final /* synthetic */ Object access$supplyAsync(Executor $this, Continuation $completion) {
            return $this.supplyAsync((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ Object access$establishConnectionAndPrepare(Executor $this, Continuation $completion) {
            return $this.establishConnectionAndPrepare((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ Object access$establishConnection(Executor $this, Continuation $completion) {
            return $this.establishConnection((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ void access$prepareDatabaseConnection(Executor $this, DatabaseConnection connection2) {
            $this.prepareDatabaseConnection(connection2);
        }

        public static final /* synthetic */ Project access$getMyProject$p(Executor $this) {
            return $this.myProject;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Listener;", "", "connectionChanged", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "added", "", "connectionFailed", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "th", "", "intellij.database.connectivity"})
    public static interface Listener {
        public void connectionChanged(@NotNull DatabaseConnection var1, boolean var2);

        default public void connectionFailed(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull Throwable th) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)th, (String)"th");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Operation;", "T", "", "perform", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/dataSource/DatabaseConnection;)Ljava/lang/Object;", "intellij.database.connectivity"})
    public static interface Operation<T> {
        public T perform(@NotNull DatabaseConnection var1) throws Exception;
    }
}

