/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.hsql.types.HsqlArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/hsql/types/HSqlTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getTypeCategoryByName", "typeName", "doCreateArrayType", "Lcom/intellij/database/dialects/hsql/types/HsqlArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "intellij.database.dialects.hsql"})
public final class HSqlTypeSystem
extends DasTypeSystemImpl {
    public HSqlTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "DEC" -> "DECIMAL";
            case "INT" -> "INTEGER";
            case "OBJECT" -> "OTHER";
            case "FLOAT" -> "DOUBLE";
            case "REAL" -> "DOUBLE";
            case "DOUBLE PRECISION" -> "DOUBLE";
            case "CHAR" -> "CHARACTER";
            case "CHARACTER VARYING" -> "VARCHAR";
            case "CHAR VARYING" -> "VARCHAR";
            case "CHARACTER LARGE OBJECT" -> "CLOB";
            case "CHAR LARGE OBJECT" -> "CLOB";
            case "VARCHAR_IGNORECASE" -> "VARCHAR";
            case "LONGVARCHAR" -> "VARCHAR";
            case "BINARY VARYING" -> "VARBINARY";
            case "BINARY LARGE OBJECT" -> "BLOB";
            case "LONGVARBINARY" -> "VARBINARY";
            case "DATETIME" -> "TIMESTAMP";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "numeric";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "blob";
            default -> null;
        };
    }

    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "CLOB" -> DasTypeCategory.STRING;
            case "BLOB" -> DasTypeCategory.BYTES;
            case "BIT VARYING" -> DasTypeCategory.INTEGER;
            default -> super.getTypeCategoryByName(typeName);
        };
    }

    @NotNull
    protected HsqlArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new HsqlArrayType(componentType);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

