/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.LongIntOutParam;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u000fH\u0016J;\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000e2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001\u00a2\u0006\u0002\u0010%J)\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000e2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010%JM\u0010&\u001a\u0002H(\"\b\b\u0000\u0010)*\u00020*\"\u0004\b\u0001\u0010(2\u0006\u0010+\u001a\u0002H)2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002H(0\rH\u0014\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u000fH\u0016J\u0016\u00100\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f02H\u0004J\u0010\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000eH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraBaseSession;", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnection;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "traceConsumer", "Lkotlin/Function1;", "", "", "getTraceConsumer", "()Lkotlin/jvm/functions/Function1;", "setTraceConsumer", "(Lkotlin/jvm/functions/Function1;)V", "sessionId", "", "getSessionId", "()J", "setSessionId", "(J)V", "initRemote", "callFunction", "V", "function", "resultParam", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "parameters", "", "(Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "callProcedure", "procedure", "(Ljava/lang/String;[Ljava/lang/Object;)V", "call", "statementText", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "handler", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "close", "silently", "block", "Lkotlin/Function0;", "trace", "message", "intellij.database.dialects.oracle.ex"})
public abstract class OraBaseSession {
    @NotNull
    private final DatabaseConnection connection;
    @NotNull
    private final Logger log;
    @NotNull
    private Function1<? super String, Unit> traceConsumer;
    private long sessionId;

    public OraBaseSession(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        this.connection = connection2;
        this.log = OraConnectionHelperKt.getOurOracleDebuggerLogger();
        this.traceConsumer = (Function1)new Function1<String, Unit>((Object)this.log){

            public final void invoke(String p0) {
                ((Logger)this.receiver).trace(p0);
            }
        };
    }

    @NotNull
    public final DatabaseConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final Function1<String, Unit> getTraceConsumer() {
        return this.traceConsumer;
    }

    public final void setTraceConsumer(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.traceConsumer = function1;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(long l) {
        this.sessionId = l;
    }

    public void initRemote() {
        this.sessionId = ((Number)this.callFunction("userenv('sessionId')", (IndexedOutParameter)new LongIntOutParam(1, 0L, 2, null), new Object[0])).longValue();
    }

    public final <V> V callFunction(@NotNull String function, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return OraConnectionHelperKt.callFunction(this.connection, function, resultParam, Arrays.copyOf(parameters, parameters.length));
    }

    public final void callProcedure(@NotNull String procedure, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)procedure, (String)"procedure");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        OraConnectionHelperKt.callProcedure(this.connection, procedure, Arrays.copyOf(parameters, parameters.length));
    }

    protected final void call(@NotNull String statementText, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        OraConnectionHelperKt.perform(this.connection, statementText, Arrays.copyOf(parameters, parameters.length));
    }

    protected <D extends CallDefinition, R> R call(@NotNull D definition, @NotNull Object[] parameters, @NotNull Function1<? super ResultsProducer, ? extends R> handler2) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return OraConnectionHelperKt.call(this.connection, definition, Arrays.copyOf(parameters, parameters.length), handler2);
    }

    public void close() {
        this.trace("Closing");
    }

    protected final void silently(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            block.invoke();
        }
        catch (Throwable e) {
            this.log.warn(e);
        }
    }

    protected final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.traceConsumer.invoke((Object)message);
    }
}

