/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ui.grid.editors.DefaultTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.util.ui.CalendarView;
import org.jetbrains.annotations.NotNull;

public class DbTimestampEditorFactory
extends DefaultTimestampEditorFactory
implements FactoryWithDomainSupport {
    public DbTimestampEditorFactory(CalendarView.Mode mode) {
        super(mode);
    }

    @NotNull
    protected final LogicalType getExpectedLogicalType() {
        LogicalType logicalType = switch (this.getCalendarMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CalendarView.Mode.DATE -> LogicalType.DATE;
            case CalendarView.Mode.TIME -> LogicalType.TIME;
            case CalendarView.Mode.DATETIME -> LogicalType.TIMESTAMP;
        };
        if (logicalType == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(0);
        }
        return logicalType;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(1);
        }
        if (domain == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(2);
        }
        return domain.getLogicType() == this.getExpectedLogicalType() ? 1 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(4);
        }
        FormatsCache formatsCache = FormatsCache.get((CoreGrid)grid);
        FormatterCreator.FormatterKey key = switch (domain.getLogicType()) {
            case LogicalType.TIME -> FormatterCreator.getTimeKey(null, null, (FormatsCache)formatsCache);
            case LogicalType.DATE -> FormatterCreator.getDateKey(null, null, (FormatsCache)formatsCache);
            default -> FormatterCreator.getTimestampKey((int)3, (FormatsCache)formatsCache);
        };
        Formatter format = (Formatter)FormatterCreator.get((CoreGrid)grid).create(key);
        GridCellEditorFactory.ValueParser valueParser = DbTimestampEditorFactory.getValueParser((Formatter)format, (DataGrid)grid, null, null, null, (text, e) -> UnparsedValueWithDomain.create((String)text, (Domain)domain, (UnparsedValue.ParsingError)e));
        if (valueParser == null) {
            DbTimestampEditorFactory.$$$reportNull$$$0(5);
        }
        return valueParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DbTimestampEditorFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedLogicalType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DbTimestampEditorFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

