/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbModelResolveHelper {
    private static final Logger LOG = Logger.getInstance(DbModelResolveHelper.class);
    protected final DbEditorModelController myController;
    protected final ElementOwner myOwner;
    private static final Comparator<DbEditorModel<?, ?>> PROPS_LAST = (a, b) -> a.getModelInternalKey() == DbObjectModelApplier.ID ? 1 : (b.getModelInternalKey() == DbObjectModelApplier.ID ? -1 : 0);

    protected DbModelResolveHelper(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner) {
        if (controller == null) {
            DbModelResolveHelper.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbModelResolveHelper.$$$reportNull$$$0(1);
        }
        this.myController = controller;
        this.myOwner = owner;
    }

    protected void resolveModels() {
        Collection<DbEditorModel<?, ?>> models = this.myController.getAllModels();
        DbModelResolveHelper.processByTarget(models, DbModelResolveHelper::applyOrder, new ByTargetProcessor(){

            @Override
            public <T extends BasicElement> void process(@NotNull ElementIdentity<T> identity, @NotNull Set<DbEditorModel<T, ?>> models) {
                if (identity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (models == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbModelResolveHelper.this.resolveForTarget(identity, models);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "identity";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "models";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/model/DbModelResolveHelper$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private <T extends BasicElement> void resolveForTarget(ElementIdentity<T> targetId, Iterable<DbEditorModel<T, ?>> models) {
        DbEditorModel<T, DbObjectModelState<T>> objModel = DbModelResolveHelper.getObjectModel(this.myController, targetId, models);
        List<DbEditorModel<T, ?>> sorted = DbModelResolveHelper.sortForApply(models, objModel);
        if (targetId instanceof MultiElementIdentity) {
            this.resolveForTargetImpl((MultiElementIdentity)targetId, (Iterable<DbEditorModel<T, ?>>)sorted);
        } else {
            this.resolveForTargetImpl(targetId, sorted);
        }
    }

    private <T extends BasicElement> void resolveForTargetImpl(@NotNull MultiElementIdentity<T> targetId, @NotNull Iterable<DbEditorModel<T, ?>> models) {
        if (targetId == null) {
            DbModelResolveHelper.$$$reportNull$$$0(2);
        }
        if (models == null) {
            DbModelResolveHelper.$$$reportNull$$$0(3);
        }
        for (DbEditorModel<T, ?> model : models) {
            this.multiResolveModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void multiResolveModel(DbEditorModel<T, S> model) {
        try {
            if (model.getMultiApplier() != null) {
                model.getMultiApplier().resolve(model, this.myOwner);
            } else {
                model.getState().setEnabled(false);
            }
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    private <T extends BasicElement> void resolveForTargetImpl(@NotNull ElementIdentity<T> targetId, @NotNull Iterable<DbEditorModel<T, ?>> models) {
        if (targetId == null) {
            DbModelResolveHelper.$$$reportNull$$$0(4);
        }
        if (models == null) {
            DbModelResolveHelper.$$$reportNull$$$0(5);
        }
        for (DbEditorModel<T, ?> model : models) {
            this.resolveModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void resolveModel(DbEditorModel<T, S> model) {
        try {
            model.getApplier().resolve(model, this.myOwner);
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    protected <T extends BasicElement, S extends DbModelState> void enableModel(DbEditorModel<T, S> model) {
        try {
            model.getApplier().enable(model, this.myOwner);
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    @NotNull
    static <T extends BasicElement> List<DbEditorModel<T, ?>> sortForApply(@NotNull Iterable<DbEditorModel<T, ?>> models, @Nullable DbEditorModel<T, DbObjectModelState<T>> objModel) {
        if (models == null) {
            DbModelResolveHelper.$$$reportNull$$$0(6);
        }
        ArrayList sorted = ContainerUtil.newArrayList(models);
        DbModelResolveHelper.sortByDeps(sorted, true);
        ArrayList arrayList = sorted;
        if (arrayList == null) {
            DbModelResolveHelper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static <T extends BasicElement> DbEditorModel<T, DbObjectModelState<T>> getObjectModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<T> targetId, @NotNull Iterable<DbEditorModel<T, ?>> models) {
        DbEditorModel objModel;
        if (controller == null) {
            DbModelResolveHelper.$$$reportNull$$$0(8);
        }
        if (targetId == null) {
            DbModelResolveHelper.$$$reportNull$$$0(9);
        }
        if (models == null) {
            DbModelResolveHelper.$$$reportNull$$$0(10);
        }
        if ((objModel = controller.getObjectModel(targetId)) == null) {
            DbEditorModel model;
            objModel = model = (DbEditorModel)ContainerUtil.find(models, m -> m.getModelInternalKey() == DbObjectModelApplier.ID);
        }
        return objModel;
    }

    static <T extends BasicElement> void sortByDeps(List<DbEditorModel<T, ?>> models, boolean fwd) {
        HashSet deps = new HashSet();
        for (DbEditorModel<T, ?> model : models) {
            DbModelResolveHelper.extractDependencies(deps, model);
        }
        Comparator comparator = (a, b) -> deps.contains(Couple.of((Object)a, (Object)b)) ? -1 : (deps.contains(Couple.of((Object)b, (Object)a)) ? 1 : 0);
        models.sort(PROPS_LAST.thenComparing(fwd ? comparator : comparator.reversed()));
    }

    private static <T extends BasicElement, S extends DbModelState> void extractDependencies(Set<Couple<DbEditorModel<?, ?>>> deps, DbEditorModel<T, S> model) {
        for (DbEditorModel<?, ?> dep : model.getApplier().getDependencies(model)) {
            deps.add(Couple.of(dep, model));
        }
    }

    static void processByTarget(@NotNull Iterable<DbEditorModel<?, ?>> models, @NotNull Comparator<ElementIdentity<?>> order, @NotNull ByTargetProcessor processor2) {
        if (models == null) {
            DbModelResolveHelper.$$$reportNull$$$0(11);
        }
        if (order == null) {
            DbModelResolveHelper.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            DbModelResolveHelper.$$$reportNull$$$0(13);
        }
        Map byId = ContainerUtil.classify(models.iterator(), DbEditorModel::getIdentity);
        List sorted = ContainerUtil.sorted(byId.keySet(), order);
        for (ElementIdentity identity : sorted) {
            processor2.process(identity, (Set)byId.get(identity));
        }
    }

    static int applyOrder(ElementIdentity<?> a, ElementIdentity<?> b) {
        int n;
        int res2 = DbModelResolveHelper.multiFirst(a, b);
        if (res2 != 0) {
            return res2;
        }
        if (a instanceof Comparable) {
            Comparable ac = (Comparable)a;
            n = -ac.compareTo(b);
        } else {
            n = 0;
        }
        return n;
    }

    static int multiFirst(ElementIdentity<?> a, ElementIdentity<?> b) {
        boolean aMulti = a instanceof MultiElementIdentity;
        boolean bMulti = b instanceof MultiElementIdentity;
        return aMulti == bMulti ? 0 : (aMulti ? -1 : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbModelResolveHelper";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelResolveHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortForApply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveForTargetImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortForApply";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getObjectModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processByTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    static interface ByTargetProcessor {
        public <T extends BasicElement> void process(@NotNull ElementIdentity<T> var1, @NotNull Set<DbEditorModel<T, ?>> var2);
    }
}

