/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceScope
extends GlobalSearchScope
implements WeighedItem,
ColoredItem {
    public static final BadgeIconSupplier BADGED_DBMS = new BadgeIconSupplier(DatabaseIcons.Dbms);
    public static final String ALL = "all";
    public static final String CONTEXT = "context";
    public static final String CONNECTED = "connected";
    private final String myScopeId;
    @Nls
    private final String myDisplayName;
    private final Icon myIcon;
    private final int myWeight;
    private final Color myColor;
    private final Condition<? super String> myIdCondition;
    private final Set<VirtualFile> myDdlFiles;

    public DbDataSourceScope(@NotNull Project project, @NonNls @NotNull String scopeId, @Nls @NotNull String displayName, @Nullable Icon icon, int weight, @Nullable Color color, @NotNull Condition<? super String> myIdCondition, @NotNull Set<VirtualFile> myDdlFiles) {
        if (project == null) {
            DbDataSourceScope.$$$reportNull$$$0(0);
        }
        if (scopeId == null) {
            DbDataSourceScope.$$$reportNull$$$0(1);
        }
        if (displayName == null) {
            DbDataSourceScope.$$$reportNull$$$0(2);
        }
        if (myIdCondition == null) {
            DbDataSourceScope.$$$reportNull$$$0(3);
        }
        if (myDdlFiles == null) {
            DbDataSourceScope.$$$reportNull$$$0(4);
        }
        super(project);
        this.myScopeId = scopeId;
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myWeight = weight;
        this.myColor = color;
        this.myIdCondition = myIdCondition;
        this.myDdlFiles = myDdlFiles;
    }

    public String toString() {
        return this.getScopeId();
    }

    @NotNull
    public String getScopeId() {
        String string = this.myScopeId;
        if (string == null) {
            DbDataSourceScope.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean contains(DasDataSource dataSource) {
        return this.myIdCondition.value((Object)dataSource.getUniqueId());
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            DbDataSourceScope.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            DbDataSourceScope.$$$reportNull$$$0(7);
        }
        return !this.myDdlFiles.isEmpty();
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            DbDataSourceScope.$$$reportNull$$$0(8);
        }
        if (file instanceof DatabaseElementVirtualFileImpl && this.myIdCondition.value((Object)((DatabaseElementVirtualFileImpl)file).getDataSourceId())) {
            return true;
        }
        if (DbSrcUtilsCore.isDbSrcFile((VirtualFile)file) && this.myIdCondition.value((Object)DbSrcUtilsCore.getDataSource((VirtualFile)file))) {
            return true;
        }
        if (RootType.forFile((VirtualFile)file) instanceof DbConsoleRootType && this.myIdCondition.value((Object)DbVFSUtils.getDataSourceId((VirtualFile)file))) {
            return true;
        }
        return ContainerUtil.exists(this.myDdlFiles, r -> VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)file, (boolean)false));
    }

    public int getWeight() {
        return this.myWeight;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myIdCondition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDdlFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DbDataSourceScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DbDataSourceScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

