/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.Version;
import com.intellij.database.view.RenameHelper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameQueryGenerator {
    private final Project myProject;
    private final BasicModel myModel;
    private final BasicNamedElement myElement;
    private final BasicModModel myTargetModel;
    private final BasicModNamedElement myTargetElement;
    private final ScriptGenerator myScriptGenerator;
    private final List<ElementDelta<?>> myCorrespondence;
    private final RenameHelper myRenameHelper;
    private BasicNamespace myCurrentNamespace;
    private ScriptingOptions myOptions;

    public RenameQueryGenerator(@NotNull Project project, @NotNull BasicModel model, @NotNull BasicNamedElement element) {
        if (project == null) {
            RenameQueryGenerator.$$$reportNull$$$0(0);
        }
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RenameQueryGenerator.$$$reportNull$$$0(2);
        }
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.myProject = project;
        this.myModel = model;
        this.myElement = element;
        this.myTargetModel = new ModelFactory((ModelTextStorage)new MemoryTextStorage()).createModel(model.getMetaModel().dbms);
        this.myCorrespondence = new ArrayList();
        this.myTargetElement = (BasicModNamedElement)ModelLightCopier.copy((BasicModModel)this.myTargetModel, (BasicElement)element, (boolean)true);
        this.myTargetModel.modify(BasicModRoot.class, r -> this.myTargetModel.basicTraverser().forEach(BasicMetaUtils::makeResolved));
        this.myTargetElement.setNameSurrogate(false);
        this.myTargetElement.setNameScripted(true);
        this.myTargetElement.setNameQuoted(false);
        BasicNamedElement e1 = this.myElement;
        for (BasicModNamedElement e2 = this.myTargetElement; e1 != null && e2 != null; e1 = e1.getParent(), e2 = e2.getParent()) {
            if (e1.getKind() == ObjectKind.ROOT) continue;
            this.myCorrespondence.add(ElementDelta.create((BasicElement)e1, (BasicElement)e2));
        }
        this.myScriptGenerator = ScriptGenerators.INSTANCE.byModel(model);
        this.myRenameHelper = new RenameHelper(this.myProject, this.myTargetModel);
    }

    public void setQuoted(boolean quoted) {
        this.myTargetElement.setNameQuoted(quoted);
    }

    public void setOptions(@NotNull ScriptingOptions o) {
        if (o == null) {
            RenameQueryGenerator.$$$reportNull$$$0(3);
        }
        this.myOptions = o;
    }

    @NotNull
    public ScriptingOptions getOptions() {
        ScriptingOptions scriptingOptions = this.myOptions;
        if (scriptingOptions == null) {
            RenameQueryGenerator.$$$reportNull$$$0(4);
        }
        return scriptingOptions;
    }

    @NotNull
    public ScriptingResult generate(@NotNull String newName, @Nullable Version ver) {
        if (newName == null) {
            RenameQueryGenerator.$$$reportNull$$$0(5);
        }
        this.myTargetModel.modify(BasicModRoot.class, r -> this.myRenameHelper.rename(this.myTargetElement, newName));
        ScriptingResult scriptingResult = this.myScriptGenerator.makeScript(this.myProject, (ScriptingTask)this.createTask(ver));
        if (scriptingResult == null) {
            RenameQueryGenerator.$$$reportNull$$$0(6);
        }
        return scriptingResult;
    }

    public void setScripted(boolean scripted) {
        this.myTargetElement.setNameScripted(scripted);
    }

    public static boolean canRename(@NotNull BasicModel model, @NotNull BasicNamedElement element) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RenameQueryGenerator.$$$reportNull$$$0(8);
        }
        return RenameQueryGenerator.canRename(model, element, model.getRoot().getServerVersion());
    }

    public static boolean canRename(@NotNull BasicModel model, @NotNull BasicNamedElement element, @Nullable Version ver) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(9);
        }
        if (element == null) {
            RenameQueryGenerator.$$$reportNull$$$0(10);
        }
        return (Boolean)RenameQueryGenerator.getCapabilities(model, (BasicElement)element).getRename().get(ver);
    }

    public boolean isRenamed() {
        return !this.myTargetElement.getName().equals(this.myElement.getName());
    }

    @NotNull
    public ScriptingResult generate(@NotNull String newName) {
        if (newName == null) {
            RenameQueryGenerator.$$$reportNull$$$0(11);
        }
        ScriptingResult scriptingResult = this.generate(newName, this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            RenameQueryGenerator.$$$reportNull$$$0(12);
        }
        return scriptingResult;
    }

    @NotNull
    public static ScriptingCapabilities getCapabilities(@NotNull BasicModel model, @NotNull BasicElement element) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(13);
        }
        if (element == null) {
            RenameQueryGenerator.$$$reportNull$$$0(14);
        }
        ScriptingCapabilities scriptingCapabilities = ScriptGenerators.INSTANCE.byModel(model).capabilities(element);
        if (scriptingCapabilities == null) {
            RenameQueryGenerator.$$$reportNull$$$0(15);
        }
        return scriptingCapabilities;
    }

    @NotNull
    public BasicNamedElement getTargetElement() {
        BasicModNamedElement basicModNamedElement = this.myTargetElement;
        if (basicModNamedElement == null) {
            RenameQueryGenerator.$$$reportNull$$$0(16);
        }
        return basicModNamedElement;
    }

    @NotNull
    public ScriptingAlterTask createTask(@Nullable Version ver) {
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(this.myModel, (BasicModel)this.myTargetModel);
        builder.setCorrespondence(this.myCorrespondence);
        builder.setCurrentNamespace(this.myCurrentNamespace);
        builder.setOptions(this.myOptions);
        if (ver != null) {
            builder.setVersion(ver);
        }
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            RenameQueryGenerator.$$$reportNull$$$0(17);
        }
        return scriptingAlterTask;
    }

    @Nullable
    public BasicElement getCurrentNamespace() {
        return this.myCurrentNamespace;
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        assert (currentNamespace == null || this.myModel.contains((DasObject)currentNamespace));
        this.myCurrentNamespace = currentNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 12, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/RenameQueryGenerator";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/RenameQueryGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRename";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCapabilities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 12, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

