/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.clickhouse.CHouseDdlParsing;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.CHouseDmlParsing;
import com.intellij.sql.dialects.clickhouse.CHouseExpressionParsing;
import com.intellij.sql.dialects.clickhouse.CHouseGeneratedParser;
import com.intellij.sql.dialects.clickhouse.CHouseGeneratedParserUtil;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseParser
extends SqlParser {
    public static final SqlSuggestedInjection CH_INJECTION = new SqlSuggestedInjection("ClickHouse");

    public CHouseParser() {
        super((SqlLanguageDialectEx)CHouseDialect.INSTANCE);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        return !first2 && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_IDENT_DELIMITED) || super.allowNoopStringConcatenation(builder, first2);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return CHouseGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, CHouseExpressionParsing::evaluable_expression);
    }

    protected boolean parseDataTypeExt(PsiBuilder builder) {
        return this.parseTableDataType(builder) || this.parseDataType(builder, 0, true);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return CHouseGeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return CHouseGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CHouseDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? CHouseDdlParsing.type_element_ext(builder, level) : CHouseDdlParsing.type_element(builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = CHouseExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    @NotNull
    public PsiBuilder adaptBuilder(IElementType root, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = CHouseGeneratedParserUtil.adapt_builder_(root, initialBuilder, (PsiParser)this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            CHouseParser.$$$reportNull$$$0(0);
        }
        return psiBuilder;
    }

    public boolean allowIdentifierSplit(SqlReferenceElementType refType) {
        return refType == SQL_COLUMN_REFERENCE || refType == SQL_COLUMN_SHORT_REFERENCE || refType == SQL_REFERENCE || refType == SQL_OPTIONAL_REFERENCE;
    }

    public IElementType getSplitIdentifierStart() {
        return CHouseTokens.CH_DELIMITED_TOKEN_START;
    }

    public IElementType getSplitIdentifierEnd() {
        return CHouseTokens.CH_DELIMITED_TOKEN_END;
    }

    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        return this.parsePossiblySplitIdentifier(builder, refType, CHouseTokens.CH_DELIMITED_TOKEN_START, CHouseTokens.CH_DELIMITED_TOKEN_END, (b, l) -> super.parseIdentifierInner(b, optional, allowKeywords, allowCharSetSpec, refType));
    }

    protected boolean allowAnyIdentifierInOdbc() {
        return true;
    }

    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return CH_INJECTION;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, CHouseExpressionParsing::parenthesized_values_expr, CHouseDmlParsing::top_query_expression, CHouseParser::parseTopQueryExpressionTail, CHouseExpressionParsing::row_element_list, (b, l) -> CHouseExpressionParsing.root_expr_0(b, l, -1) && CHouseExpressionParsing.row_element_list_separator(b, l) && CHouseExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return CHouseDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (refType == SQL_PARTITION_REFERENCE) {
            return CHouseGeneratedParser.partition_reference(builder, 0);
        }
        return super.parseReferenceExpressionInner(builder, optional, force, refType);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        CHouseGeneratedParser.analytic_clause(builder, level);
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            super.parseFunctionCallTail(builder, level);
        }
        return true;
    }

    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, BuiltinFunction definition, boolean plain, boolean ignoreParens, Set<BuiltinFunction.Location> locations) {
        PsiElement element = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder);
        PsiElement next = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)SQL_ARGUMENT_LIST, null);
        if (next == null) {
            return super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain, ignoreParens, locations);
        }
        if (!"true".equals(definition.getDialectAttribute("aggregate"))) {
            return false;
        }
        assert (definition.getPrototypes().length == 1);
        BuiltinFunction.Prototype proto2 = definition.getPrototypes()[0];
        BuiltinFunction.Parameter head = proto2.getHeadBlock();
        if (head == null) {
            return false;
        }
        boolean opt = head instanceof BuiltinFunction.ParameterBlock && ((BuiltinFunction.ParameterBlock)head).getBlockType() == BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE;
        SqlParser.FunctionParsingContext context = new SqlParser.FunctionParsingContext();
        PsiBuilder.Marker m = builder.mark();
        int offset = builder.getCurrentOffset();
        boolean ok2 = this.parseFunctionParameter(builder, level, head, context);
        if (opt && offset == builder.getCurrentOffset()) {
            m.rollbackTo();
            return false;
        }
        if (!ok2 || !builder.eof()) {
            this.parseSimpleArguments(builder, level, context);
        }
        m.drop();
        return true;
    }

    public boolean canBeCalled(IElementType type) {
        return type == SQL_ARGUMENT_LIST || super.canBeCalled(type);
    }

    protected Boolean parseSimpleParameter(PsiBuilder builder, int level, BuiltinFunction.Type type) {
        if (type == CHouseDialect.Types.ANY_NA) {
            return CHouseExpressionParsing.value_expression_na(builder, level);
        }
        if (type == CHouseDialect.Types.STRING_OR_TOKEN || type == CHouseDialect.Types.STRING_OR_SCHEMA) {
            PsiBuilder.Marker mark = builder.mark();
            if (this.consumeIdentifier(builder, true, false) && (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_PERIOD) || builder.eof() || SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_COMMA))) {
                if (type == CHouseDialect.Types.STRING_OR_SCHEMA) {
                    mark.done((IElementType)SQL_SCHEMA_REFERENCE);
                } else {
                    mark.drop();
                }
                return true;
            }
            mark.rollbackTo();
            return CHouseExpressionParsing.value_expression_na(builder, level);
        }
        return super.parseSimpleParameter(builder, level, type);
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return CHouseGeneratedParser.table_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        CHouseDmlParsing.query_expression_0(builder, level, -1);
        return CHouseDmlParsing.left_inner_table_op_tail(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/clickhouse/CHouseParser", "adaptBuilder"));
    }
}

