/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundTaskConsumer {
    public static final ExtensionPointName<BackgroundTaskConsumer> EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.consumer");

    public abstract boolean isAvailable(@NotNull PsiFile var1);

    @NotNull
    public abstract TaskOptions getOptionsTemplate();

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            BackgroundTaskConsumer.$$$reportNull$$$0(0);
        }
        if (options == null) {
            BackgroundTaskConsumer.$$$reportNull$$$0(1);
        }
    }

    @NlsContexts.Label
    public String getConsumeMessage() {
        TaskOptions options = this.getOptionsTemplate();
        return StringUtil.isEmpty((String)options.getDescription()) ? BackgroundTaskBundle.message("editor.notification.question.available.for.file", options.getName()) : BackgroundTaskBundle.message("editor.notification.question.available.for.file.with.description", options.getName(), options.getDescription());
    }

    public void configureWithLastOptions(TaskOptions options, @Nullable TaskOptions defaultOptions) {
        boolean noProgram = StringUtil.isEmpty((String)options.getProgram());
        if (noProgram && defaultOptions != null) {
            options.setProgram(defaultOptions.getProgram());
        }
    }

    @Nullable
    public static FileTypeBackgroundTaskConsumer findConsumerByFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            BackgroundTaskConsumer.$$$reportNull$$$0(2);
        }
        return (FileTypeBackgroundTaskConsumer)EP_NAME.getByKey((Object)fileType, BackgroundTaskConsumer.class, consumer -> consumer instanceof FileTypeBackgroundTaskConsumer ? ((FileTypeBackgroundTaskConsumer)consumer).getFileType() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/config/BackgroundTaskConsumer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "additionalConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findConsumerByFileType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

