/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.beans;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeEnvironment;
import com.intellij.docker.agent.compose.beans.DockerComposeVersion;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.util.Version;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00062\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/compose/beans/DockerComposeDeserializer;", "", "<init>", "()V", "Configuration", "Environment", "Companion", "intellij.clouds.docker.agent"})
public final class DockerComposeDeserializer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final ObjectMapper mapper;

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        ObjectMapper $this$mapper_u24lambda_u240 = objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));
        boolean bl = false;
        SimpleModule module = new SimpleModule();
        module.addDeserializer(DockerComposeConfiguration.class, (JsonDeserializer)new Configuration());
        module.addDeserializer(DockerComposeEnvironment.class, (JsonDeserializer)new Environment());
        $this$mapper_u24lambda_u240.registerModule((Module)module);
        mapper = objectMapper;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/compose/beans/DockerComposeDeserializer$Companion;", "", "<init>", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDockerComposeConfigurationVersion", "Lcom/intellij/docker/agent/compose/beans/DockerComposeVersion;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        @NotNull
        public final DockerComposeVersion getDockerComposeConfigurationVersion(@NotNull JsonNode node, @NotNull JsonParser parser) throws JsonMappingException {
            DockerComposeVersion dockerComposeVersion;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            JsonNode versionField = node.get("version");
            if (versionField != null && versionField.isTextual()) {
                String string;
                String version2 = versionField.textValue();
                Intrinsics.checkNotNull((Object)version2);
                Version version3 = Version.Companion.from(version2);
                String string2 = string = version3 != null ? Integer.valueOf(version3.getMajor()).toString() : null;
                if (!Intrinsics.areEqual((Object)string, (Object)"2") && !Intrinsics.areEqual((Object)string, (Object)"3")) {
                    throw JsonMappingException.from((JsonParser)parser, (String)("Unsupported docker compose configuration version: " + version2));
                }
                dockerComposeVersion = new DockerComposeVersion.Explicit(version2);
            } else {
                dockerComposeVersion = node.has("services") ? (DockerComposeVersion)DockerComposeVersion.Implicit.INSTANCE : (DockerComposeVersion)DockerComposeVersion.V1.INSTANCE;
            }
            return dockerComposeVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/compose/beans/DockerComposeDeserializer$Configuration;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.clouds.docker.agent"})
    public static final class Configuration
    extends JsonDeserializer<DockerComposeConfiguration> {
        @NotNull
        public DockerComposeConfiguration deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            DockerComposeConfiguration dockerComposeConfiguration;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TreeNode treeNode = jp.getCodec().readTree(jp);
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
            JsonNode node = (JsonNode)treeNode;
            DockerComposeVersion dockerComposeVersion = Companion.getDockerComposeConfigurationVersion(node, jp);
            if (dockerComposeVersion instanceof DockerComposeVersion.Explicit || Intrinsics.areEqual((Object)dockerComposeVersion, (Object)DockerComposeVersion.Implicit.INSTANCE)) {
                Object object = Companion.getMapper().treeToValue((TreeNode)node, DockerComposeConfigurationV2.class);
                Intrinsics.checkNotNull((Object)object);
                dockerComposeConfiguration = (DockerComposeConfiguration)object;
            } else if (dockerComposeVersion instanceof DockerComposeVersion.V1) {
                Object object = Companion.getMapper().treeToValue((TreeNode)node, DockerComposeConfigurationV1.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"treeToValue(...)");
                dockerComposeConfiguration = (DockerComposeConfiguration)object;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return dockerComposeConfiguration;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/compose/beans/DockerComposeDeserializer$Environment;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/docker/agent/compose/beans/DockerComposeEnvironment;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.clouds.docker.agent"})
    public static final class Environment
    extends JsonDeserializer<DockerComposeEnvironment> {
        @NotNull
        public DockerComposeEnvironment deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            DockerComposeEnvironment dockerComposeEnvironment;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TreeNode treeNode = jp.readValueAsTree();
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readValueAsTree(...)");
            JsonNode node = (JsonNode)treeNode;
            if (node.isArray()) {
                CollectionType type = context.getTypeFactory().constructCollectionType(List.class, String.class);
                Object object = Companion.getMapper().convertValue((Object)node, (JavaType)type);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertValue(...)");
                List list = (List)object;
                DockerComposeEnvironment dockerComposeEnvironment2 = DockerComposeEnvironment.fromList(list);
                Intrinsics.checkNotNull((Object)dockerComposeEnvironment2);
                dockerComposeEnvironment = dockerComposeEnvironment2;
            } else if (node.isObject()) {
                MapType type = context.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
                Object object = Companion.getMapper().convertValue((Object)node, (JavaType)type);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertValue(...)");
                Map map2 = (Map)object;
                DockerComposeEnvironment dockerComposeEnvironment3 = DockerComposeEnvironment.fromMap(map2);
                Intrinsics.checkNotNull((Object)dockerComposeEnvironment3);
                dockerComposeEnvironment = dockerComposeEnvironment3;
            } else {
                throw JsonMappingException.from((JsonParser)context.getParser(), (String)"Environment is expected to be either dictionary or list");
            }
            return dockerComposeEnvironment;
        }
    }
}

