/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeFilePathReferenceProvider
extends StaticPathReferenceProvider {
    private Function<PsiFile, Collection<PsiFileSystemItem>> myDefaultPathEvaluator;
    private boolean myOnlyFolders;
    private Function<String, Boolean> myPriorityEvaluator;

    public ComposeFilePathReferenceProvider() {
        this(null);
    }

    public ComposeFilePathReferenceProvider(FileType @Nullable [] suitableFileTypes) {
        super(suitableFileTypes);
        this.setEndingSlashNotAllowed(false);
        this.setRelativePathsAllowed(true);
    }

    public ComposeFilePathReferenceProvider withOnlyFolders(boolean onlyFolders) {
        this.myOnlyFolders = onlyFolders;
        return this;
    }

    public ComposeFilePathReferenceProvider withDefaultPathEvaluator(@NotNull DefaultPathEvaluator defaultPathEvaluator) {
        if (defaultPathEvaluator == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(0);
        }
        this.myDefaultPathEvaluator = defaultPathEvaluator;
        return this;
    }

    public ComposeFilePathReferenceProvider withPriorityEvaluator(Function<String, Boolean> priorityEvaluator) {
        this.myPriorityEvaluator = priorityEvaluator;
        return this;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<? super PsiReference> references, final boolean soft) {
        if (psiElement == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (references == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(2);
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, false, null){

            protected boolean isSoft() {
                return soft;
            }

            public boolean couldBeConvertedTo(boolean relative) {
                return false;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return ComposeFilePathReferenceProvider.this.myOnlyFolders ? DIRECTORY_FILTER : Conditions.alwaysTrue();
            }
        };
        if (this.myDefaultPathEvaluator != null) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, this.myDefaultPathEvaluator);
        }
        if (this.myPriorityEvaluator != null) {
            PsiReference[] prioritized = (PsiReference[])Stream.of(set.getAllReferences()).map(ref -> new PrioritizedFileReference((FileReference)ref, this.myPriorityEvaluator)).toArray(PsiReference[]::new);
            Collections.addAll(references, prioritized);
            return true;
        }
        Collections.addAll(references, set.getAllReferences());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPathEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFilePathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withDefaultPathEvaluator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PrioritizedFileReference
    extends FileReference {
        private final Function<String, Boolean> myPriorityEvaluator;

        private PrioritizedFileReference(FileReference original, Function<String, Boolean> myPriorityEvaluator) {
            super(original);
            this.myPriorityEvaluator = myPriorityEvaluator;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = Stream.of(super.getVariants()).map(variant -> {
                if (variant instanceof LookupElement && ((Boolean)this.myPriorityEvaluator.apply((Object)((LookupElement)variant).getLookupString())).booleanValue()) {
                    return PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)variant), (double)1.0);
                }
                return variant;
            }).toArray();
            if (objectArray == null) {
                PrioritizedFileReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/composeFile/ComposeFilePathReferenceProvider$PrioritizedFileReference", "getVariants"));
        }
    }

    @FunctionalInterface
    public static interface DefaultPathEvaluator
    extends Function<PsiFile, Collection<PsiFileSystemItem>> {
    }
}

