/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.configuration.wizard;

import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetIntrospectableUtil;
import com.intellij.openapi.util.NlsSafe;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u0002H\u0016J\u0006\u0010\r\u001a\u00020\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/remote/run/target/configuration/wizard/OutputConsumer;", "Ljava/util/function/Consumer;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "<init>", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "accept", "", "chunk", "getOutput", "intellij.clouds.docker.remoteRun"})
public final class OutputConsumer
implements Consumer<String> {
    @NotNull
    private final TtySink ttySink;
    @NotNull
    private final StringBuilder stringBuilder;

    public OutputConsumer(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void accept(@NlsSafe @NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.stringBuilder.append(chunk);
        this.ttySink.ttyPrint(DockerTargetIntrospectableUtil.normalizeNewLines(chunk));
    }

    @NotNull
    public final String getOutput() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

