/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.utils.CollectionUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.ModulesUtilsKt;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H&J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H&J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0014JF\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00150\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0014J\\\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001b0!0 \"\b\b\u0000\u0010\"*\u00020#\"\b\b\u0001\u0010$*\u00020#*\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H$0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002JV\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00150\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH&J\u0018\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u000bH\u0004\u00a8\u00060"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "<init>", "()V", "search", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getIndicatorText", "", "Lorg/jetbrains/annotations/Nls;", "getEndpointTypesToSearch", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "getModulesToSearch", "", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "findModulesEndpointUrls", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "modulesToSearch", "", "endpointTypesToSearch", "getAllEndpointsUrlsByModules", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "G", "", "E", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "modules", "fromLibraries", "", "fromTests", "findRequestsToEndpointUrls", "clientModules", "moduleToEndpoints", "isAppropriateReference", "reference", "Lcom/intellij/psi/PsiReference;", "intellij.microservices.ui.diagrams"})
@SourceDebugExtension(value={"SMAP\nRequestsToEndpointUrlsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToEndpointUrlsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n3829#2:106\n4344#2,2:107\n1011#3:109\n1045#3,3:110\n1048#3,3:120\n382#4,7:113\n1374#5:123\n1460#5,2:124\n1374#5:126\n1460#5,2:127\n1563#5:129\n1634#5,3:130\n1462#5,3:133\n1462#5,3:136\n*S KotlinDebug\n*F\n+ 1 RequestsToEndpointUrlsSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher\n*L\n54#1:106\n54#1:107,2\n72#1:109\n72#1:110,3\n72#1:120,3\n72#1:113,7\n81#1:123\n81#1:124,2\n82#1:126\n82#1:127,2\n85#1:129\n85#1:130,3\n82#1:133,3\n81#1:136,3\n*E\n"})
public abstract class RequestsToEndpointUrlsSearcher
implements RequestsSearcher {
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> search(@NotNull MsDiagramSeed seed, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        if (!(seed instanceof MsDiagramWholeProjectSeed)) {
            MutableNetwork mutableNetwork = NetworkBuilder.directed().build();
            Intrinsics.checkNotNullExpressionValue((Object)mutableNetwork, (String)"build(...)");
            return (Network)mutableNetwork;
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWholeProjectSeed)seed).getProject();
        List<Module> modules = this.getModulesToSearch(project, searchParams);
        Map<Module, List<UrlTargetInfo>> moduleToEndpoints = this.findModulesEndpointUrls((Iterable<? extends Module>)modules, this.getEndpointTypesToSearch(), project, searchParams);
        return this.findRequestsToEndpointUrls(modules, moduleToEndpoints, project, searchParams, indicator);
    }

    @NotNull
    public abstract String getIndicatorText();

    @NotNull
    public abstract Set<EndpointType> getEndpointTypesToSearch();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Module> getModulesToSearch(@NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Object[] allModules = ModuleManager.Companion.getInstance(project).getModules();
        if (searchParams.getFromTests()) {
            list = ArraysKt.toList((Object[])allModules);
        } else {
            void $this$filterTo$iv$iv;
            Object[] $this$filter$iv = allModules;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!ModulesUtilsKt.getContainsTestsOnly((Module)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<Module, List<UrlTargetInfo>> findModulesEndpointUrls(@NotNull Iterable<? extends Module> modulesToSearch, @NotNull Set<EndpointType> endpointTypesToSearch, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(modulesToSearch, (String)"modulesToSearch");
        Intrinsics.checkNotNullParameter(endpointTypesToSearch, (String)"endpointTypesToSearch");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)CollectionUtilsKt.chunkedUnderReadAction((Sequence)ActionsKt.runReadAction(() -> RequestsToEndpointUrlsSearcher.findModulesEndpointUrls$lambda$3(project, endpointTypesToSearch, this, modulesToSearch, searchParams)), 50, RequestsToEndpointUrlsSearcher::findModulesEndpointUrls$lambda$4)));
        boolean $i$f$groupBy = false;
        void var7_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = false;
            Module key$iv$iv = (Module)it2.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((UrlTargetInfo)it.getSecond());
        }
        return destination$iv$iv;
    }

    private final <G, E> Sequence<Pair<Module, UrlTargetInfo>> getAllEndpointsUrlsByModules(EndpointsProvider<G, E> $this$getAllEndpointsUrlsByModules, Iterable<? extends Module> modules, boolean fromLibraries, boolean fromTests) {
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence(modules), arg_0 -> RequestsToEndpointUrlsSearcher.getAllEndpointsUrlsByModules$lambda$10($this$getAllEndpointsUrlsByModules, fromLibraries, fromTests, arg_0));
    }

    @NotNull
    public abstract Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> var1, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> var2, @NotNull Project var3, @NotNull RequestsSearcher.SearchParams var4, @Nullable ProgressIndicator var5);

    protected final boolean isAppropriateReference(@NotNull PsiReference reference, @NotNull RequestsSearcher.SearchParams searchParams) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        return reference instanceof UrlPathReference && !((UrlPathReference)reference).getContext().isDeclaration() && (searchParams.getFromTests() || !TestSourcesFilter.isTestSources((VirtualFile)((UrlPathReference)reference).getElement().getContainingFile().getVirtualFile(), (Project)((UrlPathReference)reference).getElement().getProject()));
    }

    private static final boolean findModulesEndpointUrls$lambda$3$lambda$1(Set $endpointTypesToSearch, EndpointsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $endpointTypesToSearch.contains(it.getEndpointType());
    }

    private static final Sequence findModulesEndpointUrls$lambda$3$lambda$2(RequestsToEndpointUrlsSearcher this$0, Iterable $modulesToSearch, RequestsSearcher.SearchParams $searchParams, EndpointsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getAllEndpointsUrlsByModules(it, $modulesToSearch, $searchParams.getFromLibraries(), $searchParams.getFromTests());
    }

    private static final Sequence findModulesEndpointUrls$lambda$3(Project $project, Set $endpointTypesToSearch, RequestsToEndpointUrlsSearcher this$0, Iterable $modulesToSearch, RequestsSearcher.SearchParams $searchParams) {
        return SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)EndpointsProvider.Companion.getAvailableProviders($project), arg_0 -> RequestsToEndpointUrlsSearcher.findModulesEndpointUrls$lambda$3$lambda$1($endpointTypesToSearch, arg_0)), arg_0 -> RequestsToEndpointUrlsSearcher.findModulesEndpointUrls$lambda$3$lambda$2(this$0, $modulesToSearch, $searchParams, arg_0));
    }

    private static final List findModulesEndpointUrls$lambda$4(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getAllEndpointsUrlsByModules$lambda$10(EndpointsProvider $this_getAllEndpointsUrlsByModules, boolean $fromLibraries, boolean $fromTests, Module module) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$flatMap$iv = $this_getAllEndpointsUrlsByModules.getEndpointGroups(project, (EndpointsFilter)new ModuleEndpointsFilter(module, $fromLibraries, $fromTests));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv$iv;
            Object group = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$flatMap$iv2 = $this_getAllEndpointsUrlsByModules.getEndpoints(group);
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable3;
                Object element$iv$iv2;
                Object endpoint = element$iv$iv2 = iterator2.next();
                boolean bl2 = false;
                Object object = $this_getAllEndpointsUrlsByModules instanceof EndpointsUrlTargetProvider ? (EndpointsUrlTargetProvider)$this_getAllEndpointsUrlsByModules : null;
                object = object != null && (iterable3 = object.getUrlTargetInfo(group, endpoint)) != null ? iterable3 : (Iterable)CollectionsKt.emptyList();
                boolean $i$f$map = false;
                void var24_25 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UrlTargetInfo urlTargetInfo = (UrlTargetInfo)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl3 = false;
                    collection.add(new Pair((Object)module, (Object)it));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

